/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.usecpluginaaa.impl;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.usecpluginaaa.impl.UsecpluginAAAStore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptFromIPInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptFromIPOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptFromIPOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptOnDateTimeInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptOnDateTimeOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.AttemptOnDateTimeOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.Security;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.UsecpluginaaaService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.security.Loginattempts;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCImpl
implements UsecpluginaaaService {
    private static final Logger LOG = LoggerFactory.getLogger(RPCImpl.class);
    AttemptOnDateTimeOutputBuilder attemptOnDateTimeOutputBuilder = new AttemptOnDateTimeOutputBuilder();
    AttemptFromIPOutputBuilder attemptFromIPOutputBuilder = new AttemptFromIPOutputBuilder();
    private static DataBroker dataBroker;
    UsecpluginAAAStore usecpluginAAAStore = new UsecpluginAAAStore();
    List<Loginattempts> loginattempts = new ArrayList<Loginattempts>();

    public DataBroker getdataBroker() {
        return dataBroker;
    }

    public void setdataBroker(DataBroker dataBroker) {
        RPCImpl.dataBroker = dataBroker;
    }

    public Future<RpcResult<AttemptFromIPOutput>> attemptFromIP(AttemptFromIPInput input) {
        Boolean value = false;
        String time = "";
        String attempt = "";
        String content = "";
        String listOfSource_IP = "";
        try {
            this.usecpluginAAAStore.setdataBroker(dataBroker);
            InstanceIdentifier instanceIdentifier = InstanceIdentifier.create(Security.class);
            ReadOnlyTransaction readTransaction = dataBroker.newReadOnlyTransaction();
            this.loginattempts = ((Security)((Optional)readTransaction.read(LogicalDatastoreType.OPERATIONAL, instanceIdentifier).checkedGet()).get()).getLoginattempts();
            String inputSrcIP = input.getSrcIP();
            for (Loginattempts loginattempt : this.loginattempts) {
                listOfSource_IP = loginattempt.getSrcIP();
                if (!listOfSource_IP.matches(inputSrcIP)) continue;
                value = true;
                content = content + loginattempt.getAttempt() + "  on " + loginattempt.getTime() + ",";
            }
            if (value.booleanValue()) {
                this.attemptFromIPOutputBuilder.setLoginAttempt(content);
                LOG.info(content);
            } else {
                this.attemptFromIPOutputBuilder.setLoginAttempt("No Attempts");
                LOG.info("No Attempts from given IP");
            }
        }
        catch (Exception e) {
            System.out.print("Caught the NullPointerException");
        }
        return RpcResultBuilder.success((Object)this.attemptFromIPOutputBuilder.build()).buildFuture();
    }

    public Future<RpcResult<AttemptOnDateTimeOutput>> attemptOnDateTime(AttemptOnDateTimeInput input) {
        Boolean value = false;
        String time = "";
        String attempt = "";
        String content = "";
        String listOfStoredTime = "";
        try {
            this.usecpluginAAAStore.setdataBroker(dataBroker);
            InstanceIdentifier instanceIdentifier = InstanceIdentifier.create(Security.class);
            ReadOnlyTransaction readTransaction = dataBroker.newReadOnlyTransaction();
            this.loginattempts = ((Security)((Optional)readTransaction.read(LogicalDatastoreType.OPERATIONAL, instanceIdentifier).checkedGet()).get()).getLoginattempts();
            String inputDateTime = input.getDateTime();
            for (Loginattempts loginattempt : this.loginattempts) {
                listOfStoredTime = loginattempt.getTime();
                if (!listOfStoredTime.matches(inputDateTime)) continue;
                value = true;
                content = content + loginattempt.getAttempt() + "  on " + loginattempt.getTime();
            }
            if (value.booleanValue()) {
                this.attemptOnDateTimeOutputBuilder.setLoginAttempt(content);
                LOG.info(content);
            } else {
                this.attemptOnDateTimeOutputBuilder.setLoginAttempt("No Attempts");
                LOG.info("No Attempts on given dateTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return RpcResultBuilder.success((Object)this.attemptOnDateTimeOutputBuilder.build()).buildFuture();
    }
}

