/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.usecpluginaaa.impl;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.Security;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.SecurityBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.security.Loginattempts;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.security.LoginattemptsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.usecpluginaaa.rev150105.security.LoginattemptsKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsecpluginAAAStore {
    private static final Logger LOG = LoggerFactory.getLogger(UsecpluginAAAStore.class);
    private static DataBroker dataBroker;
    LoginattemptsBuilder loginattemptsBuilder = new LoginattemptsBuilder();
    List<Loginattempts> loginattemptlist = new ArrayList<Loginattempts>();
    SecurityBuilder securitybuilder = new SecurityBuilder();

    public DataBroker getdataBroker() {
        return dataBroker;
    }

    public void setdataBroker(DataBroker dataBroker) {
        UsecpluginAAAStore.dataBroker = dataBroker;
    }

    public void addData(String time, String srcIP, String attempt) {
        LoginattemptsKey key = new LoginattemptsKey(time);
        this.loginattemptsBuilder.setKey(key);
        InstanceIdentifier instanceIdentifier = InstanceIdentifier.builder(Security.class).child(Loginattempts.class, (Identifier)this.loginattemptsBuilder.getKey()).build();
        WriteTransaction writeTransaction = dataBroker.newWriteOnlyTransaction();
        this.loginattemptsBuilder.setTime(time);
        this.loginattemptsBuilder.setSrcIP(srcIP);
        this.loginattemptsBuilder.setAttempt(attempt);
        Loginattempts loginattempt = this.loginattemptsBuilder.build();
        this.loginattemptlist.add(loginattempt);
        this.securitybuilder.setLoginattempts(this.loginattemptlist);
        Security security = this.securitybuilder.build();
        writeTransaction.merge(LogicalDatastoreType.OPERATIONAL, instanceIdentifier, (DataObject)loginattempt);
        writeTransaction.commit();
        LOG.debug("Data Store Element is Created for key ", (Object)srcIP);
        LOG.info(" login attempts" + loginattempt.getTime() + " " + loginattempt.getSrcIP() + loginattempt.getAttempt());
    }
}

