/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.JavaFileTemplate;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.TypeMember;

abstract class AbstractBaseTemplate
extends JavaFileTemplate {
    AbstractBaseTemplate(@NonNull GeneratedType type) {
        super(type);
    }

    AbstractBaseTemplate(AbstractJavaGeneratedType javaType, GeneratedType type) {
        super(javaType, type);
    }

    final @NonNull String generate() {
        StringBuilder sb = new StringBuilder().append("package ").append(this.type().getPackageName()).append(";\n");
        CharSequence body = this.body();
        String importBlock = this.generateImportBlock();
        if (!importBlock.isEmpty()) {
            sb.append(importBlock).append('\n');
        }
        return sb.append(body).toString();
    }

    abstract @NonNull CharSequence body();

    static final @NonNull String fieldName(GeneratedProperty property) {
        return "_" + property.getName();
    }

    static final @NonNull String getterMethodName(@NonNull String propName) {
        return "get" + Naming.toFirstUpper((String)propName);
    }

    static final @NonNull String getterMethodName(GeneratedProperty field) {
        return AbstractBaseTemplate.getterMethodName(field.getName());
    }

    static final @NonNull List<GeneratedProperty> keyConstructorArgs(GeneratedTransferObject keyType) {
        return keyType.getProperties().stream().sorted(Comparator.comparing(TypeMember::getName)).collect(Collectors.toList());
    }
}

