/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.yangtools.binding.codegen.AbstractBaseTemplate;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.BaseTemplate;
import org.opendaylight.yangtools.binding.codegen.BuilderGeneratedProperty;
import org.opendaylight.yangtools.binding.codegen.JavaFileTemplate;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;

public abstract class AbstractBuilderTemplate
extends BaseTemplate {
    protected final Type augmentType;
    protected final Set<BuilderGeneratedProperty> properties;
    protected final GeneratedTransferObject keyType;
    protected final GeneratedType targetType;

    public AbstractBuilderTemplate(AbstractJavaGeneratedType javaType, GeneratedType type, GeneratedType targetType, Set<BuilderGeneratedProperty> properties, Type augmentType, GeneratedTransferObject keyType) {
        super(javaType, type);
        this.targetType = targetType;
        this.properties = properties;
        this.augmentType = augmentType;
        this.keyType = keyType;
    }

    public AbstractBuilderTemplate(GeneratedType type, GeneratedType targetType, GeneratedTransferObject keyType) {
        super(type);
        this.targetType = targetType;
        this.keyType = keyType;
        Map.Entry<Type, Set<BuilderGeneratedProperty>> analysis = JavaFileTemplate.analyzeTypeHierarchy(targetType);
        this.augmentType = analysis.getKey();
        this.properties = analysis.getValue();
    }

    protected final CharSequence generateFields(boolean makeFinal) {
        StringConcatenation _builder = new StringConcatenation();
        if (this.properties != null) {
            for (BuilderGeneratedProperty f : this.properties) {
                _builder.append("private");
                if (makeFinal) {
                    _builder.append(" final");
                }
                _builder.append(" ");
                String _importedName = this.importedName(f.getReturnType());
                _builder.append(_importedName);
                _builder.append(" ");
                String _fieldName = AbstractBaseTemplate.fieldName(f);
                _builder.append(_fieldName);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        if (this.keyType != null && !makeFinal) {
            _builder.append("private ");
            String _importedName_1 = this.importedName((Type)this.keyType);
            _builder.append(_importedName_1);
            _builder.append(" key;");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public final CharSequence generateGetters(boolean addOverride) {
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        if (this.keyType != null) {
            if (addOverride) {
                _builder.append("@");
                String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
                _builder.append(_importedName);
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Return current value associated with the property corresponding to {@link ");
                String _importedName_1 = this.importedName((Type)this.targetType);
                _builder.append(_importedName_1, " ");
                _builder.append("#");
                _builder.append("key", " ");
                _builder.append("()}.");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* @return current value");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
            }
            _builder.append("public ");
            String _importedName_2 = this.importedName((Type)this.keyType);
            _builder.append(_importedName_2);
            _builder.append(" ");
            _builder.append("key");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return key;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        boolean bl = _not = !(_isEmpty = this.properties.isEmpty());
        if (_not) {
            boolean _hasElements = false;
            for (BuilderGeneratedProperty field : this.properties) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                if (addOverride) {
                    _builder.append("@");
                    String _importedName_3 = this.importedName(JavaFileTemplate.OVERRIDE);
                    _builder.append(_importedName_3);
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("/**");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* Return current value associated with the property corresponding to {@link ");
                    String _importedName_4 = this.importedName((Type)this.targetType);
                    _builder.append(_importedName_4, " ");
                    _builder.append("#");
                    String _getterName = field.getGetterName();
                    _builder.append(_getterName, " ");
                    _builder.append("()}.");
                    _builder.newLineIfNotEmpty();
                    _builder.append(" ");
                    _builder.append("*");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("* @return current value");
                    _builder.newLine();
                    _builder.append(" ");
                    _builder.append("*/");
                    _builder.newLine();
                }
                CharSequence _terMethod = this.getterMethod(field);
                _builder.append((Object)_terMethod);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected final CharSequence generateCopyConstructor(Type fromType, Type implType) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append("(final ");
        String _importedName = this.importedName(fromType);
        _builder.append(_importedName);
        _builder.append(" base) {");
        _builder.newLineIfNotEmpty();
        if (this.augmentType != null) {
            _builder.append("    ");
            CharSequence _generateCopyAugmentation = this.generateCopyAugmentation(implType);
            _builder.append((Object)_generateCopyAugmentation, "    ");
            _builder.newLineIfNotEmpty();
        }
        if (this.keyType != null && this.implementsIfc(this.targetType, (Type)BindingTypes.entryObject((Type)this.targetType, (Type)this.keyType))) {
            _builder.append("    ");
            List<GeneratedProperty> keyProps = AbstractBaseTemplate.keyConstructorArgs(this.keyType);
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            ArrayList<BuilderGeneratedProperty> allProps = new ArrayList<BuilderGeneratedProperty>(this.properties);
            _builder.newLineIfNotEmpty();
            for (GeneratedProperty field : keyProps) {
                _builder.append("    ");
                this.removeProperty(allProps, field.getName());
                _builder.newLineIfNotEmpty();
            }
            _builder.append("    ");
            CharSequence _generateCopyKeys = this.generateCopyKeys(keyProps);
            _builder.append((Object)_generateCopyKeys, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            CharSequence _generateCopyNonKeys = this.generateCopyNonKeys(allProps);
            _builder.append((Object)_generateCopyNonKeys, "    ");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("    ");
            CharSequence _generateCopyNonKeys_1 = this.generateCopyNonKeys(this.properties);
            _builder.append((Object)_generateCopyNonKeys_1, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected final CharSequence generateDeprecatedAnnotation(List<AnnotationType> annotations) {
        AnnotationType found = AbstractBuilderTemplate.findDeprecatedAnnotation(annotations);
        if (found == null) {
            return "";
        }
        return this.generateDeprecatedAnnotation(found);
    }

    protected abstract CharSequence generateCopyKeys(List<GeneratedProperty> var1);

    protected abstract CharSequence generateCopyNonKeys(Collection<BuilderGeneratedProperty> var1);

    protected abstract CharSequence generateCopyAugmentation(Type var1);

    protected abstract CharSequence generateDeprecatedAnnotation(AnnotationType var1);

    private boolean implementsIfc(GeneratedType type, Type impl) {
        List _implements = type.getImplements();
        for (Type ifc : _implements) {
            boolean _equals = ifc.equals((Object)impl);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    private void removeProperty(Collection<BuilderGeneratedProperty> props, String name) {
        Iterator<BuilderGeneratedProperty> iter = props.iterator();
        while (iter.hasNext()) {
            boolean _equals = name.equals(iter.next().getName());
            if (!_equals) continue;
            iter.remove();
            return;
        }
    }

    private static AnnotationType findDeprecatedAnnotation(List<AnnotationType> annotations) {
        if (annotations != null) {
            for (AnnotationType annotation : annotations) {
                boolean _equals = JavaFileTemplate.DEPRECATED.equals(annotation.getIdentifier());
                if (!_equals) continue;
                return annotation;
            }
        }
        return null;
    }

    static boolean hasNonDefaultMethods(GeneratedType type) {
        return !type.getMethodDefinitions().isEmpty() && IterableExtensions.exists((Iterable)type.getMethodDefinitions(), def -> {
            boolean _isDefault = def.isDefault();
            return !_isDefault;
        });
    }

    static Iterable<MethodSignature> nonDefaultMethods(GeneratedType type) {
        Functions.Function1 _function = def -> {
            boolean _isDefault = def.isDefault();
            return !_isDefault;
        };
        return IterableExtensions.filter((Iterable)type.getMethodDefinitions(), (Functions.Function1)_function);
    }
}

