/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.codegen.AbstractBaseTemplate;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.AbstractRangeGenerator;
import org.opendaylight.yangtools.binding.codegen.JavaFileTemplate;
import org.opendaylight.yangtools.binding.codegen.LengthGenerator;
import org.opendaylight.yangtools.binding.generator.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Restrictions;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.TypeComment;
import org.opendaylight.yangtools.binding.model.api.TypeMemberComment;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public abstract class BaseTemplate
extends AbstractBaseTemplate {
    private static final char NEW_LINE = '\n';
    private static final char SPACE = ' ';
    private static final CharMatcher WS_MATCHER = CharMatcher.anyOf((CharSequence)"\n\t");
    private static final Pattern SPACES_PATTERN = Pattern.compile(" +");
    private static final Splitter NL_SPLITTER = Splitter.on((char)'\n');

    public BaseTemplate(GeneratedType type) {
        super(type);
    }

    public BaseTemplate(AbstractJavaGeneratedType javaType, GeneratedType type) {
        super(javaType, type);
    }

    protected CharSequence getterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        String methodName = AbstractBaseTemplate.getterMethodName(field);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName = this.importedName(field.getReturnType());
        _builder.append(_importedName);
        _builder.append(" ");
        _builder.append(methodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.newLineIfNotEmpty();
        boolean _endsWith = field.getReturnType().getName().endsWith("[]");
        if (_endsWith) {
            _builder.append("    ");
            _builder.append("return ");
            _builder.append(fieldName, "    ");
            _builder.append(" == null ? null : ");
            _builder.append(fieldName, "    ");
            _builder.append(".clone();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("    ");
            _builder.append("return ");
            _builder.append(fieldName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected final CharSequence setterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        String returnType = this.importedName(field.getReturnType());
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.append(" set");
        String _firstUpper = StringExtensions.toFirstUpper((String)field.getName());
        _builder.append(_firstUpper);
        _builder.append("(");
        _builder.append(returnType);
        _builder.append(" value) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("this.");
        String _fieldName = AbstractBaseTemplate.fieldName(field);
        _builder.append(_fieldName, "    ");
        _builder.append(" = value;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return this;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected final CharSequence asArgumentsDeclaration(Iterable<GeneratedProperty> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty(parameters);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedProperty parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _importedName = this.importedName(parameter.getReturnType());
                _builder.append(_importedName);
                _builder.append(" ");
                String _fieldName = AbstractBaseTemplate.fieldName(parameter);
                _builder.append(_fieldName);
            }
        }
        return _builder;
    }

    protected final CharSequence asNonNullArgumentsDeclaration(Iterable<GeneratedProperty> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty(parameters);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (GeneratedProperty parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _importedNonNull = this.importedNonNull(parameter.getReturnType());
                _builder.append(_importedNonNull);
                _builder.append(" ");
                String _fieldName = AbstractBaseTemplate.fieldName(parameter);
                _builder.append(_fieldName);
            }
        }
        return _builder;
    }

    protected final CharSequence asArguments(Collection<GeneratedProperty> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedProperty parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _fieldName = AbstractBaseTemplate.fieldName(parameter);
                _builder.append(_fieldName);
            }
        }
        return _builder;
    }

    protected final String asJavadoc(TypeMemberComment comment) {
        if (comment == null) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        String _contractDescription = comment.contractDescription();
        _builder.append(_contractDescription);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _formatReference = BaseTemplate.formatReference(comment.referenceDescription());
        _builder.append((Object)_formatReference);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeSignature = comment.typeSignature();
        _builder.append(_typeSignature);
        _builder.newLineIfNotEmpty();
        return BaseTemplate.wrapToDocumentation(_builder.toString());
    }

    public static String wrapToDocumentation(String text) {
        boolean _isEmpty = text.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append("/**\n");
        Iterable _split = NL_SPLITTER.split((CharSequence)text);
        for (String t : _split) {
            boolean _not;
            sb.append(" *");
            boolean _isEmpty_1 = t.isEmpty();
            boolean bl = _not = !_isEmpty_1;
            if (_not) {
                sb.append(' ').append(t);
            }
            sb.append('\n');
        }
        sb.append(" */");
        return sb.toString();
    }

    protected String formatDataForJavaDoc(GeneratedType type) {
        boolean _notEquals;
        StringBuilder sb = new StringBuilder();
        TypeComment comment = type.getComment();
        if (comment != null) {
            sb.append(comment.getJavadoc());
        }
        this.appendSnippet(sb, type);
        StringConcatenation _builder = new StringConcatenation();
        int _length = sb.length();
        boolean bl = _notEquals = _length != 0;
        if (_notEquals) {
            String _string = sb.toString();
            _builder.append(_string);
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected String formatDataForJavaDoc(GeneratedType type, String additionalComment) {
        TypeComment comment = type.getComment();
        if (comment == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(additionalComment);
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        StringBuilder sb = new StringBuilder().append(comment.getJavadoc());
        this.appendSnippet(sb, type);
        sb.append('\n').append('\n').append('\n').append(additionalComment);
        StringConcatenation _builder_1 = new StringConcatenation();
        String _string = sb.toString();
        _builder_1.append(_string);
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }

    public static CharSequence formatReference(String reference) {
        StringConcatenation _builder = new StringConcatenation();
        if (reference != null) {
            _builder.append("<pre>");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("<code>");
            _builder.newLine();
            _builder.append("        ");
            String _formatToParagraph = BaseTemplate.formatToParagraph(BindingGeneratorUtil.encodeAngleBrackets((String)reference));
            _builder.append(_formatToParagraph, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("</code>");
            _builder.newLine();
            _builder.append("</pre>");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public String asLink(String text) {
        StringBuilder sb = new StringBuilder();
        String tempText = text;
        char lastChar = ' ';
        boolean badEnding = false;
        if (text.endsWith(".") || text.endsWith(":") || text.endsWith(",")) {
            int _length = text.length();
            int _minus = _length - 1;
            tempText = text.substring(0, _minus);
            int _length_1 = text.length();
            int _minus_1 = _length_1 - 1;
            lastChar = text.charAt(_minus_1);
            badEnding = true;
        }
        sb.append("<a href = \"").append(tempText).append("\">").append(tempText).append("</a>");
        if (badEnding) {
            sb.append(lastChar);
        }
        return sb.toString();
    }

    protected static String formatToParagraph(String inputText) {
        StringBuilder sb = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        boolean isFirstElementOnNewLineEmptyChar = false;
        String formattedText = WS_MATCHER.replaceFrom((CharSequence)JavaFileTemplate.encodeJavadocSymbols(inputText), ' ');
        formattedText = SPACES_PATTERN.matcher(formattedText).replaceAll(" ");
        StringTokenizer tokenizer = new StringTokenizer(formattedText, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String nextElement = tokenizer.nextToken();
            if (lineBuilder.length() != 0 && lineBuilder.length() + nextElement.length() > 80) {
                boolean _equals;
                int _length = lineBuilder.length();
                int _minus = _length - 1;
                char _charAt = lineBuilder.charAt(_minus);
                boolean bl = _equals = _charAt == ' ';
                if (_equals) {
                    int _length_1 = lineBuilder.length();
                    int _minus_1 = _length_1 - 1;
                    lineBuilder.setLength(_minus_1);
                }
                if (lineBuilder.length() != 0 && lineBuilder.charAt(0) == ' ') {
                    lineBuilder.deleteCharAt(0);
                }
                sb.append((CharSequence)lineBuilder).append('\n');
                lineBuilder.setLength(0);
                boolean _equals_1 = " ".equals(nextElement);
                if (_equals_1) {
                    boolean bl2 = isFirstElementOnNewLineEmptyChar = !isFirstElementOnNewLineEmptyChar;
                }
            }
            if (isFirstElementOnNewLineEmptyChar) {
                isFirstElementOnNewLineEmptyChar = !isFirstElementOnNewLineEmptyChar;
                continue;
            }
            lineBuilder.append(nextElement);
        }
        return sb.append((CharSequence)lineBuilder).append('\n').toString();
    }

    protected CharSequence generateParameters(List<MethodSignature.Parameter> parameters) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (MethodSignature.Parameter parameter : parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _importedName = this.importedName(parameter.getType());
                _builder.append(_importedName);
                _builder.append(" ");
                String _name = parameter.getName();
                _builder.append(_name);
            }
        }
        return _builder;
    }

    protected CharSequence emitConstant(Constant c) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _equals = "QNAME".equals(c.getName());
        if (_equals) {
            Object _value = c.getValue();
            Map.Entry entry = (Map.Entry)_value;
            _builder.newLineIfNotEmpty();
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* YANG identifier of the statement represented by this class.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("public static final ");
            String _importedNonNull = this.importedNonNull(c.getType());
            _builder.append(_importedNonNull);
            _builder.append(" ");
            String _name = c.getName();
            _builder.append(_name);
            _builder.append(" = ");
            String _importedName = this.importedName((JavaTypeName)entry.getKey());
            _builder.append(_importedName);
            _builder.append(".");
            _builder.append("qnameOf");
            _builder.append("(\"");
            String _value_1 = (String)entry.getValue();
            _builder.append(_value_1);
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _equals_1 = "NAME".equals(c.getName());
            if (_equals_1) {
                Object _value_2 = c.getValue();
                Map.Entry entry_1 = (Map.Entry)_value_2;
                _builder.newLineIfNotEmpty();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Yang Data template name of the statement represented by this class.");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("public static final ");
                String _importedNonNull_1 = this.importedNonNull(c.getType());
                _builder.append(_importedNonNull_1);
                _builder.append(" ");
                String _name_1 = c.getName();
                _builder.append(_name_1);
                _builder.append(" = ");
                String _importedName_1 = this.importedName((JavaTypeName)entry_1.getKey());
                _builder.append(_importedName_1);
                _builder.append(".");
                _builder.append("yangDataNameOf");
                _builder.append("(\"");
                String _name_2 = ((YangDataName)entry_1.getValue()).name();
                _builder.append(_name_2);
                _builder.append("\");");
                _builder.newLineIfNotEmpty();
            } else if ("VALUE".equals(c.getName()) && BaseIdentity.class.equals(c.getValue())) {
                String typeName = this.importedName(c.getType());
                _builder.newLineIfNotEmpty();
                String override = this.importedName(JavaFileTemplate.OVERRIDE);
                _builder.newLineIfNotEmpty();
                _builder.append("/**");
                _builder.newLine();
                _builder.append(" ");
                _builder.append("* Singleton value representing the {@link ");
                _builder.append(typeName, " ");
                _builder.append("} identity.");
                _builder.newLineIfNotEmpty();
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("public static final ");
                String _importedNonNull_2 = this.importedNonNull(c.getType());
                _builder.append(_importedNonNull_2);
                _builder.append(" ");
                String _name_3 = c.getName();
                _builder.append(_name_3);
                _builder.append(" = new ");
                _builder.append(typeName);
                _builder.append("() {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("@java.io.Serial");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("private static final long serialVersionUID = 1L;");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@");
                _builder.append(override, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public ");
                String _importedName_2 = this.importedName(JavaFileTemplate.CLASS);
                _builder.append(_importedName_2, "    ");
                _builder.append("<");
                _builder.append(typeName, "    ");
                _builder.append("> ");
                _builder.append("implementedInterface", "    ");
                _builder.append("() {");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("return ");
                _builder.append(typeName, "        ");
                _builder.append(".class;");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@");
                _builder.append(override, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public int hashCode() {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return ");
                _builder.append(typeName, "        ");
                _builder.append(".class.hashCode();");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@");
                _builder.append(override, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public boolean equals(final ");
                String _importedName_3 = this.importedName((Type)Types.objectType());
                _builder.append(_importedName_3, "    ");
                _builder.append(" obj) {");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("return obj == this || obj instanceof ");
                _builder.append(typeName, "        ");
                _builder.append(" other");
                _builder.newLineIfNotEmpty();
                _builder.append("            ");
                _builder.append("&& ");
                _builder.append(typeName, "            ");
                _builder.append(".class.equals(other.");
                _builder.append("implementedInterface", "            ");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@");
                _builder.append(override, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("public ");
                String _importedName_4 = this.importedName((Type)Types.STRING);
                _builder.append(_importedName_4, "    ");
                _builder.append(" toString() {");
                _builder.newLineIfNotEmpty();
                _builder.append("        ");
                _builder.append("return ");
                String _importedName_5 = this.importedName(JavaFileTemplate.MOREOBJECTS);
                _builder.append(_importedName_5, "        ");
                _builder.append(".toStringHelper(\"");
                String _name_4 = c.getType().getName();
                _builder.append(_name_4, "        ");
                _builder.append("\").add(\"qname\", QNAME).toString();");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("    ");
                _builder.append("@java.io.Serial");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("private Object readResolve() throws java.io.ObjectStreamException {");
                _builder.newLine();
                _builder.append("        ");
                _builder.append("return ");
                String _name_5 = c.getName();
                _builder.append(_name_5, "        ");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
                _builder.append("};");
                _builder.newLine();
            } else {
                _builder.append("public static final ");
                String _importedName_6 = this.importedName(c.getType());
                _builder.append(_importedName_6);
                _builder.append(" ");
                String _name_6 = c.getName();
                _builder.append(_name_6);
                _builder.append(" = ");
                Object _value_3 = c.getValue();
                _builder.append(_value_3);
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    protected CharSequence generateCheckers(GeneratedProperty field, Restrictions restrictions, Type actualType) {
        boolean _isPresent_1;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPresent = restrictions.getRangeConstraint().isPresent();
        if (_isPresent) {
            String _generateRangeChecker = AbstractRangeGenerator.forType(actualType).generateRangeChecker(StringExtensions.toFirstUpper((String)field.getName()), (RangeConstraint)restrictions.getRangeConstraint().orElseThrow(), this);
            _builder.append(_generateRangeChecker);
            _builder.newLineIfNotEmpty();
        }
        if (_isPresent_1 = restrictions.getLengthConstraint().isPresent()) {
            String _generateLengthChecker = LengthGenerator.generateLengthChecker(AbstractBaseTemplate.fieldName(field), actualType, (LengthConstraint)restrictions.getLengthConstraint().orElseThrow(), this);
            _builder.append(_generateLengthChecker);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence checkArgument(GeneratedProperty property, Restrictions restrictions, Type actualType, String value) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPresent = restrictions.getRangeConstraint().isPresent();
        if (_isPresent) {
            if (actualType instanceof ConcreteType) {
                String _generateRangeCheckerCall = AbstractRangeGenerator.forType(actualType).generateRangeCheckerCall(StringExtensions.toFirstUpper((String)property.getName()), value);
                _builder.append(_generateRangeCheckerCall);
                _builder.newLineIfNotEmpty();
            } else {
                String _generateRangeCheckerCall_1 = AbstractRangeGenerator.forType(actualType).generateRangeCheckerCall(StringExtensions.toFirstUpper((String)property.getName()), value + ".getValue()");
                _builder.append(_generateRangeCheckerCall_1);
                _builder.newLineIfNotEmpty();
            }
        }
        String fieldName = AbstractBaseTemplate.fieldName(property);
        _builder.newLineIfNotEmpty();
        boolean _isPresent_1 = restrictions.getLengthConstraint().isPresent();
        if (_isPresent_1) {
            if (actualType instanceof ConcreteType) {
                String _generateLengthCheckerCall = LengthGenerator.generateLengthCheckerCall(fieldName, value);
                _builder.append(_generateLengthCheckerCall);
                _builder.newLineIfNotEmpty();
            } else {
                String _generateLengthCheckerCall_1 = LengthGenerator.generateLengthCheckerCall(fieldName, value + ".getValue()");
                _builder.append(_generateLengthCheckerCall_1);
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        String fieldUpperCase = fieldName.toUpperCase(Locale.ROOT);
        _builder.newLineIfNotEmpty();
        List _constantDefinitions = this.type().getConstantDefinitions();
        for (Constant currentConstant : _constantDefinitions) {
            if (!currentConstant.getName().startsWith("PATTERN_CONSTANTS") || !fieldUpperCase.equals(currentConstant.getName().substring("PATTERN_CONSTANTS".length()))) continue;
            String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName);
            _builder.append(".checkPattern(value, ");
            _builder.append("patterns");
            _builder.append(fieldName);
            _builder.append(", ");
            _builder.append("regexes");
            _builder.append(fieldName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected final CharSequence generateAnnotation(AnnotationType annotation) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName((Type)annotation);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        if (annotation.getParameters() != null && !annotation.getParameters().isEmpty()) {
            _builder.append("(");
            _builder.newLine();
            List _parameters = annotation.getParameters();
            boolean _hasElements = false;
            for (AnnotationType.Parameter param : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _name = param.getName();
                _builder.append(_name);
                _builder.append("=");
                String _value = param.getValue();
                _builder.append(_value);
                _builder.newLineIfNotEmpty();
            }
            _builder.append(")");
            _builder.newLine();
        }
        return _builder;
    }
}

