/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.VerifyException;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.YangData;
import org.opendaylight.yangtools.binding.codegen.BuilderTemplate;
import org.opendaylight.yangtools.binding.model.api.CodeGenerator;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.CodegenGeneratedTOBuilder;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.CodegenGeneratedTypeBuilder;

public final class BuilderGenerator
implements CodeGenerator {
    private static final JavaTypeName AUGMENTABLE = JavaTypeName.create(Augmentable.class);
    private static final JavaTypeName AUGMENTATION = JavaTypeName.create(Augmentation.class);
    private static final JavaTypeName ENTRY_OBJECT = JavaTypeName.create(EntryObject.class);
    private static final JavaTypeName YANG_DATA = JavaTypeName.create(YangData.class);

    public boolean isAcceptable(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            if (!(type instanceof GeneratedTransferObject)) {
                for (Type impl : generated.getImplements()) {
                    JavaTypeName name = (JavaTypeName)impl.getIdentifier();
                    if (!name.equals((Object)AUGMENTABLE) && !name.equals((Object)AUGMENTATION) && !name.equals((Object)ENTRY_OBJECT) && !name.equals((Object)YANG_DATA)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String generate(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            if (!(type instanceof GeneratedTransferObject)) {
                return BuilderGenerator.templateForType(generated).generate();
            }
        }
        return "";
    }

    public String getUnitName(Type type) {
        return type.getName() + "Builder";
    }

    @VisibleForTesting
    static BuilderTemplate templateForType(GeneratedType type) {
        JavaTypeName origName = (JavaTypeName)type.getIdentifier();
        JavaTypeName builderName = origName.createSibling(origName.simpleName() + "Builder");
        return new BuilderTemplate(((GeneratedTypeBuilder)new CodegenGeneratedTypeBuilder(builderName).addEnclosingTransferObject(((GeneratedTOBuilder)new CodegenGeneratedTOBuilder(builderName.createEnclosed(origName.simpleName() + "Impl")).addImplementsType((Type)type)).build())).build(), type, BuilderGenerator.getKey(type));
    }

    private static GeneratedTransferObject getKey(GeneratedType type) {
        for (MethodSignature method : type.getMethodDefinitions()) {
            if (!"key".equals(method.getName())) continue;
            Type keyType = method.getReturnType();
            if (keyType instanceof GeneratedTransferObject) {
                GeneratedTransferObject gto = (GeneratedTransferObject)keyType;
                return gto;
            }
            throw new VerifyException("Unexpected key type " + String.valueOf(keyType));
        }
        return null;
    }
}

