/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.annotations.Beta;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.TypeMember;
import org.opendaylight.yangtools.binding.model.ri.BaseYangTypes;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

@Beta
final class ByTypeMemberComparator<T extends TypeMember>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int RANK_FIXED_SIZE = 0;
    private static final int RANK_VARIABLE_ARRAY = 1;
    private static final int RANK_INSTANCE_IDENTIFIER = 2;
    private static final int RANK_COMPOSITE = 3;
    private static final Set<Type> FIXED_TYPES = Set.of(BaseYangTypes.INT8_TYPE, BaseYangTypes.INT16_TYPE, BaseYangTypes.INT32_TYPE, BaseYangTypes.INT64_TYPE, BaseYangTypes.DECIMAL64_TYPE, BaseYangTypes.UINT8_TYPE, BaseYangTypes.UINT16_TYPE, BaseYangTypes.UINT32_TYPE, BaseYangTypes.UINT64_TYPE, BaseYangTypes.BOOLEAN_TYPE, BaseYangTypes.EMPTY_TYPE);
    private static final @NonNull ByTypeMemberComparator<?> INSTANCE = new ByTypeMemberComparator();

    private ByTypeMemberComparator() {
    }

    public static <T extends TypeMember> ByTypeMemberComparator<T> getInstance() {
        return INSTANCE;
    }

    public static <T extends TypeMember> Collection<T> sort(Collection<T> input) {
        if (input.size() < 2) {
            return input;
        }
        ArrayList<T> ret = new ArrayList<T>(input);
        ret.sort(ByTypeMemberComparator.getInstance());
        return ret;
    }

    @Override
    public int compare(T member1, T member2) {
        int cmp;
        Type type1 = ByTypeMemberComparator.getConcreteType(member1.getReturnType());
        Type type2 = ByTypeMemberComparator.getConcreteType(member2.getReturnType());
        if (!((JavaTypeName)type1.getIdentifier()).equals(type2.getIdentifier()) && (cmp = ByTypeMemberComparator.rankOf(type1) - ByTypeMemberComparator.rankOf(type2)) != 0) {
            return cmp;
        }
        return member1.getName().compareTo(member2.getName());
    }

    private Object readResolve() {
        return INSTANCE;
    }

    private static Type getConcreteType(Type type) {
        if (type instanceof ConcreteType) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType generated = (ParameterizedType)type;
            return generated.getRawType();
        }
        if (type instanceof GeneratedTransferObject) {
            GeneratedTransferObject gto;
            GeneratedTransferObject rootGto = gto = (GeneratedTransferObject)type;
            while (rootGto.getSuperType() != null) {
                rootGto = rootGto.getSuperType();
            }
            for (GeneratedProperty s : rootGto.getProperties()) {
                if (!"value".equals(s.getName())) continue;
                return s.getReturnType();
            }
        }
        return type;
    }

    private static int rankOf(Type type) {
        GeneratedTransferObject gto;
        TypeDefinition typedef;
        if (FIXED_TYPES.contains(type) || BindingTypes.isIdentityType((Type)type)) {
            return 0;
        }
        if (type.equals((Object)BaseYangTypes.STRING_TYPE) || type.equals((Object)Types.BYTE_ARRAY)) {
            return 1;
        }
        if (type.equals((Object)BaseYangTypes.INSTANCE_IDENTIFIER)) {
            return 2;
        }
        if (type instanceof GeneratedTransferObject && (typedef = ByTypeMemberComparator.topParentTransportObject(gto = (GeneratedTransferObject)type).getBaseType()) instanceof BitsTypeDefinition) {
            return 1;
        }
        return 3;
    }

    private static GeneratedTransferObject topParentTransportObject(GeneratedTransferObject type) {
        GeneratedTransferObject ret = type;
        GeneratedTransferObject parent = ret.getSuperType();
        while (parent != null) {
            ret = parent;
            parent = ret.getSuperType();
        }
        return ret;
    }
}

