/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.opendaylight.yangtools.binding.codegen.AbstractRangeGenerator;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

final class Decimal64RangeGenerator
extends AbstractRangeGenerator<Decimal64> {
    Decimal64RangeGenerator() {
        super(Decimal64.class);
    }

    private static String range(Function<Class<?>, String> classImporter) {
        return classImporter.apply(Range.class);
    }

    private static String itemType(Function<Class<?>, String> classImporter) {
        return Decimal64RangeGenerator.range(classImporter) + "<" + classImporter.apply(Decimal64.class) + ">";
    }

    private static String arrayType(Function<Class<?>, String> classImporter) {
        return Decimal64RangeGenerator.itemType(classImporter) + "[]";
    }

    private static String format(Function<Class<?>, String> classImporter, Decimal64 value) {
        return classImporter.apply(Decimal64.class) + ".of(" + value.scale() + ", " + value.unscaledValue() + "L)";
    }

    @Override
    @Deprecated
    protected Decimal64 convert(Number value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Uint8 || value instanceof Uint16) {
            return Decimal64.valueOf((int)1, (int)value.intValue());
        }
        return Decimal64.valueOf((int)1, (long)value.longValue());
    }

    @Override
    protected String generateRangeCheckerImplementation(String checkerName, RangeConstraint<?> constraint, Function<Class<?>, String> classImporter) {
        Set constraints = constraint.getAllowedRanges().asRanges();
        String fieldName = checkerName.toUpperCase(Locale.ENGLISH) + "_RANGES";
        StringBuilder sb = new StringBuilder();
        sb.append("private static final ").append(Decimal64RangeGenerator.arrayType(classImporter)).append(' ').append(fieldName).append(";\n");
        sb.append("static {\n");
        sb.append("    @SuppressWarnings(\"unchecked\")\n");
        sb.append("    final ").append(Decimal64RangeGenerator.arrayType(classImporter)).append(" a = (").append(Decimal64RangeGenerator.arrayType(classImporter)).append(") ").append(classImporter.apply(Array.class)).append(".newInstance(").append(Decimal64RangeGenerator.range(classImporter)).append(".class, ").append(constraints.size()).append(");\n");
        int offset = 0;
        for (Range r : constraints) {
            String min = Decimal64RangeGenerator.format(classImporter, (Decimal64)this.getValue((Number)((Object)r.lowerEndpoint())));
            String max = Decimal64RangeGenerator.format(classImporter, (Decimal64)this.getValue((Number)((Object)r.upperEndpoint())));
            sb.append("    a[").append(offset++).append("] = ").append(Decimal64RangeGenerator.range(classImporter)).append(".closed(").append(min).append(", ").append(max).append(");\n");
        }
        sb.append("    ").append(fieldName).append(" = a;\n");
        sb.append("}\n");
        sb.append("private static void ").append(checkerName).append("(final ").append(this.getTypeName()).append(" value) {\n");
        sb.append("    for (").append(Decimal64RangeGenerator.itemType(classImporter)).append(" r : ").append(fieldName).append(") {\n");
        sb.append("        if (r.contains(value)) {\n");
        sb.append("            return;\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("    ").append(classImporter.apply(CodeHelpers.class)).append(".throwInvalidRange(").append(fieldName).append(", value);\n");
        sb.append("}\n");
        return sb.toString();
    }
}

