/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.YangFeature;
import org.opendaylight.yangtools.binding.codegen.ClassTemplate;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.yang.common.QName;

final class FeatureTemplate
extends ClassTemplate {
    private static final @NonNull JavaTypeName QNAME = JavaTypeName.create(QName.class);
    private static final @NonNull JavaTypeName YANG_FEATURE = JavaTypeName.create(YangFeature.class);
    private final @NonNull Type dataRoot;

    FeatureTemplate(GeneratedTransferObject genType, Type dataRoot) {
        super(genType);
        this.dataRoot = Objects.requireNonNull(dataRoot);
    }

    @Override
    protected String generateClassDeclaration(boolean isInnerClass) {
        String typeName = this.type().getName();
        return "@" + this.importedName(NONNULL_BY_DEFAULT) + "\npublic final class " + typeName + " extends " + this.importedName(YANG_FEATURE) + "<" + typeName + ", " + this.importedName(this.dataRoot) + ">";
    }

    @Override
    protected String constructors() {
        String typeName = this.type().getName();
        return "private " + typeName + "() {\n    // Hidden on purpose\n}";
    }

    @Override
    protected CharSequence emitConstant(Constant c) {
        if (!"VALUE".equals(c.getName()) || !YangFeature.class.equals(c.getValue())) {
            return super.emitConstant(c);
        }
        GeneratedType type = this.type();
        String typeName = type.getName();
        return "/**\n * {@link " + typeName + "} singleton instance.\n */\npublic static final " + this.importedName((Type)type) + " VALUE = new " + type.getName() + "();";
    }

    @Override
    protected String propertyMethods() {
        String override = this.importedName(OVERRIDE);
        String typeName = this.type().getName();
        String clazz = this.importedName(CLASS);
        String rootName = this.importedName(this.dataRoot);
        return "@" + override + "\npublic " + clazz + "<" + typeName + "> implementedInterface() {\n    return " + typeName + ".class;\n}\n\n@" + override + "\npublic " + this.importedName(QNAME) + " qname() {\n    return QNAME;\n}\n\n@" + override + "\npublic " + clazz + "<" + rootName + "> definingModule() {\n    return " + rootName + ".class;\n}\n";
    }
}

