/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.opendaylight.yangtools.binding.codegen.BuilderGenerator;
import org.opendaylight.yangtools.binding.codegen.CodeGeneratorGeneratedFile;
import org.opendaylight.yangtools.binding.codegen.EnumGenerator;
import org.opendaylight.yangtools.binding.codegen.InterfaceGenerator;
import org.opendaylight.yangtools.binding.codegen.SupplierGeneratedFile;
import org.opendaylight.yangtools.binding.codegen.TOGenerator;
import org.opendaylight.yangtools.binding.codegen.YangModuleInfoTemplate;
import org.opendaylight.yangtools.binding.generator.BindingGenerator;
import org.opendaylight.yangtools.binding.meta.YangModelBindingProvider;
import org.opendaylight.yangtools.binding.model.api.CodeGenerator;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.plugin.generator.api.FileGenerator;
import org.opendaylight.yangtools.plugin.generator.api.FileGeneratorException;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFile;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFileLifecycle;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFilePath;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFileType;
import org.opendaylight.yangtools.plugin.generator.api.ModuleResourceResolver;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaFileGenerator
implements FileGenerator {
    public static final String CONFIG_IGNORE_DUPLICATE_FILES = "ignoreDuplicateFiles";
    private static final Logger LOG = LoggerFactory.getLogger(JavaFileGenerator.class);
    private static final CharMatcher DOT_MATCHER = CharMatcher.is((char)'.');
    private static final String MODULE_INFO = "YangModuleInfoImpl.java";
    private static final String MODEL_BINDING_PROVIDER = "YangModelBindingProviderImpl.java";
    private static final GeneratedFilePath MODEL_BINDING_PROVIDER_SERVICE = GeneratedFilePath.ofPath((String)("META-INF/services/" + YangModelBindingProvider.class.getName()));
    private static final List<CodeGenerator> GENERATORS = List.of(new InterfaceGenerator(), new TOGenerator(), new EnumGenerator(), new BuilderGenerator());
    private final BindingGenerator bindingGenerator;
    private final boolean ignoreDuplicateFiles;

    JavaFileGenerator(Map<String, String> configuration) {
        String ignoreDuplicateFilesString = configuration.get(CONFIG_IGNORE_DUPLICATE_FILES);
        this.ignoreDuplicateFiles = ignoreDuplicateFilesString != null ? Boolean.parseBoolean(ignoreDuplicateFilesString) : true;
        this.bindingGenerator = ServiceLoader.load(BindingGenerator.class).findFirst().orElseThrow(() -> new IllegalStateException("No BindingGenerator implementation found"));
    }

    public Table<GeneratedFileType, GeneratedFilePath, GeneratedFile> generateFiles(EffectiveModelContext context, Set<Module> localModules, ModuleResourceResolver moduleResourcePathResolver) throws FileGeneratorException {
        Table<GeneratedFileType, GeneratedFilePath, GeneratedFile> result = JavaFileGenerator.generateFiles(this.bindingGenerator.generateTypes(context, localModules), this.ignoreDuplicateFiles);
        ImmutableSet.Builder bindingProviders = ImmutableSet.builder();
        for (Module module : localModules) {
            YangModuleInfoTemplate template = new YangModuleInfoTemplate(module, context, mod -> moduleResourcePathResolver.findModuleResourcePath(mod, YangTextSource.class));
            String path = DOT_MATCHER.replaceFrom((CharSequence)template.getPackageName(), '/') + "/";
            result.put((Object)GeneratedFileType.SOURCE, (Object)GeneratedFilePath.ofPath((String)(path + MODULE_INFO)), (Object)new SupplierGeneratedFile(GeneratedFileLifecycle.TRANSIENT, template::generate));
            result.put((Object)GeneratedFileType.SOURCE, (Object)GeneratedFilePath.ofPath((String)(path + MODEL_BINDING_PROVIDER)), (Object)new SupplierGeneratedFile(GeneratedFileLifecycle.TRANSIENT, template::generateModelProvider));
            bindingProviders.add((Object)template.getModelBindingProviderName());
        }
        ArrayList sorted = new ArrayList(bindingProviders.build());
        sorted.sort(String::compareTo);
        result.put((Object)GeneratedFileType.RESOURCE, (Object)MODEL_BINDING_PROVIDER_SERVICE, (Object)GeneratedFile.of((GeneratedFileLifecycle)GeneratedFileLifecycle.TRANSIENT, (CharSequence)String.join((CharSequence)"\n", sorted)));
        return ImmutableTable.copyOf(result);
    }

    @VisibleForTesting
    static Table<GeneratedFileType, GeneratedFilePath, GeneratedFile> generateFiles(List<GeneratedType> types, boolean ignoreDuplicateFiles) {
        HashBasedTable result = HashBasedTable.create();
        for (Type type : types) {
            for (CodeGenerator generator : GENERATORS) {
                if (!generator.isAcceptable(type)) continue;
                GeneratedFilePath file = GeneratedFilePath.ofFilePath((String)(type.getPackageName().replace('.', File.separatorChar) + File.separator + generator.getUnitName(type) + ".java"));
                if (result.contains((Object)GeneratedFileType.SOURCE, (Object)file)) {
                    if (ignoreDuplicateFiles) {
                        LOG.warn("Naming conflict for type '{}': file with same name already exists and will not be generated.", (Object)type.getFullyQualifiedName());
                        continue;
                    }
                    throw new IllegalStateException("Duplicate file '" + file.getPath() + "' for " + type.getFullyQualifiedName());
                }
                result.put((Object)GeneratedFileType.SOURCE, (Object)file, (Object)new CodeGeneratorGeneratedFile(GeneratedFileLifecycle.TRANSIENT, generator, type));
            }
        }
        return result;
    }
}

