/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSortedSet;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.AlphabeticallyTypeMemberComparator;
import org.opendaylight.yangtools.binding.codegen.BuilderGeneratedProperty;
import org.opendaylight.yangtools.binding.codegen.ClassTemplate;
import org.opendaylight.yangtools.binding.codegen.NestedJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.TopLevelJavaGeneratedType;
import org.opendaylight.yangtools.binding.codegen.UnionTemplate;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.generator.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.binding.model.api.Restrictions;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.YangSourceDefinition;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.DeclaredStatementFormatter;

class JavaFileTemplate {
    static final @NonNull JavaTypeName CLASS = JavaTypeName.create(Class.class);
    static final @NonNull JavaTypeName DEPRECATED = JavaTypeName.create(Deprecated.class);
    static final @NonNull JavaTypeName IAE = JavaTypeName.create(IllegalArgumentException.class);
    static final @NonNull JavaTypeName NPE = JavaTypeName.create(NullPointerException.class);
    static final @NonNull JavaTypeName NSEE = JavaTypeName.create(NoSuchElementException.class);
    static final @NonNull JavaTypeName OBJECT = JavaTypeName.create(Object.class);
    static final @NonNull JavaTypeName OVERRIDE = JavaTypeName.create(Override.class);
    static final @NonNull JavaTypeName SUPPRESS_WARNINGS = JavaTypeName.create(SuppressWarnings.class);
    static final @NonNull JavaTypeName VOID = JavaTypeName.create(Void.TYPE);
    static final @NonNull JavaTypeName JU_ARRAYS = JavaTypeName.create(Arrays.class);
    static final @NonNull JavaTypeName JU_HASHMAP = JavaTypeName.create(HashMap.class);
    static final @NonNull JavaTypeName JU_LIST = JavaTypeName.create(List.class);
    static final @NonNull JavaTypeName JU_MAP = JavaTypeName.create(Map.class);
    static final @NonNull JavaTypeName JU_OBJECTS = JavaTypeName.create(Objects.class);
    static final @NonNull JavaTypeName JUR_PATTERN = JavaTypeName.create(Pattern.class);
    static final @NonNull JavaTypeName GENERATED = JavaTypeName.create(Generated.class);
    static final @NonNull JavaTypeName NONNULL = JavaTypeName.create(NonNull.class);
    static final @NonNull JavaTypeName NONNULL_BY_DEFAULT = JavaTypeName.create(NonNullByDefault.class);
    static final @NonNull JavaTypeName NULLABLE = JavaTypeName.create(Nullable.class);
    static final @NonNull JavaTypeName CODEHELPERS = JavaTypeName.create(CodeHelpers.class);
    static final @NonNull JavaTypeName MOREOBJECTS = JavaTypeName.create(MoreObjects.class);
    private static final Comparator<MethodSignature> METHOD_COMPARATOR = new AlphabeticallyTypeMemberComparator<MethodSignature>();
    private static final CharMatcher AMP_MATCHER = CharMatcher.is((char)'&');
    private static final Pattern TAIL_COMMENT_PATTERN = Pattern.compile("*/", 16);
    private static final DeclaredStatementFormatter YANG_FORMATTER = DeclaredStatementFormatter.builder().addIgnoredStatement((StatementDefinition)YangStmtMapping.CONTACT).addIgnoredStatement((StatementDefinition)YangStmtMapping.DESCRIPTION).addIgnoredStatement((StatementDefinition)YangStmtMapping.REFERENCE).addIgnoredStatement((StatementDefinition)YangStmtMapping.ORGANIZATION).build();
    private static final int GETTER_PREFIX_LENGTH = "get".length();
    private final AbstractJavaGeneratedType javaType;
    private final GeneratedType type;

    JavaFileTemplate(@NonNull GeneratedType type) {
        this(new TopLevelJavaGeneratedType(type), type);
    }

    JavaFileTemplate(AbstractJavaGeneratedType javaType, GeneratedType type) {
        this.javaType = Objects.requireNonNull(javaType);
        this.type = Objects.requireNonNull(type);
    }

    final AbstractJavaGeneratedType javaType() {
        return this.javaType;
    }

    final GeneratedType type() {
        return this.type;
    }

    final String generateImportBlock() {
        Verify.verify((boolean)(this.javaType instanceof TopLevelJavaGeneratedType));
        return ((TopLevelJavaGeneratedType)this.javaType).imports().map(name -> "import " + String.valueOf(name) + ";\n").collect(Collectors.joining());
    }

    final @NonNull String importedJavadocName(@NonNull Type intype) {
        Type type;
        if (intype instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)intype;
            type = parameterized.getRawType();
        } else {
            type = intype;
        }
        return this.importedName(type);
    }

    final @NonNull String importedName(@NonNull Type intype) {
        return this.javaType.getReferenceString(intype);
    }

    final @NonNull String importedName(@NonNull Type intype, @NonNull String annotation) {
        return this.javaType.getReferenceString(intype, annotation);
    }

    final @NonNull String importedName(Class<?> cls) {
        return this.importedName((Type)Types.typeForClass(cls));
    }

    final @NonNull String importedName(@NonNull JavaTypeName intype) {
        return this.javaType.getReferenceString(intype);
    }

    final @NonNull String importedNonNull(@NonNull Type intype) {
        return this.importedName(intype, this.importedName(NONNULL));
    }

    final @NonNull String importedNullable(@NonNull Type intype) {
        return this.importedName(intype, this.importedName(NULLABLE));
    }

    final @NonNull String fullyQualifiedNonNull(@NonNull Type intype) {
        return this.fullyQualifiedName(intype, this.importedName(NONNULL));
    }

    final @NonNull String fullyQualifiedName(@NonNull Type intype, @NonNull String annotation) {
        return this.javaType.getFullyQualifiedReference(intype, annotation);
    }

    boolean isLocalInnerClass(JavaTypeName name) {
        Optional optEnc = name.immediatelyEnclosingClass();
        return optEnc.isPresent() && ((JavaTypeName)this.type.getIdentifier()).equals(optEnc.orElseThrow());
    }

    final CharSequence generateInnerClass(GeneratedType innerClass) {
        if (!(innerClass instanceof GeneratedTransferObject)) {
            return "";
        }
        GeneratedTransferObject gto = (GeneratedTransferObject)innerClass;
        NestedJavaGeneratedType innerJavaType = this.javaType.getEnclosedType((JavaTypeName)innerClass.getIdentifier());
        return gto.isUnionType() ? new UnionTemplate(innerJavaType, gto).generateAsInnerClass() : new ClassTemplate((AbstractJavaGeneratedType)innerJavaType, gto).generateAsInnerClass();
    }

    final String importedUtilClass(GeneratedProperty property) {
        return this.importedUtilClass(property.getReturnType());
    }

    final String importedUtilClass(Type returnType) {
        return this.importedName(returnType.getName().indexOf(91) != -1 ? JU_ARRAYS : JU_OBJECTS);
    }

    final String generatedAnnotation() {
        return "@" + this.importedName(GENERATED) + "(\"mdsal-binding-generator\")";
    }

    static Map.Entry<Type, Set<BuilderGeneratedProperty>> analyzeTypeHierarchy(GeneratedType type) {
        LinkedHashSet<MethodSignature> methods = new LinkedHashSet<MethodSignature>();
        ParameterizedType augmentType = JavaFileTemplate.createMethods(type, methods);
        ImmutableSortedSet sortedMethods = ImmutableSortedSet.orderedBy(METHOD_COMPARATOR).addAll(methods).build();
        return new AbstractMap.SimpleImmutableEntry<ParameterizedType, Set<BuilderGeneratedProperty>>(augmentType, JavaFileTemplate.propertiesFromMethods((Collection<MethodSignature>)sortedMethods));
    }

    static final Restrictions restrictionsForSetter(Type actualType) {
        return actualType instanceof GeneratedType ? null : JavaFileTemplate.getRestrictions(actualType);
    }

    static final Restrictions getRestrictions(Type type) {
        if (type instanceof ConcreteType) {
            return ((ConcreteType)type).getRestrictions();
        }
        if (type instanceof GeneratedTransferObject) {
            return ((GeneratedTransferObject)type).getRestrictions();
        }
        return null;
    }

    static final String cloneCall(GeneratedProperty property) {
        return property.getReturnType().getName().endsWith("[]") ? ".clone()" : "";
    }

    private static ParameterizedType createMethods(GeneratedType type, Set<MethodSignature> methods) {
        methods.addAll(type.getMethodDefinitions());
        return JavaFileTemplate.collectImplementedMethods(type, methods, type.getImplements());
    }

    private static ParameterizedType collectImplementedMethods(GeneratedType type, Set<MethodSignature> methods, List<Type> implementedIfcs) {
        if (implementedIfcs == null || implementedIfcs.isEmpty()) {
            return null;
        }
        ParameterizedType augmentType = null;
        for (Type implementedIfc : implementedIfcs) {
            ParameterizedType parameterized;
            Type augmentation;
            if (implementedIfc instanceof GeneratedType) {
                GeneratedType ifc = (GeneratedType)implementedIfc;
                if (!(implementedIfc instanceof GeneratedTransferObject)) {
                    JavaFileTemplate.addImplMethods(methods, ifc);
                    ParameterizedType t = JavaFileTemplate.collectImplementedMethods(type, methods, ifc.getImplements());
                    if (t == null || augmentType != null) continue;
                    augmentType = t;
                    continue;
                }
            }
            if (!(implementedIfc instanceof ParameterizedType) || (augmentation = BindingTypes.extractAugmentableTarget((ParameterizedType)(parameterized = (ParameterizedType)implementedIfc))) == null) continue;
            augmentType = BindingTypes.augmentation((Type)augmentation);
        }
        return augmentType;
    }

    private static void addImplMethods(Set<MethodSignature> methods, GeneratedType implType) {
        for (MethodSignature implMethod : implType.getMethodDefinitions()) {
            if (JavaFileTemplate.hasOverrideAnnotation(implMethod)) {
                methods.add(implMethod);
                continue;
            }
            String implMethodName = implMethod.getName();
            if (!Naming.isGetterMethodName((String)implMethodName) || !JavaFileTemplate.getterByName(methods, implMethodName).isEmpty()) continue;
            methods.add(implMethod);
        }
    }

    protected static Optional<MethodSignature> getterByName(Iterable<MethodSignature> methods, String implMethodName) {
        for (MethodSignature method : methods) {
            String methodName = method.getName();
            if (!Naming.isGetterMethodName((String)methodName) || !JavaFileTemplate.isSameProperty(method.getName(), implMethodName)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    protected static String propertyNameFromGetter(MethodSignature getter) {
        return JavaFileTemplate.propertyNameFromGetter(getter.getName());
    }

    protected static String propertyNameFromGetter(String getterName) {
        String prefix;
        if (Naming.isGetterMethodName((String)getterName)) {
            prefix = "get";
        } else if (Naming.isNonnullMethodName((String)getterName)) {
            prefix = "nonnull";
        } else if (Naming.isRequireMethodName((String)getterName)) {
            prefix = "require";
        } else {
            throw new IllegalArgumentException(getterName + " is not a getter");
        }
        return StringExtensions.toFirstLower((String)getterName.substring(prefix.length()));
    }

    static boolean hasOverrideAnnotation(MethodSignature method) {
        for (AnnotationType annotation : method.getAnnotations()) {
            if (!OVERRIDE.equals(annotation.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    final void appendSnippet(StringBuilder sb, GeneratedType genType) {
        genType.getYangSourceDefinition().ifPresent(def -> {
            sb.append('\n');
            if (def instanceof YangSourceDefinition.Single) {
                GeneratedTransferObject genTO;
                Type augType;
                YangSourceDefinition.Single single = (YangSourceDefinition.Single)def;
                DocumentedNode node = single.getNode();
                sb.append("<p>\n").append("This class represents the following YANG schema fragment defined in module <b>").append(((UnresolvedQName.Unqualified)def.getModule().argument()).getLocalName()).append("</b>\n").append("<pre>\n");
                JavaFileTemplate.appendYangSnippet(sb, def.getModule(), ((EffectiveStatement)node).getDeclared());
                sb.append("</pre>");
                if (node instanceof SchemaNode) {
                    SchemaNode schema = (SchemaNode)node;
                    if (schema instanceof ContainerSchemaNode || schema instanceof ListSchemaNode || schema instanceof NotificationDefinition && !BindingTypes.isNotificationBody((Type)genType)) {
                        String builderName = genType.getName() + "Builder";
                        sb.append("\n<p>To create instances of this class use {@link ").append(builderName).append("}.\n").append("@see ").append(builderName).append('\n');
                        if (node instanceof ListSchemaNode) {
                            List keyDef = ((ListSchemaNode)node).getKeyDefinition();
                            if (!keyDef.isEmpty()) {
                                sb.append("@see ").append(genType.getName()).append("Key");
                            }
                            sb.append('\n');
                        }
                    }
                } else if (node instanceof AugmentEffectiveStatement && (augType = JavaFileTemplate.findAugmentationArgument(genType)) != null) {
                    sb.append("\n\n").append("@see ").append(this.importedName(augType));
                }
                if (node instanceof TypedefEffectiveStatement && genType instanceof GeneratedTransferObject && (augType = (genTO = (GeneratedTransferObject)genType).getSuperType()) != null) {
                    sb.append("\n\n").append("@see ").append(augType.getName());
                }
            } else if (def instanceof YangSourceDefinition.Multiple) {
                YangSourceDefinition.Multiple multiple = (YangSourceDefinition.Multiple)def;
                sb.append("<pre>\n");
                for (SchemaNode node : multiple.getNodes()) {
                    JavaFileTemplate.appendYangSnippet(sb, def.getModule(), ((EffectiveStatement)node).getDeclared());
                }
                sb.append("</pre>\n");
            }
        });
    }

    private static @Nullable Type findAugmentationArgument(GeneratedType genType) {
        for (Type implType : genType.getImplements()) {
            ParameterizedType parameterized;
            Type augmentType;
            if (!(implType instanceof ParameterizedType) || (augmentType = BindingTypes.extractAugmentationTarget((ParameterizedType)(parameterized = (ParameterizedType)implType))) == null) continue;
            return augmentType;
        }
        return null;
    }

    static String encodeJavadocSymbols(String description) {
        return description == null || description.isEmpty() ? description : TAIL_COMMENT_PATTERN.matcher(AMP_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&amp;")).replaceAll("&#42;&#47;");
    }

    private static void appendYangSnippet(StringBuilder sb, ModuleEffectiveStatement module, DeclaredStatement<?> stmt) {
        for (String str : YANG_FORMATTER.toYangTextSnippet(module, stmt)) {
            sb.append(BindingGeneratorUtil.replaceAllIllegalChars((String)BindingGeneratorUtil.encodeAngleBrackets((String)JavaFileTemplate.encodeJavadocSymbols(str))));
        }
    }

    private static boolean isSameProperty(String getterName1, String getterName2) {
        return JavaFileTemplate.propertyNameFromGetter(getterName1).equals(JavaFileTemplate.propertyNameFromGetter(getterName2));
    }

    private static Set<BuilderGeneratedProperty> propertiesFromMethods(Collection<MethodSignature> methods) {
        if (methods == null || methods.isEmpty()) {
            return Set.of();
        }
        LinkedHashSet<BuilderGeneratedProperty> result = new LinkedHashSet<BuilderGeneratedProperty>();
        for (MethodSignature method : methods) {
            BuilderGeneratedProperty createdField = JavaFileTemplate.propertyFromGetter(method);
            if (createdField == null) continue;
            result.add(createdField);
        }
        return result;
    }

    private static BuilderGeneratedProperty propertyFromGetter(MethodSignature method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0);
        Preconditions.checkArgument((method.getReturnType() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((method.getName() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!method.getName().isEmpty() ? 1 : 0) != 0);
        if (method.isDefault()) {
            return null;
        }
        if (!Naming.isGetterMethodName((String)method.getName())) {
            return null;
        }
        String fieldName = StringExtensions.toFirstLower((String)method.getName().substring(GETTER_PREFIX_LENGTH));
        return new BuilderGeneratedProperty(fieldName, method);
    }
}

