/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;

@NonNullByDefault
final class NestedJavaGeneratedType
extends AbstractJavaGeneratedType {
    private final AbstractJavaGeneratedType enclosingType;

    NestedJavaGeneratedType(AbstractJavaGeneratedType enclosingType, GeneratedType genType) {
        super(genType);
        this.enclosingType = Objects.requireNonNull(enclosingType);
    }

    @Override
    boolean importCheckedType(JavaTypeName type) {
        return this.enclosingType.checkAndImportType(type);
    }

    @Override
    String localTypeName(JavaTypeName type) {
        if (this.enclosingType.getName().equals((Object)type)) {
            return this.enclosingType.getSimpleName();
        }
        @Nullable List<String> descendant = this.findDescandantPath(type);
        if (descendant == null) {
            return this.enclosingType.localTypeName(type);
        }
        Iterator<String> it = descendant.iterator();
        StringBuilder sb = new StringBuilder().append(it.next());
        while (it.hasNext()) {
            sb.append('.').append(it.next());
        }
        return sb.toString();
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="SpotBugs confusion @Nullable vs @NonNullByDefault")
    private @Nullable List<String> findDescandantPath(JavaTypeName type) {
        Optional optEnclosing = type.immediatelyEnclosingClass();
        Verify.verify((boolean)optEnclosing.isPresent());
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.addFirst(type.simpleName());
        while (optEnclosing.isPresent()) {
            JavaTypeName enclosing = (JavaTypeName)optEnclosing.orElseThrow();
            if (enclosing.equals((Object)this.getName())) {
                return ImmutableList.copyOf(queue);
            }
            queue.addFirst(enclosing.simpleName());
            optEnclosing = enclosing.immediatelyEnclosingClass();
        }
        return null;
    }
}

