/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.binding.codegen.AbstractJavaGeneratedType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;

@NonNullByDefault
final class TopLevelJavaGeneratedType
extends AbstractJavaGeneratedType {
    private final BiMap<JavaTypeName, String> importedTypes = HashBiMap.create();

    TopLevelJavaGeneratedType(GeneratedType genType) {
        super(genType);
    }

    @Override
    String localTypeName(JavaTypeName type) {
        Iterator it = type.localNameComponents().iterator();
        it.next();
        StringBuilder sb = new StringBuilder().append((String)it.next());
        while (it.hasNext()) {
            sb.append('.').append((String)it.next());
        }
        return sb.toString();
    }

    @Override
    boolean importCheckedType(JavaTypeName type) {
        if (this.importedTypes.containsKey((Object)type)) {
            return true;
        }
        String simpleName = type.simpleName();
        if (this.importedTypes.containsValue((Object)simpleName)) {
            return false;
        }
        this.importedTypes.put((Object)type, (Object)simpleName);
        return true;
    }

    Stream<JavaTypeName> imports() {
        return this.importedTypes.entrySet().stream().filter(this::needsExplicitImport).map(Map.Entry::getKey).sorted(Comparator.comparing(JavaTypeName::toString));
    }

    private boolean needsExplicitImport(Map.Entry<JavaTypeName, String> entry) {
        JavaTypeName name = entry.getKey();
        if (!this.getName().packageName().equals(name.packageName())) {
            return true;
        }
        if (!name.immediatelyEnclosingClass().isPresent()) {
            return false;
        }
        return entry.getValue().equals(name.simpleName());
    }
}

