/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.codegen;

import java.util.function.Function;
import org.opendaylight.yangtools.binding.codegen.AbstractUnsignedRangeGenerator;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

final class Uint64RangeGenerator
extends AbstractUnsignedRangeGenerator<Uint64> {
    Uint64RangeGenerator() {
        super(Uint64.class, Long.TYPE.getName(), Uint64.ZERO, Uint64.MAX_VALUE);
    }

    @Override
    @Deprecated
    protected Uint64 convert(Number value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Uint8 || value instanceof Uint16 || value instanceof Uint32) {
            return Uint64.valueOf((long)value.longValue());
        }
        return Uint64.valueOf((String)value.toString());
    }

    @Override
    protected String format(Uint64 value) {
        throw new UnsupportedOperationException();
    }

    @Override
    String codeHelpersThrow() {
        return "throwInvalidRangeUnsigned";
    }

    @Override
    void appendMaxCheck(StringBuilder sb, Uint64 max, Function<Class<?>, String> classImporter) {
        Uint64RangeGenerator.appendCompare(sb, classImporter, max, "<=");
    }

    @Override
    void appendMinCheck(StringBuilder sb, Uint64 min, Function<Class<?>, String> classImporter) {
        Uint64RangeGenerator.appendCompare(sb, classImporter, min, ">=");
    }

    private static StringBuilder appendCompare(StringBuilder sb, Function<Class<?>, String> classImporter, Uint64 val, String operator) {
        return sb.append(classImporter.apply(Long.class)).append(".compareUnsigned(value, ").append(val.longValue()).append("L) ").append(operator).append(" 0");
    }
}

