/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.BindingTypes;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTypeBuilderImpl;
import org.opendaylight.yangtools.sal.binding.generator.api.BindingGenerator;
import org.opendaylight.yangtools.sal.binding.generator.impl.ModuleContext;
import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.sal.binding.yang.types.GroupingDefinitionDependencySort;
import org.opendaylight.yangtools.sal.binding.yang.types.TypeProviderImpl;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.DataNodeIterator;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.UnionType;
import org.opendaylight.yangtools.yang.parser.util.ModuleDependencySort;

public class BindingGeneratorImpl
implements BindingGenerator {
    private final Map<Module, ModuleContext> genCtx = new Functions.Function0<Map<Module, ModuleContext>>(){

        public Map<Module, ModuleContext> apply() {
            HashMap<Module, ModuleContext> _hashMap = new HashMap<Module, ModuleContext>();
            return _hashMap;
        }
    }.apply();
    private Map<String, Map<String, GeneratedTypeBuilder>> genTypeBuilders;
    private TypeProvider typeProvider;
    private SchemaContext schemaContext;
    private static final String YANG_EXT_NAMESPACE = "urn:opendaylight:yang:extension:yang-ext";
    private static final String AUGMENT_IDENTIFIER_NAME = "augment-identifier";

    public List<Type> generateTypes(SchemaContext context) {
        boolean _tripleNotEquals = context != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Schema Context reference cannot be NULL.");
        Set _modules = context.getModules();
        boolean _tripleNotEquals_1 = _modules != null;
        Preconditions.checkState((boolean)_tripleNotEquals_1, (Object)"Schema Context does not contain defined modules.");
        this.schemaContext = context;
        TypeProviderImpl _typeProviderImpl = new TypeProviderImpl(context);
        this.typeProvider = _typeProviderImpl;
        Set modules = context.getModules();
        return this.generateTypes(context, modules);
    }

    public List<Type> generateTypes(SchemaContext context, Set<Module> modules) {
        ArrayList<Type> _arrayList;
        boolean _tripleNotEquals = context != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Schema Context reference cannot be NULL.");
        Set _modules = context.getModules();
        boolean _tripleNotEquals_1 = _modules != null;
        Preconditions.checkState((boolean)_tripleNotEquals_1, (Object)"Schema Context does not contain defined modules.");
        boolean _tripleNotEquals_2 = modules != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_2, (Object)"Set of Modules cannot be NULL.");
        this.schemaContext = context;
        TypeProviderImpl _typeProviderImpl = new TypeProviderImpl(context);
        this.typeProvider = _typeProviderImpl;
        Set _modules_1 = context.getModules();
        List contextModules = ModuleDependencySort.sort((Module[])((Module[])Conversions.unwrapArray((Object)_modules_1, Module.class)));
        HashMap<String, Map<String, GeneratedTypeBuilder>> _hashMap = new HashMap<String, Map<String, GeneratedTypeBuilder>>();
        this.genTypeBuilders = _hashMap;
        for (Module contextModule : contextModules) {
            this.moduleToGenTypes(contextModule, context);
        }
        for (Module contextModule_1 : contextModules) {
            this.allAugmentsToGenTypes(contextModule_1);
        }
        ArrayList<Type> filteredGenTypes = _arrayList = new ArrayList<Type>();
        for (Module m : modules) {
            ModuleContext _get = this.genCtx.get(m);
            List<Type> _generatedTypes = _get.getGeneratedTypes();
            filteredGenTypes.addAll(_generatedTypes);
            Map _additionalTypes = ((TypeProviderImpl)this.typeProvider).getAdditionalTypes();
            Set additionalTypes = (Set)_additionalTypes.get(m);
            boolean _notEquals = !Objects.equal((Object)additionalTypes, null);
            if (!_notEquals) continue;
            filteredGenTypes.addAll(additionalTypes);
        }
        return filteredGenTypes;
    }

    private void moduleToGenTypes(Module m, SchemaContext context) {
        boolean _not;
        ModuleContext _moduleContext = new ModuleContext();
        this.genCtx.put(m, _moduleContext);
        this.allTypeDefinitionsToGenTypes(m);
        Set _groupings = m.getGroupings();
        this.groupingsToGenTypes(m, _groupings);
        this.rpcMethodsToGenType(m);
        this.allIdentitiesToGenTypes(m, context);
        this.notificationsToGenType(m);
        Set _childNodes = m.getChildNodes();
        boolean _isEmpty = _childNodes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            GeneratedTypeBuilder moduleType = this.moduleToDataType(m);
            ModuleContext _get = this.genCtx.get(m);
            _get.addModuleNode(moduleType);
            String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)m);
            Set _childNodes_1 = m.getChildNodes();
            this.resolveDataSchemaNodes(m, basePackageName, moduleType, moduleType, _childNodes_1);
        }
    }

    private void allTypeDefinitionsToGenTypes(Module module) {
        DataNodeIterator _dataNodeIterator;
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        String _name = module.getName();
        boolean _tripleNotEquals_1 = _name != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Module name cannot be NULL.");
        DataNodeIterator it = _dataNodeIterator = new DataNodeIterator((DataNodeContainer)module);
        List typeDefinitions = it.allTypedefs();
        boolean _tripleNotEquals_2 = typeDefinitions != null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Type Definitions for module ");
        String _name_1 = module.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" cannot be NULL.");
        Preconditions.checkState((boolean)_tripleNotEquals_2, (Object)_builder);
        for (TypeDefinition typedef : typeDefinitions) {
            Type type;
            boolean _tripleNotEquals_4;
            boolean _tripleNotEquals_3 = typedef != null;
            if (!_tripleNotEquals_3 || !(_tripleNotEquals_4 = (type = ((TypeProviderImpl)this.typeProvider).generatedTypeForExtendedDefinitionType(typedef, (SchemaNode)typedef)) != null)) continue;
            ModuleContext _get = this.genCtx.get(module);
            SchemaPath _path = typedef.getPath();
            _get.addTypedefType(_path, type);
        }
    }

    private GeneratedTypeBuilder processDataSchemaNode(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, DataSchemaNode node) {
        boolean _or = false;
        boolean _isAugmenting = node.isAugmenting();
        if (_isAugmenting) {
            _or = true;
        } else {
            boolean _isAddedByUses = node.isAddedByUses();
            boolean bl = _or = _isAugmenting || _isAddedByUses;
        }
        if (_or) {
            return null;
        }
        SchemaPath _path = node.getPath();
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
        GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(packageName, (SchemaNode)node, (Type)childOf);
        if (node instanceof DataNodeContainer) {
            ModuleContext _get = this.genCtx.get(module);
            SchemaPath _path_1 = node.getPath();
            _get.addChildNodeType(_path_1, genType);
            Set _groupings = ((DataNodeContainer)node).getGroupings();
            this.groupingsToGenTypes(module, _groupings);
            this.processUsesAugments((DataNodeContainer)node, module);
        }
        return genType;
    }

    private void containerToGenType(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, ContainerSchemaNode node) {
        boolean _notEquals;
        GeneratedTypeBuilder genType = this.processDataSchemaNode(module, basePackageName, parent, childOf, (DataSchemaNode)node);
        boolean bl = _notEquals = !Objects.equal((Object)genType, null);
        if (_notEquals) {
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            String _description = node.getDescription();
            this.constructGetter(parent, _localName, _description, (Type)genType);
            Set _childNodes = node.getChildNodes();
            this.resolveDataSchemaNodes(module, basePackageName, genType, genType, _childNodes);
        }
    }

    private void listToGenType(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, ListSchemaNode node) {
        boolean _notEquals;
        GeneratedTypeBuilder genType = this.processDataSchemaNode(module, basePackageName, parent, childOf, (DataSchemaNode)node);
        boolean bl = _notEquals = !Objects.equal((Object)genType, null);
        if (_notEquals) {
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            String _description = node.getDescription();
            ParameterizedType _listTypeFor = Types.listTypeFor((Type)genType);
            this.constructGetter(parent, _localName, _description, (Type)_listTypeFor);
            List<String> listKeys = this.listKeys(node);
            SchemaPath _path = node.getPath();
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
            GeneratedTOBuilder genTOBuilder = this.resolveListKeyTOBuilder(packageName, node);
            boolean bl2 = _tripleNotEquals = genTOBuilder != null;
            if (_tripleNotEquals) {
                ParameterizedType identifierMarker = Types.parameterizedTypeFor((Type)BindingTypes.IDENTIFIER, (Type[])new Type[]{genType});
                ParameterizedType identifiableMarker = Types.parameterizedTypeFor((Type)BindingTypes.IDENTIFIABLE, (Type[])new Type[]{genTOBuilder});
                genTOBuilder.addImplementsType((Type)identifierMarker);
                genType.addImplementsType((Type)identifiableMarker);
            }
            Set _childNodes = node.getChildNodes();
            for (DataSchemaNode schemaNode : _childNodes) {
                boolean _isAugmenting = schemaNode.isAugmenting();
                boolean _not = !_isAugmenting;
                if (!_not) continue;
                this.addSchemaNodeToListBuilders(basePackageName, schemaNode, genType, genTOBuilder, listKeys, module);
            }
            boolean bl3 = _tripleNotEquals_1 = genTOBuilder != null;
            if (_tripleNotEquals_1) {
                GeneratedPropertyBuilderImpl _generatedPropertyBuilderImpl;
                GeneratedPropertyBuilderImpl prop = _generatedPropertyBuilderImpl = new GeneratedPropertyBuilderImpl("serialVersionUID");
                long _computeDefaultSUID = BindingGeneratorUtil.computeDefaultSUID((GeneratedTOBuilderImpl)((GeneratedTOBuilderImpl)genTOBuilder));
                String _string = Long.toString(_computeDefaultSUID);
                prop.setValue(_string);
                genTOBuilder.setSUID((GeneratedPropertyBuilder)prop);
            }
            this.typeBuildersToGenTypes(module, genType, genTOBuilder);
        }
    }

    private void processUsesAugments(DataNodeContainer node, Module module) {
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        Set _uses = node.getUses();
        for (UsesNode usesNode : _uses) {
            Set _augmentations = usesNode.getAugmentations();
            for (AugmentationSchema augment : _augmentations) {
                this.augmentationToGenTypes(basePackageName, augment, module, usesNode);
                this.processUsesAugments((DataNodeContainer)augment, module);
            }
        }
    }

    private void allAugmentsToGenTypes(Module module) {
        boolean _tripleEquals;
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        String _name = module.getName();
        boolean _tripleNotEquals_1 = _name != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Module name cannot be NULL.");
        Set _childNodes = module.getChildNodes();
        boolean bl = _tripleEquals = _childNodes == null;
        if (_tripleEquals) {
            String _name_1 = module.getName();
            String _plus = "Reference to Set of Augmentation Definitions in module " + _name_1;
            String _plus_1 = _plus + " cannot be NULL.";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_1);
            throw _illegalArgumentException;
        }
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        List<AugmentationSchema> augmentations = this.resolveAugmentations(module);
        for (AugmentationSchema augment : augmentations) {
            this.augmentationToGenTypes(basePackageName, augment, module, null);
        }
    }

    private List<AugmentationSchema> resolveAugmentations(Module module) {
        ArrayList<AugmentationSchema> _arrayList;
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        Set _augmentations = module.getAugmentations();
        boolean _tripleNotEquals_1 = _augmentations != null;
        Preconditions.checkState((boolean)_tripleNotEquals_1, (Object)"Augmentations Set cannot be NULL.");
        Set augmentations = module.getAugmentations();
        ArrayList<AugmentationSchema> sortedAugmentations = _arrayList = new ArrayList<AugmentationSchema>(augmentations);
        Comparator<AugmentationSchema> _function = new Comparator<AugmentationSchema>(){

            @Override
            public int compare(AugmentationSchema augSchema1, AugmentationSchema augSchema2) {
                SchemaPath _targetPath_3;
                List _path_3;
                int _size_3;
                boolean _lessThan;
                SchemaPath _targetPath_1;
                List _path_1;
                int _size_1;
                boolean _greaterThan;
                SchemaPath _targetPath = augSchema1.getTargetPath();
                List _path = _targetPath.getPath();
                int _size = _path.size();
                boolean bl = _greaterThan = _size > (_size_1 = (_path_1 = (_targetPath_1 = augSchema2.getTargetPath()).getPath()).size());
                if (_greaterThan) {
                    return 1;
                }
                SchemaPath _targetPath_2 = augSchema1.getTargetPath();
                List _path_2 = _targetPath_2.getPath();
                int _size_2 = _path_2.size();
                boolean bl2 = _lessThan = _size_2 < (_size_3 = (_path_3 = (_targetPath_3 = augSchema2.getTargetPath()).getPath()).size());
                if (_lessThan) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(sortedAugmentations, _function);
        return sortedAugmentations;
    }

    private GeneratedTypeBuilder moduleToDataType(Module module) {
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        GeneratedTypeBuilder moduleDataTypeBuilder = this.moduleTypeBuilder(module, "Data");
        this.addImplementedInterfaceFromUses((DataNodeContainer)module, moduleDataTypeBuilder);
        moduleDataTypeBuilder.addImplementsType((Type)BindingTypes.DATA_ROOT);
        return moduleDataTypeBuilder;
    }

    private void rpcMethodsToGenType(Module module) {
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        String _name = module.getName();
        boolean _tripleNotEquals_1 = _name != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Module name cannot be NULL.");
        Set _childNodes = module.getChildNodes();
        boolean _tripleNotEquals_2 = _childNodes != null;
        String _name_1 = module.getName();
        String _plus = "Reference to Set of RPC Method Definitions in module " + _name_1;
        String _plus_1 = _plus + " cannot be NULL.";
        Preconditions.checkArgument((boolean)_tripleNotEquals_2, (Object)_plus_1);
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        Set rpcDefinitions = module.getRpcs();
        boolean _isEmpty = rpcDefinitions.isEmpty();
        if (_isEmpty) {
            return;
        }
        GeneratedTypeBuilder interfaceBuilder = this.moduleTypeBuilder(module, "Service");
        ConcreteType _typeForClass = Types.typeForClass(RpcService.class);
        interfaceBuilder.addImplementsType((Type)_typeForClass);
        for (RpcDefinition rpc : rpcDefinitions) {
            boolean _tripleNotEquals_5;
            boolean _tripleNotEquals_4;
            boolean _tripleNotEquals_3 = rpc != null;
            if (!_tripleNotEquals_3) continue;
            QName _qName = rpc.getQName();
            String rpcName = BindingMapping.getClassName((QName)_qName);
            String rpcMethodName = BindingGeneratorUtil.parseToValidParamName((String)rpcName);
            MethodSignatureBuilder method = interfaceBuilder.addMethod(rpcMethodName);
            ContainerSchemaNode input = rpc.getInput();
            ContainerSchemaNode output = rpc.getOutput();
            boolean bl = _tripleNotEquals_4 = input != null;
            if (_tripleNotEquals_4) {
                GeneratedTypeBuilder inType = this.addRawInterfaceDefinition(basePackageName, (SchemaNode)input, rpcName);
                this.addImplementedInterfaceFromUses((DataNodeContainer)input, inType);
                inType.addImplementsType((Type)BindingTypes.DATA_OBJECT);
                ParameterizedType _augmentable = BindingTypes.augmentable((Type)inType);
                inType.addImplementsType((Type)_augmentable);
                Set _childNodes_1 = input.getChildNodes();
                this.resolveDataSchemaNodes(module, basePackageName, inType, inType, _childNodes_1);
                ModuleContext _get = this.genCtx.get(module);
                SchemaPath _path = input.getPath();
                _get.addChildNodeType(_path, inType);
                GeneratedType inTypeInstance = inType.toInstance();
                method.addParameter((Type)inTypeInstance, "input");
            }
            ConcreteType outTypeInstance = Types.VOID;
            boolean bl2 = _tripleNotEquals_5 = output != null;
            if (_tripleNotEquals_5) {
                GeneratedTypeBuilder outType = this.addRawInterfaceDefinition(basePackageName, (SchemaNode)output, rpcName);
                this.addImplementedInterfaceFromUses((DataNodeContainer)output, outType);
                outType.addImplementsType((Type)BindingTypes.DATA_OBJECT);
                ParameterizedType _augmentable_1 = BindingTypes.augmentable((Type)outType);
                outType.addImplementsType((Type)_augmentable_1);
                Set _childNodes_2 = output.getChildNodes();
                this.resolveDataSchemaNodes(module, basePackageName, outType, outType, _childNodes_2);
                ModuleContext _get_1 = this.genCtx.get(module);
                SchemaPath _path_1 = output.getPath();
                _get_1.addChildNodeType(_path_1, outType);
                GeneratedType _instance = outType.toInstance();
                outTypeInstance = _instance;
            }
            ConcreteType _typeForClass_1 = Types.typeForClass(RpcResult.class);
            ParameterizedType rpcRes = Types.parameterizedTypeFor((Type)_typeForClass_1, (Type[])new Type[]{outTypeInstance});
            ParameterizedType _parameterizedTypeFor = Types.parameterizedTypeFor((Type)Types.FUTURE, (Type[])new Type[]{rpcRes});
            method.setReturnType((Type)_parameterizedTypeFor);
        }
        ModuleContext _get_2 = this.genCtx.get(module);
        _get_2.addTopLevelNodeType(interfaceBuilder);
    }

    private void notificationsToGenType(Module module) {
        boolean _tripleEquals;
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        String _name = module.getName();
        boolean _tripleNotEquals_1 = _name != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Module name cannot be NULL.");
        Set _childNodes = module.getChildNodes();
        boolean bl = _tripleEquals = _childNodes == null;
        if (_tripleEquals) {
            String _name_1 = module.getName();
            String _plus = "Reference to Set of Notification Definitions in module " + _name_1;
            String _plus_1 = _plus + " cannot be NULL.";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_1);
            throw _illegalArgumentException;
        }
        Set notifications = module.getNotifications();
        boolean _isEmpty = notifications.isEmpty();
        if (_isEmpty) {
            return;
        }
        GeneratedTypeBuilder listenerInterface = this.moduleTypeBuilder(module, "Listener");
        listenerInterface.addImplementsType((Type)BindingTypes.NOTIFICATION_LISTENER);
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        for (NotificationDefinition notification : notifications) {
            boolean _tripleNotEquals_2 = notification != null;
            if (!_tripleNotEquals_2) continue;
            this.processUsesAugments((DataNodeContainer)notification, module);
            GeneratedTypeBuilder notificationInterface = this.addDefaultInterfaceDefinition(basePackageName, (SchemaNode)notification, (Type)BindingTypes.DATA_OBJECT);
            notificationInterface.addImplementsType((Type)BindingTypes.NOTIFICATION);
            ModuleContext _get = this.genCtx.get(module);
            SchemaPath _path = notification.getPath();
            _get.addChildNodeType(_path, notificationInterface);
            Set _childNodes_1 = notification.getChildNodes();
            this.resolveDataSchemaNodes(module, basePackageName, notificationInterface, notificationInterface, _childNodes_1);
            String _name_2 = notificationInterface.getName();
            String _plus_2 = "on" + _name_2;
            MethodSignatureBuilder _addMethod = listenerInterface.addMethod(_plus_2);
            MethodSignatureBuilder _setAccessModifier = (MethodSignatureBuilder)_addMethod.setAccessModifier(AccessModifier.PUBLIC);
            MethodSignatureBuilder _addParameter = _setAccessModifier.addParameter((Type)notificationInterface, "notification");
            _addParameter.setReturnType((Type)Types.VOID);
        }
        ModuleContext _get_1 = this.genCtx.get(module);
        _get_1.addTopLevelNodeType(listenerInterface);
    }

    private void allIdentitiesToGenTypes(Module module, SchemaContext context) {
        boolean _tripleNotEquals;
        Set schemaIdentities = module.getIdentities();
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        boolean _and = false;
        boolean bl = _tripleNotEquals = schemaIdentities != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _isEmpty = schemaIdentities.isEmpty();
            boolean _not = !_isEmpty;
            boolean bl2 = _and = _tripleNotEquals && _not;
        }
        if (_and) {
            for (IdentitySchemaNode identity : schemaIdentities) {
                this.identityToGenType(module, basePackageName, identity, context);
            }
        }
    }

    private void identityToGenType(Module module, String basePackageName, IdentitySchemaNode identity, SchemaContext context) {
        boolean _tripleEquals_1;
        GeneratedTOBuilderImpl _generatedTOBuilderImpl;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = identity == null;
        if (_tripleEquals) {
            return;
        }
        SchemaPath _path = identity.getPath();
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
        QName _qName = identity.getQName();
        String genTypeName = BindingMapping.getClassName((QName)_qName);
        GeneratedTOBuilderImpl newType = _generatedTOBuilderImpl = new GeneratedTOBuilderImpl(packageName, genTypeName);
        IdentitySchemaNode baseIdentity = identity.getBaseIdentity();
        boolean bl2 = _tripleEquals_1 = baseIdentity == null;
        if (_tripleEquals_1) {
            GeneratedTransferObject _baseIdentityTO = Types.getBaseIdentityTO();
            newType.setExtendsType(_baseIdentityTO);
        } else {
            Module baseIdentityParentModule = SchemaContextUtil.findParentModule((SchemaContext)context, (SchemaNode)baseIdentity);
            String returnTypePkgName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)baseIdentityParentModule);
            QName _qName_1 = baseIdentity.getQName();
            String returnTypeName = BindingMapping.getClassName((QName)_qName_1);
            GeneratedTOBuilderImpl _generatedTOBuilderImpl_1 = new GeneratedTOBuilderImpl(returnTypePkgName, returnTypeName);
            GeneratedTransferObject gto = _generatedTOBuilderImpl_1.toInstance();
            newType.setExtendsType(gto);
        }
        newType.setAbstract(true);
        QName qname = identity.getQName();
        BindingGeneratorImpl.qnameConstant((GeneratedTypeBuilderBase<? extends Object>)newType, "QNAME", qname);
        ModuleContext _get = this.genCtx.get(module);
        QName _qName_2 = identity.getQName();
        _get.addIdentityType(_qName_2, (GeneratedTOBuilder)newType);
    }

    private static Constant qnameConstant(GeneratedTypeBuilderBase<? extends Object> toBuilder, String constantName, QName name) {
        ConcreteType _typeForClass = Types.typeForClass(QName.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"org.opendaylight.yangtools.yang.common.QName.create(\"");
        URI _namespace = name.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)"\",\"");
        String _formattedRevision = name.getFormattedRevision();
        _builder.append((Object)_formattedRevision, "");
        _builder.append((Object)"\",\"");
        String _localName = name.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"\")");
        _builder.newLineIfNotEmpty();
        Constant _addConstant = toBuilder.addConstant((Type)_typeForClass, constantName, (Object)_builder);
        return _addConstant;
    }

    private void groupingsToGenTypes(Module module, Collection<GroupingDefinition> groupings) {
        String basePackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        GroupingDefinitionDependencySort _groupingDefinitionDependencySort = new GroupingDefinitionDependencySort();
        List groupingsSortedByDependencies = _groupingDefinitionDependencySort.sort(groupings);
        for (GroupingDefinition grouping : groupingsSortedByDependencies) {
            this.groupingToGenType(basePackageName, grouping, module);
        }
    }

    private void groupingToGenType(String basePackageName, GroupingDefinition grouping, Module module) {
        SchemaPath _path = grouping.getPath();
        String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
        GeneratedTypeBuilder genType = this.addDefaultInterfaceDefinition(packageName, (SchemaNode)grouping);
        ModuleContext _get = this.genCtx.get(module);
        SchemaPath _path_1 = grouping.getPath();
        _get.addGroupingType(_path_1, genType);
        Set _childNodes = grouping.getChildNodes();
        this.resolveDataSchemaNodes(module, basePackageName, genType, genType, _childNodes);
        Set _groupings = grouping.getGroupings();
        this.groupingsToGenTypes(module, _groupings);
        this.processUsesAugments((DataNodeContainer)grouping, module);
    }

    private EnumTypeDefinition enumTypeDefFromExtendedType(TypeDefinition<? extends Object> typeDefinition) {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = typeDefinition != null;
        if (_tripleNotEquals) {
            TypeDefinition _baseType = typeDefinition.getBaseType();
            if (_baseType instanceof EnumTypeDefinition) {
                TypeDefinition _baseType_1 = typeDefinition.getBaseType();
                return (EnumTypeDefinition)_baseType_1;
            }
            TypeDefinition _baseType_2 = typeDefinition.getBaseType();
            if (_baseType_2 instanceof ExtendedType) {
                TypeDefinition _baseType_3 = typeDefinition.getBaseType();
                return this.enumTypeDefFromExtendedType((TypeDefinition<? extends Object>)_baseType_3);
            }
        }
        return null;
    }

    private EnumBuilder resolveInnerEnumFromTypeDefinition(EnumTypeDefinition enumTypeDef, QName enumName, GeneratedTypeBuilder typeBuilder) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _and_2 = false;
        boolean bl = _tripleNotEquals = enumTypeDef != null;
        if (!_tripleNotEquals) {
            _and_2 = false;
        } else {
            boolean _tripleNotEquals_1 = typeBuilder != null;
            boolean bl2 = _and_2 = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (!_and_2) {
            _and_1 = false;
        } else {
            QName _qName = enumTypeDef.getQName();
            boolean _tripleNotEquals_2 = _qName != null;
            boolean bl3 = _and_1 = _and_2 && _tripleNotEquals_2;
        }
        if (!_and_1) {
            _and = false;
        } else {
            QName _qName_1 = enumTypeDef.getQName();
            String _localName = _qName_1.getLocalName();
            boolean _tripleNotEquals_3 = _localName != null;
            boolean bl4 = _and = _and_1 && _tripleNotEquals_3;
        }
        if (_and) {
            String enumerationName = BindingMapping.getClassName((QName)enumName);
            EnumBuilder enumBuilder = typeBuilder.addEnumeration(enumerationName);
            enumBuilder.updateEnumPairsFromEnumTypeDef(enumTypeDef);
            return enumBuilder;
        }
        return null;
    }

    private GeneratedTypeBuilder moduleTypeBuilder(Module module, String postfix) {
        boolean _tripleNotEquals = module != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Module reference cannot be NULL.");
        String packageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
        String _name = module.getName();
        String _className = BindingMapping.getClassName((String)_name);
        String moduleName = _className + postfix;
        GeneratedTypeBuilderImpl _generatedTypeBuilderImpl = new GeneratedTypeBuilderImpl(packageName, moduleName);
        return _generatedTypeBuilderImpl;
    }

    private void augmentationToGenTypes(String augmentPackageName, AugmentationSchema augSchema, Module module, UsesNode parentUsesNode) {
        boolean _tripleNotEquals_3;
        boolean _equals_2;
        boolean _tripleNotEquals = augmentPackageName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Package Name cannot be NULL.");
        boolean _tripleNotEquals_1 = augSchema != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Augmentation Schema cannot be NULL.");
        SchemaPath _targetPath = augSchema.getTargetPath();
        boolean _tripleNotEquals_2 = _targetPath != null;
        Preconditions.checkState((boolean)_tripleNotEquals_2, (Object)"Augmentation Schema does not contain Target Path (Target Path is NULL).");
        this.processUsesAugments((DataNodeContainer)augSchema, module);
        SchemaPath targetPath = augSchema.getTargetPath();
        SchemaNode targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)targetPath);
        boolean _and = false;
        if (!(targetSchemaNode instanceof DataSchemaNode)) {
            _and = false;
        } else {
            boolean _isAddedByUses = ((DataSchemaNode)targetSchemaNode).isAddedByUses();
            boolean bl = _and = targetSchemaNode instanceof DataSchemaNode && _isAddedByUses;
        }
        if (_and) {
            boolean _equals = Objects.equal((Object)parentUsesNode, null);
            if (_equals) {
                DataSchemaNode _findOriginal = this.findOriginal((DataSchemaNode)targetSchemaNode);
                targetSchemaNode = _findOriginal;
            } else {
                QName _qName = targetSchemaNode.getQName();
                String _localName = _qName.getLocalName();
                DataSchemaNode _findOriginalTargetFromGrouping = this.findOriginalTargetFromGrouping(_localName, parentUsesNode);
                targetSchemaNode = _findOriginalTargetFromGrouping;
            }
            boolean _equals_1 = Objects.equal((Object)targetSchemaNode, null);
            if (_equals_1) {
                String _plus = "Failed to find target node from grouping for augmentation " + augSchema;
                String _plus_1 = _plus + " in module ";
                String _name = module.getName();
                String _plus_2 = _plus_1 + _name;
                NullPointerException _nullPointerException = new NullPointerException(_plus_2);
                throw _nullPointerException;
            }
        }
        if (_equals_2 = Objects.equal((Object)targetSchemaNode, null)) {
            String _plus_3 = "augment target not found: " + targetPath;
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_3);
            throw _illegalArgumentException;
        }
        boolean bl = _tripleNotEquals_3 = targetSchemaNode != null;
        if (_tripleNotEquals_3) {
            boolean _not;
            boolean _tripleEquals_1;
            boolean _tripleEquals;
            SchemaPath _path = targetSchemaNode.getPath();
            GeneratedTypeBuilder targetTypeBuilder = this.findChildNodeByPath(_path);
            boolean bl2 = _tripleEquals = targetTypeBuilder == null;
            if (_tripleEquals) {
                GeneratedTypeBuilder _findCaseByPath;
                SchemaPath _path_1 = targetSchemaNode.getPath();
                targetTypeBuilder = _findCaseByPath = this.findCaseByPath(_path_1);
            }
            boolean bl3 = _tripleEquals_1 = targetTypeBuilder == null;
            if (_tripleEquals_1) {
                String _plus_4 = "Target type not yet generated: " + targetSchemaNode;
                NullPointerException _nullPointerException_1 = new NullPointerException(_plus_4);
                throw _nullPointerException_1;
            }
            boolean bl4 = _not = !(targetSchemaNode instanceof ChoiceNode);
            if (_not) {
                boolean _notEquals;
                String packageName = augmentPackageName;
                boolean bl5 = _notEquals = !Objects.equal((Object)parentUsesNode, null);
                if (_notEquals) {
                    String _packageNameForGeneratedType;
                    SchemaPath _targetPath_1 = augSchema.getTargetPath();
                    packageName = _packageNameForGeneratedType = BindingGeneratorUtil.packageNameForGeneratedType((String)augmentPackageName, (SchemaPath)_targetPath_1);
                }
                GeneratedType _instance = targetTypeBuilder.toInstance();
                GeneratedTypeBuilder augTypeBuilder = this.addRawAugmentGenTypeDefinition(module, packageName, augmentPackageName, (Type)_instance, augSchema);
                ModuleContext _get = this.genCtx.get(module);
                _get.addAugmentType(augTypeBuilder);
                ModuleContext _get_1 = this.genCtx.get(module);
                _get_1.addTypeToAugmentation(augTypeBuilder, augSchema);
            } else {
                GeneratedType _instance_1 = targetTypeBuilder.toInstance();
                Set _childNodes = augSchema.getChildNodes();
                this.generateTypesFromAugmentedChoiceCases(module, augmentPackageName, (Type)_instance_1, (ChoiceNode)targetSchemaNode, _childNodes);
            }
        }
    }

    private DataSchemaNode findOriginal(DataSchemaNode node) {
        DataSchemaNode result = this.findCorrectTargetFromGrouping(node);
        boolean _equals = Objects.equal((Object)result, null);
        if (_equals) {
            boolean _isAddedByUses;
            boolean _notEquals;
            DataSchemaNode _findCorrectTargetFromAugment = this.findCorrectTargetFromAugment(node);
            result = _findCorrectTargetFromAugment;
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (_notEquals && (_isAddedByUses = result.isAddedByUses())) {
                DataSchemaNode _findOriginal;
                result = _findOriginal = this.findOriginal(result);
            }
        }
        return result;
    }

    private DataSchemaNode findCorrectTargetFromAugment(DataSchemaNode node) {
        boolean _and;
        ArrayList<SchemaNode> _arrayList_1;
        ArrayList<QName> _arrayList;
        boolean _not;
        boolean _isAugmenting = node.isAugmenting();
        boolean bl = _not = !_isAugmenting;
        if (_not) {
            return null;
        }
        QName currentName = node.getQName();
        DataSchemaNode currentNode = node;
        DataSchemaNode parent = node;
        ArrayList<QName> tmpPath = _arrayList = new ArrayList<QName>();
        ArrayList<SchemaNode> tmpTree = _arrayList_1 = new ArrayList<SchemaNode>();
        AugmentationSchema augment = null;
        boolean _dowhile = false;
        do {
            SchemaPath _schemaPath;
            ArrayList _arrayList_2;
            SchemaPath sp = ((SchemaNode)parent).getPath();
            List names = sp.getPath();
            ArrayList newNames = _arrayList_2 = new ArrayList(names);
            int _size = newNames.size();
            int _minus = _size - 1;
            newNames.remove(_minus);
            boolean _isAbsolute = sp.isAbsolute();
            SchemaPath newSp = _schemaPath = new SchemaPath(newNames, _isAbsolute);
            SchemaNode _findDataSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)newSp);
            parent = _findDataSchemaNode;
            if (parent instanceof AugmentationTarget) {
                AugmentationSchema _findNodeInAugment;
                tmpPath.add(currentName);
                tmpTree.add((SchemaNode)currentNode);
                Set _availableAugmentations = ((AugmentationTarget)parent).getAvailableAugmentations();
                augment = _findNodeInAugment = this.findNodeInAugment(_availableAugmentations, currentName);
                boolean _equals = Objects.equal((Object)augment, null);
                if (_equals) {
                    QName _qName;
                    currentName = _qName = parent.getQName();
                    currentNode = parent;
                }
            }
            _and = false;
            boolean _isAugmenting_1 = parent.isAugmenting();
            if (!_isAugmenting_1) {
                _and = false;
                continue;
            }
            boolean _equals = Objects.equal(augment, null);
            boolean bl2 = _and = _isAugmenting_1 && _equals;
        } while (_dowhile = _and);
        boolean _equals_1 = Objects.equal(augment, null);
        if (_equals_1) {
            return null;
        }
        Collections.reverse(tmpPath);
        Collections.reverse(tmpTree);
        AugmentationSchema actualParent = augment;
        DataSchemaNode result = null;
        for (QName name : tmpPath) {
            if (actualParent instanceof DataNodeContainer) {
                DataSchemaNode _dataChildByName;
                String _localName = name.getLocalName();
                result = _dataChildByName = ((DataNodeContainer)actualParent).getDataChildByName(_localName);
                String _localName_1 = name.getLocalName();
                DataSchemaNode _dataChildByName_1 = ((DataNodeContainer)actualParent).getDataChildByName(_localName_1);
                actualParent = _dataChildByName_1;
                continue;
            }
            if (!(actualParent instanceof ChoiceNode)) continue;
            String _localName_2 = name.getLocalName();
            ChoiceCaseNode _caseNodeByName = ((ChoiceNode)actualParent).getCaseNodeByName(_localName_2);
            result = _caseNodeByName;
            String _localName_3 = name.getLocalName();
            ChoiceCaseNode _caseNodeByName_1 = ((ChoiceNode)actualParent).getCaseNodeByName(_localName_3);
            actualParent = _caseNodeByName_1;
        }
        boolean _isAddedByUses = result.isAddedByUses();
        if (_isAddedByUses) {
            DataSchemaNode _findCorrectTargetFromAugmentGrouping;
            result = _findCorrectTargetFromAugmentGrouping = this.findCorrectTargetFromAugmentGrouping(result, augment, tmpTree);
        }
        return result;
    }

    private AugmentationSchema findNodeInAugment(Collection<AugmentationSchema> augments, QName name) {
        for (AugmentationSchema augment : augments) {
            DataSchemaNode node = augment.getDataChildByName(name);
            boolean _notEquals = !Objects.equal((Object)node, null);
            if (!_notEquals) continue;
            return augment;
        }
        return null;
    }

    private DataSchemaNode findCorrectTargetFromGrouping(DataSchemaNode node) {
        boolean _notEquals;
        boolean _and;
        SchemaNode _findDataSchemaNode;
        SchemaPath _schemaPath;
        ArrayList _arrayList_1;
        ArrayList<QName> _arrayList;
        boolean _equals;
        SchemaPath _path = node.getPath();
        List _path_1 = _path.getPath();
        int _size = _path_1.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            Module m = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)node);
            DataSchemaNode result = null;
            Set _uses = m.getUses();
            for (UsesNode u : _uses) {
                DataSchemaNode _dataChildByName;
                boolean _not;
                SchemaPath _groupingPath = u.getGroupingPath();
                List _path_2 = _groupingPath.getPath();
                SchemaNode targetGrouping = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (List)_path_2);
                boolean bl2 = _not = !(targetGrouping instanceof GroupingDefinition);
                if (_not) {
                    String _plus = "Failed to generate code for augment in " + u;
                    IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
                    throw _illegalArgumentException;
                }
                GroupingDefinition gr = (GroupingDefinition)targetGrouping;
                QName _qName = node.getQName();
                String _localName = _qName.getLocalName();
                result = _dataChildByName = gr.getDataChildByName(_localName);
            }
            boolean _equals_1 = Objects.equal(result, null);
            if (_equals_1) {
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Failed to generate code for augment");
                throw _illegalArgumentException;
            }
            return result;
        }
        DataSchemaNode result_1 = null;
        QName currentName = node.getQName();
        ArrayList<QName> tmpPath = _arrayList = new ArrayList<QName>();
        SchemaNode parent = null;
        SchemaPath sp = node.getPath();
        List names = sp.getPath();
        ArrayList newNames = _arrayList_1 = new ArrayList(names);
        int _size_1 = newNames.size();
        int _minus = _size_1 - 1;
        newNames.remove(_minus);
        boolean _isAbsolute = sp.isAbsolute();
        SchemaPath newSp = _schemaPath = new SchemaPath(newNames, _isAbsolute);
        parent = _findDataSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)newSp);
        boolean _dowhile = false;
        do {
            tmpPath.add(currentName);
            DataNodeContainer dataNodeParent = (DataNodeContainer)parent;
            Set _uses_1 = dataNodeParent.getUses();
            for (UsesNode u_1 : _uses_1) {
                DataSchemaNode _resultFromUses;
                boolean _equals_2 = Objects.equal(result_1, null);
                if (!_equals_2) continue;
                String _localName = currentName.getLocalName();
                result_1 = _resultFromUses = this.getResultFromUses(u_1, _localName);
            }
            boolean _equals_3 = Objects.equal(result_1, null);
            if (_equals_3) {
                QName _qName;
                currentName = _qName = parent.getQName();
                if (parent instanceof SchemaNode) {
                    ArrayList _arrayList_2;
                    SchemaPath nodeSp = parent.getPath();
                    List nodeNames = nodeSp.getPath();
                    ArrayList nodeNewNames = _arrayList_2 = new ArrayList(nodeNames);
                    int _size_2 = nodeNewNames.size();
                    int _minus_1 = _size_2 - 1;
                    nodeNewNames.remove(_minus_1);
                    boolean _isEmpty = nodeNewNames.isEmpty();
                    if (_isEmpty) {
                        Module _parentModule = this.getParentModule(parent);
                        parent = _parentModule;
                    } else {
                        SchemaNode _findDataSchemaNode_1;
                        SchemaPath _schemaPath_1;
                        boolean _isAbsolute_1 = nodeSp.isAbsolute();
                        SchemaPath nodeNewSp = _schemaPath_1 = new SchemaPath(nodeNewNames, _isAbsolute_1);
                        parent = _findDataSchemaNode_1 = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)nodeNewSp);
                    }
                } else {
                    IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Failed to generate code for augment");
                    throw _illegalArgumentException_1;
                }
            }
            _and = false;
            boolean _equals_2 = Objects.equal(result_1, null);
            if (!_equals_2) {
                _and = false;
                continue;
            }
            boolean _not = !(parent instanceof Module);
            boolean bl3 = _and = _equals_2 && _not;
        } while (_dowhile = _and);
        boolean bl4 = _notEquals = !Objects.equal((Object)result_1, null);
        if (_notEquals) {
            DataSchemaNode _targetNode;
            result_1 = _targetNode = this.getTargetNode(tmpPath, result_1);
        }
        return result_1;
    }

    private DataSchemaNode findCorrectTargetFromAugmentGrouping(DataSchemaNode node, AugmentationSchema parentNode, List<SchemaNode> dataTree) {
        boolean _notEquals;
        boolean _equals;
        ArrayList<QName> _arrayList;
        DataSchemaNode result = null;
        QName currentName = node.getQName();
        ArrayList<QName> tmpPath = _arrayList = new ArrayList<QName>();
        tmpPath.add(currentName);
        int i = 1;
        AugmentationSchema parent = null;
        boolean _dowhile = false;
        do {
            QName _qName_1;
            int _plus_1;
            boolean _lessThan;
            boolean _or = false;
            int _size = dataTree.size();
            boolean bl = _lessThan = _size < 2;
            if (_lessThan) {
                _or = true;
            } else {
                int _size_1 = dataTree.size();
                boolean _equals2 = _size_1 == i;
                boolean bl2 = _or = _lessThan || _equals2;
            }
            if (_or) {
                parent = parentNode;
            } else {
                int _size_2 = dataTree.size();
                int _plus = i + 1;
                int _minus = _size_2 - _plus;
                SchemaNode _get = dataTree.get(_minus);
                parent = _get;
                QName _qName = ((SchemaNode)parent).getQName();
                tmpPath.add(_qName);
            }
            DataNodeContainer dataNodeParent = (DataNodeContainer)parent;
            Set _uses = dataNodeParent.getUses();
            for (UsesNode u : _uses) {
                DataSchemaNode _resultFromUses;
                boolean _equals_1 = Objects.equal(result, null);
                if (!_equals_1) continue;
                String _localName = currentName.getLocalName();
                result = _resultFromUses = this.getResultFromUses(u, _localName);
            }
            boolean _equals_2 = Objects.equal(result, null);
            if (!_equals_2) continue;
            i = _plus_1 = i + 1;
            currentName = _qName_1 = ((SchemaNode)parent).getQName();
        } while (_dowhile = (_equals = Objects.equal(result, null)));
        boolean bl = _notEquals = !Objects.equal(result, null);
        if (_notEquals) {
            DataSchemaNode _targetNode;
            result = _targetNode = this.getTargetNode(tmpPath, result);
        }
        return result;
    }

    private DataSchemaNode getResultFromUses(UsesNode u, String currentName) {
        boolean _not;
        SchemaPath _groupingPath = u.getGroupingPath();
        List _path = _groupingPath.getPath();
        SchemaNode targetGrouping = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (List)_path);
        boolean bl = _not = !(targetGrouping instanceof GroupingDefinition);
        if (_not) {
            String _plus = "Failed to generate code for augment in " + u;
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        GroupingDefinition gr = (GroupingDefinition)targetGrouping;
        return gr.getDataChildByName(currentName);
    }

    private DataSchemaNode getTargetNode(List<QName> tmpPath, DataSchemaNode node) {
        boolean _notEquals_1;
        boolean _equals;
        DataSchemaNode result = node;
        int _size = tmpPath.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            boolean _notEquals;
            boolean _and = false;
            boolean bl2 = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _isAddedByUses = result.isAddedByUses();
                boolean bl3 = _and = _notEquals && _isAddedByUses;
            }
            if (_and) {
                DataSchemaNode _findOriginal;
                result = _findOriginal = this.findOriginal(result);
            }
            return result;
        }
        DataSchemaNode newParent = result;
        Collections.reverse(tmpPath);
        tmpPath.remove(0);
        for (QName name : tmpPath) {
            DataSchemaNode _dataChildByName;
            String _localName = name.getLocalName();
            newParent = _dataChildByName = ((DataNodeContainer)newParent).getDataChildByName(_localName);
        }
        boolean _and_1 = false;
        boolean bl4 = _notEquals_1 = !Objects.equal((Object)newParent, null);
        if (!_notEquals_1) {
            _and_1 = false;
        } else {
            boolean _isAddedByUses_1 = newParent.isAddedByUses();
            boolean bl5 = _and_1 = _notEquals_1 && _isAddedByUses_1;
        }
        if (_and_1) {
            DataSchemaNode _findOriginal_1;
            newParent = _findOriginal_1 = this.findOriginal(newParent);
        }
        return newParent;
    }

    private DataSchemaNode findOriginalTargetFromGrouping(String targetSchemaNodeName, UsesNode parentUsesNode) {
        boolean _not;
        SchemaPath _groupingPath = parentUsesNode.getGroupingPath();
        List _path = _groupingPath.getPath();
        SchemaNode targetGrouping = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (List)_path);
        boolean bl = _not = !(targetGrouping instanceof GroupingDefinition);
        if (_not) {
            String _plus = "Failed to generate code for augment in " + parentUsesNode;
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        GroupingDefinition grouping = (GroupingDefinition)targetGrouping;
        DataSchemaNode result = grouping.getDataChildByName(targetSchemaNodeName);
        boolean _equals = Objects.equal((Object)result, null);
        if (_equals) {
            return null;
        }
        boolean fromUses = result.isAddedByUses();
        Set _uses = grouping.getUses();
        Iterator groupingUses = _uses.iterator();
        boolean _while = fromUses;
        while (_while) {
            boolean _isAddedByUses;
            DataSchemaNode _dataChildByName;
            boolean _hasNext = groupingUses.hasNext();
            if (!_hasNext) {
                String _plus_1 = "Failed to generate code for augment in " + parentUsesNode;
                NullPointerException _nullPointerException = new NullPointerException(_plus_1);
                throw _nullPointerException;
            }
            UsesNode _next = (UsesNode)groupingUses.next();
            SchemaPath _groupingPath_1 = _next.getGroupingPath();
            List _path_1 = _groupingPath_1.getPath();
            SchemaNode _findNodeInSchemaContext = SchemaContextUtil.findNodeInSchemaContext((SchemaContext)this.schemaContext, (List)_path_1);
            grouping = (GroupingDefinition)_findNodeInSchemaContext;
            result = _dataChildByName = grouping.getDataChildByName(targetSchemaNodeName);
            fromUses = _isAddedByUses = result.isAddedByUses();
            _while = fromUses;
        }
        return result;
    }

    private GeneratedTypeBuilder addRawAugmentGenTypeDefinition(Module module, String augmentPackageName, String basePackageName, Type targetTypeRef, AugmentationSchema augSchema) {
        GeneratedTypeBuilderImpl _generatedTypeBuilderImpl;
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        Map<String, GeneratedTypeBuilder> augmentBuilders = this.genTypeBuilders.get(augmentPackageName);
        boolean bl = _tripleEquals = augmentBuilders == null;
        if (_tripleEquals) {
            HashMap<String, GeneratedTypeBuilder> _hashMap = new HashMap<String, GeneratedTypeBuilder>();
            augmentBuilders = _hashMap;
            this.genTypeBuilders.put(augmentPackageName, augmentBuilders);
        }
        List _unknownSchemaNodes = augSchema.getUnknownSchemaNodes();
        String augIdentifier = this.getAugmentIdentifier(_unknownSchemaNodes);
        String _xifexpression = null;
        boolean bl2 = _tripleNotEquals = augIdentifier != null;
        if (_tripleNotEquals) {
            String _className;
            _xifexpression = _className = BindingMapping.getClassName((String)augIdentifier);
        } else {
            String _augGenTypeName;
            String _name = targetTypeRef.getName();
            _xifexpression = _augGenTypeName = this.augGenTypeName(augmentBuilders, _name);
        }
        String augTypeName = _xifexpression;
        GeneratedTypeBuilderImpl augTypeBuilder = _generatedTypeBuilderImpl = new GeneratedTypeBuilderImpl(augmentPackageName, augTypeName);
        augTypeBuilder.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        ParameterizedType _augmentationTypeFor = Types.augmentationTypeFor((Type)targetTypeRef);
        augTypeBuilder.addImplementsType((Type)_augmentationTypeFor);
        this.addImplementedInterfaceFromUses((DataNodeContainer)augSchema, (GeneratedTypeBuilder)augTypeBuilder);
        Set _childNodes = augSchema.getChildNodes();
        this.augSchemaNodeToMethods(module, basePackageName, (GeneratedTypeBuilder)augTypeBuilder, (GeneratedTypeBuilder)augTypeBuilder, _childNodes);
        augmentBuilders.put(augTypeName, (GeneratedTypeBuilder)augTypeBuilder);
        return augTypeBuilder;
    }

    private String getAugmentIdentifier(List<UnknownSchemaNode> unknownSchemaNodes) {
        for (UnknownSchemaNode unknownSchemaNode : unknownSchemaNodes) {
            QName nodeType = unknownSchemaNode.getNodeType();
            boolean _and = false;
            String _localName = nodeType.getLocalName();
            boolean _equals = AUGMENT_IDENTIFIER_NAME.equals(_localName);
            if (!_equals) {
                _and = false;
            } else {
                URI _namespace = nodeType.getNamespace();
                String _string = _namespace.toString();
                boolean _equals_1 = YANG_EXT_NAMESPACE.equals(_string);
                boolean bl = _and = _equals && _equals_1;
            }
            if (!_and) continue;
            return unknownSchemaNode.getNodeParameter();
        }
        return null;
    }

    private String augGenTypeName(Map<String, GeneratedTypeBuilder> builders, String genTypeName) {
        boolean _tripleNotEquals;
        int index = 1;
        boolean _and = false;
        boolean bl = _tripleNotEquals = builders != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            String _plus = genTypeName + Integer.valueOf(index);
            boolean _containsKey = builders.containsKey(_plus);
            _and = _tripleNotEquals && _containsKey;
        }
        boolean _while = _and;
        while (_while) {
            boolean _tripleNotEquals_1;
            int _plus_1;
            index = _plus_1 = index + 1;
            boolean _and_1 = false;
            boolean bl2 = _tripleNotEquals_1 = builders != null;
            if (!_tripleNotEquals_1) {
                _and_1 = false;
            } else {
                String _plus_2 = genTypeName + Integer.valueOf(index);
                boolean _containsKey_1 = builders.containsKey(_plus_2);
                _and_1 = _tripleNotEquals_1 && _containsKey_1;
            }
            _while = _and_1;
        }
        return genTypeName + Integer.valueOf(index);
    }

    private GeneratedTypeBuilder resolveDataSchemaNodes(Module module, String basePackageName, GeneratedTypeBuilder parent, GeneratedTypeBuilder childOf, Set<DataSchemaNode> schemaNodes) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = schemaNodes != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = parent != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            for (DataSchemaNode schemaNode : schemaNodes) {
                boolean _not;
                boolean _and_1 = false;
                boolean _isAugmenting = schemaNode.isAugmenting();
                boolean bl3 = _not = !_isAugmenting;
                if (!_not) {
                    _and_1 = false;
                } else {
                    boolean _isAddedByUses = schemaNode.isAddedByUses();
                    boolean _not_1 = !_isAddedByUses;
                    boolean bl4 = _and_1 = _not && _not_1;
                }
                if (!_and_1) continue;
                this.addSchemaNodeToBuilderAsMethod(basePackageName, schemaNode, parent, childOf, module);
            }
        }
        return parent;
    }

    private GeneratedTypeBuilder augSchemaNodeToMethods(Module module, String basePackageName, GeneratedTypeBuilder typeBuilder, GeneratedTypeBuilder childOf, Set<DataSchemaNode> schemaNodes) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = schemaNodes != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = typeBuilder != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            for (DataSchemaNode schemaNode : schemaNodes) {
                boolean _isAugmenting = schemaNode.isAugmenting();
                boolean _not = !_isAugmenting;
                if (!_not) continue;
                this.addSchemaNodeToBuilderAsMethod(basePackageName, schemaNode, typeBuilder, childOf, module);
            }
        }
        return typeBuilder;
    }

    private void addSchemaNodeToBuilderAsMethod(String basePackageName, DataSchemaNode node, GeneratedTypeBuilder typeBuilder, GeneratedTypeBuilder childOf, Module module) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = node != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = typeBuilder != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            boolean _matched = false;
            if (!_matched && node instanceof LeafSchemaNode) {
                _matched = true;
                this.resolveLeafSchemaNodeAsMethod(typeBuilder, (LeafSchemaNode)node);
            }
            if (!_matched && node instanceof LeafListSchemaNode) {
                _matched = true;
                this.resolveLeafListSchemaNode(typeBuilder, (LeafListSchemaNode)node);
            }
            if (!_matched && node instanceof ContainerSchemaNode) {
                _matched = true;
                this.containerToGenType(module, basePackageName, typeBuilder, childOf, (ContainerSchemaNode)node);
            }
            if (!_matched && node instanceof ListSchemaNode) {
                _matched = true;
                this.listToGenType(module, basePackageName, typeBuilder, childOf, (ListSchemaNode)node);
            }
            if (!_matched && node instanceof ChoiceNode) {
                _matched = true;
                this.choiceToGeneratedType(module, basePackageName, typeBuilder, (ChoiceNode)node);
            }
        }
    }

    private void choiceToGeneratedType(Module module, String basePackageName, GeneratedTypeBuilder parent, ChoiceNode choiceNode) {
        boolean _not;
        boolean _tripleNotEquals = basePackageName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Base Package Name cannot be NULL.");
        boolean _tripleNotEquals_1 = choiceNode != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Choice Schema Node cannot be NULL.");
        boolean _isAddedByUses = choiceNode.isAddedByUses();
        boolean bl = _not = !_isAddedByUses;
        if (_not) {
            SchemaPath _path = choiceNode.getPath();
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
            GeneratedTypeBuilder choiceTypeBuilder = this.addRawInterfaceDefinition(packageName, (SchemaNode)choiceNode);
            QName _qName = choiceNode.getQName();
            String _localName = _qName.getLocalName();
            String _description = choiceNode.getDescription();
            this.constructGetter(parent, _localName, _description, (Type)choiceTypeBuilder);
            ConcreteType _typeForClass = Types.typeForClass(DataContainer.class);
            choiceTypeBuilder.addImplementsType((Type)_typeForClass);
            ModuleContext _get = this.genCtx.get(module);
            SchemaPath _path_1 = choiceNode.getPath();
            _get.addChildNodeType(_path_1, choiceTypeBuilder);
            GeneratedType _instance = choiceTypeBuilder.toInstance();
            this.generateTypesFromChoiceCases(module, basePackageName, parent, (Type)_instance, choiceNode);
        }
    }

    private void generateTypesFromChoiceCases(Module module, String basePackageName, GeneratedTypeBuilder choiceParent, Type refChoiceType, ChoiceNode choiceNode) {
        boolean _tripleNotEquals = basePackageName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Base Package Name cannot be NULL.");
        boolean _tripleNotEquals_1 = refChoiceType != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Referenced Choice Type cannot be NULL.");
        boolean _tripleNotEquals_2 = choiceNode != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_2, (Object)"ChoiceNode cannot be NULL.");
        Set caseNodes = choiceNode.getCases();
        boolean _equals = Objects.equal((Object)caseNodes, null);
        if (_equals) {
            return;
        }
        for (ChoiceCaseNode caseNode : caseNodes) {
            boolean _tripleNotEquals_3;
            boolean _and = false;
            boolean _and_1 = false;
            boolean bl = _tripleNotEquals_3 = caseNode != null;
            if (!_tripleNotEquals_3) {
                _and_1 = false;
            } else {
                boolean _isAddedByUses = caseNode.isAddedByUses();
                boolean _not = !_isAddedByUses;
                boolean bl2 = _and_1 = _tripleNotEquals_3 && _not;
            }
            if (!_and_1) {
                _and = false;
            } else {
                boolean _isAugmenting = caseNode.isAugmenting();
                boolean _not_1 = !_isAugmenting;
                boolean bl3 = _and = _and_1 && _not_1;
            }
            if (_and) {
                boolean _tripleNotEquals_4;
                SchemaPath _path = caseNode.getPath();
                String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
                GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(packageName, (SchemaNode)caseNode);
                caseTypeBuilder.addImplementsType(refChoiceType);
                ModuleContext _get = this.genCtx.get(module);
                SchemaPath _path_1 = caseNode.getPath();
                _get.addCaseType(_path_1, caseTypeBuilder);
                Set caseChildNodes = caseNode.getChildNodes();
                boolean bl4 = _tripleNotEquals_4 = caseChildNodes != null;
                if (_tripleNotEquals_4) {
                    SchemaNode _findDataSchemaNode;
                    SchemaPath _schemaPath;
                    ArrayList _arrayList;
                    SchemaNode parentNode = null;
                    SchemaPath nodeSp = choiceNode.getPath();
                    List nodeNames = nodeSp.getPath();
                    ArrayList nodeNewNames = _arrayList = new ArrayList(nodeNames);
                    int _size = nodeNewNames.size();
                    int _minus = _size - 1;
                    nodeNewNames.remove(_minus);
                    boolean _isAbsolute = nodeSp.isAbsolute();
                    SchemaPath nodeNewSp = _schemaPath = new SchemaPath(nodeNewNames, _isAbsolute);
                    parentNode = _findDataSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)nodeNewSp);
                    SchemaNode parent = null;
                    if (parentNode instanceof AugmentationSchema) {
                        DataSchemaNode _findOriginal;
                        boolean _equals_1;
                        AugmentationSchema augSchema = (AugmentationSchema)parentNode;
                        SchemaPath targetPath = augSchema.getTargetPath();
                        SchemaNode targetSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)targetPath);
                        boolean _and_2 = false;
                        if (!(targetSchemaNode instanceof DataSchemaNode)) {
                            _and_2 = false;
                        } else {
                            boolean _isAddedByUses_1 = ((DataSchemaNode)targetSchemaNode).isAddedByUses();
                            boolean bl5 = _and_2 = targetSchemaNode instanceof DataSchemaNode && _isAddedByUses_1;
                        }
                        if (_and_2 && (_equals_1 = Objects.equal((Object)(targetSchemaNode = (_findOriginal = this.findOriginal((DataSchemaNode)targetSchemaNode))), null))) {
                            String _plus = "Failed to find target node from grouping for augmentation " + augSchema;
                            String _plus_1 = _plus + " in module ";
                            String _name = module.getName();
                            String _plus_2 = _plus_1 + _name;
                            NullPointerException _nullPointerException = new NullPointerException(_plus_2);
                            throw _nullPointerException;
                        }
                        parent = targetSchemaNode;
                    } else {
                        SchemaNode _findDataSchemaNode_1;
                        SchemaPath _schemaPath_1;
                        ArrayList _arrayList_1;
                        SchemaPath sp = choiceNode.getPath();
                        List names = sp.getPath();
                        ArrayList newNames = _arrayList_1 = new ArrayList(names);
                        int _size_1 = newNames.size();
                        int _minus_1 = _size_1 - 1;
                        newNames.remove(_minus_1);
                        boolean _isAbsolute_1 = sp.isAbsolute();
                        SchemaPath newSp = _schemaPath_1 = new SchemaPath(newNames, _isAbsolute_1);
                        parent = _findDataSchemaNode_1 = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)newSp);
                    }
                    SchemaPath _path_2 = parent.getPath();
                    GeneratedTypeBuilder childOfType = this.findChildNodeByPath(_path_2);
                    this.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, childOfType, caseChildNodes);
                }
            }
            this.processUsesAugments((DataNodeContainer)caseNode, module);
        }
    }

    private void generateTypesFromAugmentedChoiceCases(Module module, String basePackageName, Type targetType, ChoiceNode targetNode, Set<DataSchemaNode> augmentedNodes) {
        boolean _tripleNotEquals = basePackageName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Base Package Name cannot be NULL.");
        boolean _tripleNotEquals_1 = targetType != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Referenced Choice Type cannot be NULL.");
        boolean _tripleNotEquals_2 = augmentedNodes != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_2, (Object)"Set of Choice Case Nodes cannot be NULL.");
        for (DataSchemaNode caseNode : augmentedNodes) {
            SchemaNode _findDataSchemaNode;
            SchemaPath _schemaPath;
            ArrayList _arrayList;
            boolean _tripleNotEquals_3 = caseNode != null;
            if (!_tripleNotEquals_3) continue;
            SchemaPath _path = caseNode.getPath();
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
            GeneratedTypeBuilder caseTypeBuilder = this.addDefaultInterfaceDefinition(packageName, (SchemaNode)caseNode);
            caseTypeBuilder.addImplementsType(targetType);
            SchemaNode parent = null;
            SchemaPath nodeSp = targetNode.getPath();
            List nodeNames = nodeSp.getPath();
            ArrayList nodeNewNames = _arrayList = new ArrayList(nodeNames);
            int _size = nodeNewNames.size();
            int _minus = _size - 1;
            nodeNewNames.remove(_minus);
            boolean _isAbsolute = nodeSp.isAbsolute();
            SchemaPath nodeNewSp = _schemaPath = new SchemaPath(nodeNewNames, _isAbsolute);
            parent = _findDataSchemaNode = SchemaContextUtil.findDataSchemaNode((SchemaContext)this.schemaContext, (SchemaPath)nodeNewSp);
            GeneratedTypeBuilder childOfType = null;
            if (parent instanceof Module) {
                GeneratedTypeBuilder _moduleNode;
                ModuleContext _get = this.genCtx.get((Module)parent);
                childOfType = _moduleNode = _get.getModuleNode();
            } else if (parent instanceof ChoiceCaseNode) {
                GeneratedTypeBuilder _findCaseByPath;
                SchemaPath _path_1 = parent.getPath();
                childOfType = _findCaseByPath = this.findCaseByPath(_path_1);
            } else {
                boolean _or = false;
                if (parent instanceof DataSchemaNode) {
                    _or = true;
                } else {
                    boolean bl = _or = parent instanceof DataSchemaNode || parent instanceof NotificationDefinition;
                }
                if (_or) {
                    GeneratedTypeBuilder _findChildNodeByPath;
                    SchemaPath _path_2 = parent.getPath();
                    childOfType = _findChildNodeByPath = this.findChildNodeByPath(_path_2);
                } else if (parent instanceof GroupingDefinition) {
                    GeneratedTypeBuilder _findGroupingByPath;
                    SchemaPath _path_3 = parent.getPath();
                    childOfType = _findGroupingByPath = this.findGroupingByPath(_path_3);
                }
            }
            boolean _equals = Objects.equal((Object)childOfType, null);
            if (_equals) {
                String _plus = "Failed to find parent type of choice " + targetNode;
                IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
                throw _illegalArgumentException;
            }
            if (caseNode instanceof DataNodeContainer) {
                boolean _tripleNotEquals_4;
                DataNodeContainer dataNodeCase = (DataNodeContainer)caseNode;
                Set childNodes = dataNodeCase.getChildNodes();
                boolean bl = _tripleNotEquals_4 = childNodes != null;
                if (_tripleNotEquals_4) {
                    this.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, childOfType, childNodes);
                }
            } else {
                boolean _tripleNotEquals_5;
                QName _qName = caseNode.getQName();
                String _localName = _qName.getLocalName();
                ChoiceCaseNode node = targetNode.getCaseNodeByName(_localName);
                Set childNodes_1 = node.getChildNodes();
                boolean bl = _tripleNotEquals_5 = childNodes_1 != null;
                if (_tripleNotEquals_5) {
                    this.resolveDataSchemaNodes(module, basePackageName, caseTypeBuilder, childOfType, childNodes_1);
                }
            }
            ModuleContext _get_1 = this.genCtx.get(module);
            SchemaPath _path_4 = caseNode.getPath();
            _get_1.addCaseType(_path_4, caseTypeBuilder);
        }
    }

    private boolean resolveLeafSchemaNodeAsMethod(GeneratedTypeBuilder typeBuilder, LeafSchemaNode leaf) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = leaf != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = typeBuilder != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            boolean _tripleNotEquals_2;
            boolean _tripleEquals;
            QName _qName = leaf.getQName();
            String leafName = _qName.getLocalName();
            String leafDesc = leaf.getDescription();
            boolean bl3 = _tripleEquals = leafDesc == null;
            if (_tripleEquals) {
                leafDesc = "";
            }
            Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)leaf);
            boolean _and_1 = false;
            boolean bl4 = _tripleNotEquals_2 = leafName != null;
            if (!_tripleNotEquals_2) {
                _and_1 = false;
            } else {
                boolean _isAddedByUses = leaf.isAddedByUses();
                boolean _not = !_isAddedByUses;
                boolean bl5 = _and_1 = _tripleNotEquals_2 && _not;
            }
            if (_and_1) {
                boolean _tripleNotEquals_6;
                TypeDefinition typeDef = leaf.getType();
                Type returnType = null;
                GeneratedTOBuilder genTOBuilder = null;
                if (typeDef instanceof EnumTypeDefinition) {
                    boolean _tripleNotEquals_3;
                    Type _javaTypeForSchemaDefinitionType;
                    returnType = _javaTypeForSchemaDefinitionType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf);
                    EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                    QName _qName_1 = leaf.getQName();
                    EnumBuilder enumBuilder = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, _qName_1, typeBuilder);
                    boolean bl6 = _tripleNotEquals_3 = enumBuilder != null;
                    if (_tripleNotEquals_3) {
                        String _packageName = enumBuilder.getPackageName();
                        String _name = enumBuilder.getName();
                        ReferencedTypeImpl _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
                        returnType = _referencedTypeImpl;
                    }
                    SchemaPath _path = leaf.getPath();
                    ((TypeProviderImpl)this.typeProvider).putReferencedType(_path, returnType);
                } else if (typeDef instanceof UnionType) {
                    boolean _tripleNotEquals_4;
                    GeneratedTOBuilder _addTOToTypeBuilder = this.addTOToTypeBuilder((TypeDefinition<? extends Object>)typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                    genTOBuilder = _addTOToTypeBuilder;
                    boolean bl7 = _tripleNotEquals_4 = genTOBuilder != null;
                    if (_tripleNotEquals_4) {
                        Type _createReturnTypeForUnion;
                        returnType = _createReturnTypeForUnion = this.createReturnTypeForUnion(genTOBuilder, (TypeDefinition<? extends Object>)typeDef, typeBuilder, parentModule);
                    }
                } else if (typeDef instanceof BitsTypeDefinition) {
                    boolean _tripleNotEquals_5;
                    GeneratedTOBuilder _addTOToTypeBuilder_1 = this.addTOToTypeBuilder((TypeDefinition<? extends Object>)typeDef, typeBuilder, (DataSchemaNode)leaf, parentModule);
                    genTOBuilder = _addTOToTypeBuilder_1;
                    boolean bl8 = _tripleNotEquals_5 = genTOBuilder != null;
                    if (_tripleNotEquals_5) {
                        String _packageName_1 = genTOBuilder.getPackageName();
                        String _name_1 = genTOBuilder.getName();
                        ReferencedTypeImpl _referencedTypeImpl_1 = new ReferencedTypeImpl(_packageName_1, _name_1);
                        returnType = _referencedTypeImpl_1;
                    }
                } else {
                    Type _javaTypeForSchemaDefinitionType_1;
                    Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                    returnType = _javaTypeForSchemaDefinitionType_1 = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf, restrictions);
                }
                boolean bl9 = _tripleNotEquals_6 = returnType != null;
                if (_tripleNotEquals_6) {
                    MethodSignatureBuilder getter = this.constructGetter(typeBuilder, leafName, leafDesc, returnType);
                    this.processContextRefExtension(leaf, getter, parentModule);
                    return true;
                }
            }
        }
        return false;
    }

    private void processContextRefExtension(LeafSchemaNode leaf, MethodSignatureBuilder getter, Module module) {
        List _unknownSchemaNodes = leaf.getUnknownSchemaNodes();
        for (UnknownSchemaNode node : _unknownSchemaNodes) {
            boolean _equals_1;
            QName nodeType = node.getNodeType();
            String _localName = nodeType.getLocalName();
            boolean _equals = "context-reference".equals(_localName);
            if (!_equals) continue;
            String nodeParam = node.getNodeParameter();
            IdentitySchemaNode identity = null;
            String basePackageName = null;
            String[] splittedElement = nodeParam.split(":");
            int _length = splittedElement.length;
            boolean bl = _equals_1 = _length == 1;
            if (_equals_1) {
                String _moduleNamespaceToPackageName;
                IdentitySchemaNode _findIdentityByName;
                Set _identities = module.getIdentities();
                String _get = splittedElement[0];
                identity = _findIdentityByName = this.findIdentityByName(_identities, _get);
                basePackageName = _moduleNamespaceToPackageName = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
            } else {
                boolean _equals_2;
                int _length_1 = splittedElement.length;
                boolean bl2 = _equals_2 = _length_1 == 2;
                if (_equals_2) {
                    String _moduleNamespaceToPackageName_1;
                    IdentitySchemaNode _findIdentityByName_1;
                    String prefix = splittedElement[0];
                    Set _imports = module.getImports();
                    Module dependentModule = this.findModuleFromImports(_imports, prefix);
                    boolean _equals_3 = Objects.equal((Object)dependentModule, null);
                    if (_equals_3) {
                        String _plus = "Failed to process context-reference: unknown prefix " + prefix;
                        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
                        throw _illegalArgumentException;
                    }
                    Set _identities_1 = dependentModule.getIdentities();
                    String _get_1 = splittedElement[1];
                    identity = _findIdentityByName_1 = this.findIdentityByName(_identities_1, _get_1);
                    basePackageName = _moduleNamespaceToPackageName_1 = BindingGeneratorUtil.moduleNamespaceToPackageName((Module)dependentModule);
                } else {
                    String _plus_1 = "Failed to process context-reference: unknown identity " + nodeParam;
                    IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException(_plus_1);
                    throw _illegalArgumentException_1;
                }
            }
            boolean _equals_4 = Objects.equal((Object)identity, null);
            if (_equals_4) {
                String _plus_2 = "Failed to process context-reference: unknown identity " + nodeParam;
                IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException(_plus_2);
                throw _illegalArgumentException_2;
            }
            Class<RoutingContext> clazz = RoutingContext.class;
            Package _package = clazz.getPackage();
            String _name = _package.getName();
            String _simpleName = clazz.getSimpleName();
            AnnotationTypeBuilder rc = getter.addAnnotation(_name, _simpleName);
            SchemaPath _path = identity.getPath();
            String packageName = BindingGeneratorUtil.packageNameForGeneratedType((String)basePackageName, (SchemaPath)_path);
            QName _qName = identity.getQName();
            String _localName_1 = _qName.getLocalName();
            String genTypeName = BindingMapping.getClassName((String)_localName_1);
            String _plus_3 = packageName + ".";
            String _plus_4 = _plus_3 + genTypeName;
            String _plus_5 = _plus_4 + ".class";
            rc.addParameter("value", _plus_5);
        }
    }

    private IdentitySchemaNode findIdentityByName(Set<IdentitySchemaNode> identities, String name) {
        for (IdentitySchemaNode id : identities) {
            QName _qName = id.getQName();
            String _localName = _qName.getLocalName();
            boolean _equals = _localName.equals(name);
            if (!_equals) continue;
            return id;
        }
        return null;
    }

    private Module findModuleFromImports(Set<ModuleImport> imports, String prefix) {
        for (ModuleImport imp : imports) {
            String _prefix = imp.getPrefix();
            boolean _equals = _prefix.equals(prefix);
            if (!_equals) continue;
            String _moduleName = imp.getModuleName();
            Date _revision = imp.getRevision();
            return this.schemaContext.findModuleByName(_moduleName, _revision);
        }
        return null;
    }

    private boolean resolveLeafSchemaNodeAsProperty(GeneratedTOBuilder toBuilder, LeafSchemaNode leaf, boolean isReadOnly) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = leaf != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = toBuilder != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            boolean _tripleNotEquals_2;
            boolean _tripleEquals;
            QName _qName = leaf.getQName();
            String leafName = _qName.getLocalName();
            String leafDesc = leaf.getDescription();
            boolean bl3 = _tripleEquals = leafDesc == null;
            if (_tripleEquals) {
                leafDesc = "";
            }
            boolean bl4 = _tripleNotEquals_2 = leafName != null;
            if (_tripleNotEquals_2) {
                boolean _tripleNotEquals_3;
                TypeDefinition typeDef = leaf.getType();
                Type returnType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)leaf);
                boolean bl5 = _tripleNotEquals_3 = returnType != null;
                if (_tripleNotEquals_3) {
                    String _parseToValidParamName = BindingGeneratorUtil.parseToValidParamName((String)leafName);
                    GeneratedPropertyBuilder propBuilder = toBuilder.addProperty(_parseToValidParamName);
                    propBuilder.setReadOnly(isReadOnly);
                    propBuilder.setReturnType(returnType);
                    propBuilder.setComment(leafDesc);
                    toBuilder.addEqualsIdentity(propBuilder);
                    toBuilder.addHashIdentity(propBuilder);
                    toBuilder.addToStringProperty(propBuilder);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean resolveLeafListSchemaNode(GeneratedTypeBuilder typeBuilder, LeafListSchemaNode node) {
        boolean _tripleNotEquals;
        boolean _and = false;
        boolean bl = _tripleNotEquals = node != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _tripleNotEquals_1 = typeBuilder != null;
            boolean bl2 = _and = _tripleNotEquals && _tripleNotEquals_1;
        }
        if (_and) {
            boolean _tripleNotEquals_2;
            boolean _tripleEquals;
            QName nodeName = node.getQName();
            String nodeDesc = node.getDescription();
            boolean bl3 = _tripleEquals = nodeDesc == null;
            if (_tripleEquals) {
                nodeDesc = "";
            }
            boolean _and_1 = false;
            boolean bl4 = _tripleNotEquals_2 = nodeName != null;
            if (!_tripleNotEquals_2) {
                _and_1 = false;
            } else {
                boolean _isAddedByUses = node.isAddedByUses();
                boolean _not = !_isAddedByUses;
                boolean bl5 = _and_1 = _tripleNotEquals_2 && _not;
            }
            if (_and_1) {
                TypeDefinition typeDef = node.getType();
                Module parentModule = SchemaContextUtil.findParentModule((SchemaContext)this.schemaContext, (SchemaNode)node);
                Type returnType = null;
                if (typeDef instanceof EnumTypeDefinition) {
                    Type _javaTypeForSchemaDefinitionType;
                    returnType = _javaTypeForSchemaDefinitionType = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node);
                    EnumTypeDefinition enumTypeDef = (EnumTypeDefinition)typeDef;
                    EnumBuilder enumBuilder = this.resolveInnerEnumFromTypeDefinition(enumTypeDef, nodeName, typeBuilder);
                    String _packageName = enumBuilder.getPackageName();
                    String _name = enumBuilder.getName();
                    ReferencedTypeImpl _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
                    returnType = _referencedTypeImpl;
                    SchemaPath _path = node.getPath();
                    ((TypeProviderImpl)this.typeProvider).putReferencedType(_path, returnType);
                } else if (typeDef instanceof UnionType) {
                    boolean _tripleNotEquals_3;
                    GeneratedTOBuilder genTOBuilder = this.addTOToTypeBuilder((TypeDefinition<? extends Object>)typeDef, typeBuilder, (DataSchemaNode)node, parentModule);
                    boolean bl6 = _tripleNotEquals_3 = genTOBuilder != null;
                    if (_tripleNotEquals_3) {
                        Type _createReturnTypeForUnion;
                        returnType = _createReturnTypeForUnion = this.createReturnTypeForUnion(genTOBuilder, (TypeDefinition<? extends Object>)typeDef, typeBuilder, parentModule);
                    }
                } else if (typeDef instanceof BitsTypeDefinition) {
                    GeneratedTOBuilder genTOBuilder_1 = this.addTOToTypeBuilder((TypeDefinition<? extends Object>)typeDef, typeBuilder, (DataSchemaNode)node, parentModule);
                    String _packageName_1 = genTOBuilder_1.getPackageName();
                    String _name_1 = genTOBuilder_1.getName();
                    ReferencedTypeImpl _referencedTypeImpl_1 = new ReferencedTypeImpl(_packageName_1, _name_1);
                    returnType = _referencedTypeImpl_1;
                } else {
                    Type _javaTypeForSchemaDefinitionType_1;
                    Restrictions restrictions = BindingGeneratorUtil.getRestrictions((TypeDefinition)typeDef);
                    returnType = _javaTypeForSchemaDefinitionType_1 = this.typeProvider.javaTypeForSchemaDefinitionType(typeDef, (SchemaNode)node, restrictions);
                }
                ParameterizedType listType = Types.listTypeFor((Type)returnType);
                String _localName = nodeName.getLocalName();
                this.constructGetter(typeBuilder, _localName, nodeDesc, (Type)listType);
                return true;
            }
        }
        return false;
    }

    private Type createReturnTypeForUnion(GeneratedTOBuilder genTOBuilder, TypeDefinition<? extends Object> typeDef, GeneratedTypeBuilder typeBuilder, Module parentModule) {
        GeneratedTOBuilderImpl _generatedTOBuilderImpl;
        ReferencedTypeImpl _referencedTypeImpl;
        String _packageName = genTOBuilder.getPackageName();
        String _name = genTOBuilder.getName();
        ReferencedTypeImpl returnType = _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
        genTOBuilder.setTypedef(true);
        genTOBuilder.setIsUnion(true);
        String _units = typeDef.getUnits();
        ((TypeProviderImpl)this.typeProvider).addUnitsToGenTO(genTOBuilder, _units);
        String _packageName_1 = typeBuilder.getPackageName();
        String _name_1 = genTOBuilder.getName();
        String _plus = _name_1 + "Builder";
        GeneratedTOBuilderImpl unionBuilder = _generatedTOBuilderImpl = new GeneratedTOBuilderImpl(_packageName_1, _plus);
        unionBuilder.setIsUnionBuilder(true);
        MethodSignatureBuilder method = unionBuilder.addMethod("getDefaultInstance");
        method.setReturnType((Type)returnType);
        method.addParameter((Type)Types.STRING, "defaultValue");
        method.setAccessModifier(AccessModifier.PUBLIC);
        method.setStatic(true);
        Map _additionalTypes = ((TypeProviderImpl)this.typeProvider).getAdditionalTypes();
        Set types = (Set)_additionalTypes.get(parentModule);
        boolean _equals = Objects.equal((Object)types, null);
        if (_equals) {
            Map _additionalTypes_1 = ((TypeProviderImpl)this.typeProvider).getAdditionalTypes();
            GeneratedTransferObject _instance = unionBuilder.toInstance();
            HashSet _newHashSet = Sets.newHashSet((Object[])new Type[]{_instance});
            _additionalTypes_1.put(parentModule, _newHashSet);
        } else {
            GeneratedTransferObject _instance_1 = unionBuilder.toInstance();
            types.add(_instance_1);
        }
        return returnType;
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(String packageName, SchemaNode schemaNode) {
        return this.addDefaultInterfaceDefinition(packageName, schemaNode, null);
    }

    private GeneratedTypeBuilder addDefaultInterfaceDefinition(String packageName, SchemaNode schemaNode, Type parent) {
        boolean _not;
        boolean _tripleEquals;
        GeneratedTypeBuilder it = this.addRawInterfaceDefinition(packageName, schemaNode, "");
        QName _qName = schemaNode.getQName();
        BindingGeneratorImpl.qnameConstant((GeneratedTypeBuilderBase<? extends Object>)it, "QNAME", _qName);
        boolean bl = _tripleEquals = parent == null;
        if (_tripleEquals) {
            it.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        } else {
            ParameterizedType _childOf = BindingTypes.childOf((Type)parent);
            it.addImplementsType((Type)_childOf);
        }
        boolean bl2 = _not = !(schemaNode instanceof GroupingDefinition);
        if (_not) {
            ParameterizedType _augmentable = BindingTypes.augmentable((Type)it);
            it.addImplementsType((Type)_augmentable);
        }
        if (schemaNode instanceof DataNodeContainer) {
            this.addImplementedInterfaceFromUses((DataNodeContainer)schemaNode, it);
        }
        return it;
    }

    private GeneratedTypeBuilder addRawInterfaceDefinition(String packageName, SchemaNode schemaNode) {
        return this.addRawInterfaceDefinition(packageName, schemaNode, "");
    }

    private GeneratedTypeBuilder addRawInterfaceDefinition(String packageName, SchemaNode schemaNode, String prefix) {
        boolean _not;
        GeneratedTypeBuilderImpl _generatedTypeBuilderImpl;
        boolean _tripleEquals;
        boolean _tripleNotEquals = schemaNode != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Data Schema Node cannot be NULL.");
        boolean _tripleNotEquals_1 = packageName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Package Name for Generated Type cannot be NULL.");
        QName _qName = schemaNode.getQName();
        boolean _tripleNotEquals_2 = _qName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_2, (Object)"QName for Data Schema Node cannot be NULL.");
        QName _qName_1 = schemaNode.getQName();
        String schemaNodeName = _qName_1.getLocalName();
        boolean _tripleNotEquals_3 = schemaNodeName != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_3, (Object)"Local Name of QName for Data Schema Node cannot be NULL.");
        String genTypeName = null;
        boolean bl = _tripleEquals = prefix == null;
        if (_tripleEquals) {
            String _className;
            genTypeName = _className = BindingMapping.getClassName((String)schemaNodeName);
        } else {
            String _plus;
            String _className_1 = BindingMapping.getClassName((String)schemaNodeName);
            genTypeName = _plus = prefix + _className_1;
        }
        GeneratedTypeBuilderImpl newType = _generatedTypeBuilderImpl = new GeneratedTypeBuilderImpl(packageName, genTypeName);
        boolean _containsKey = this.genTypeBuilders.containsKey(packageName);
        boolean bl2 = _not = !_containsKey;
        if (_not) {
            HashMap<String, GeneratedTypeBuilderImpl> _hashMap;
            HashMap<String, GeneratedTypeBuilderImpl> builders = _hashMap = new HashMap<String, GeneratedTypeBuilderImpl>();
            builders.put(genTypeName, newType);
            this.genTypeBuilders.put(packageName, builders);
        } else {
            boolean _not_1;
            Map<String, GeneratedTypeBuilder> builders_1 = this.genTypeBuilders.get(packageName);
            boolean _containsKey_1 = builders_1.containsKey(genTypeName);
            boolean bl3 = _not_1 = !_containsKey_1;
            if (_not_1) {
                builders_1.put(genTypeName, (GeneratedTypeBuilder)newType);
            }
        }
        return newType;
    }

    public static String getterMethodName(String localName, Type returnType) {
        StringBuilder _stringBuilder;
        StringBuilder method = _stringBuilder = new StringBuilder();
        boolean _equals = Types.BOOLEAN.equals(returnType);
        if (_equals) {
            method.append("is");
        } else {
            method.append("get");
        }
        String _propertyName = BindingMapping.getPropertyName((String)localName);
        String _firstUpper = StringExtensions.toFirstUpper((String)_propertyName);
        method.append(_firstUpper);
        return method.toString();
    }

    private MethodSignatureBuilder constructGetter(GeneratedTypeBuilder interfaceBuilder, String schemaNodeName, String comment, Type returnType) {
        String _terMethodName = BindingGeneratorImpl.getterMethodName(schemaNodeName, returnType);
        MethodSignatureBuilder getMethod = interfaceBuilder.addMethod(_terMethodName);
        getMethod.setComment(comment);
        getMethod.setReturnType(returnType);
        return getMethod;
    }

    private void addSchemaNodeToListBuilders(String basePackageName, DataSchemaNode schemaNode, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder, List<String> listKeys, Module module) {
        boolean _tripleNotEquals = schemaNode != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Data Schema Node cannot be NULL.");
        boolean _tripleNotEquals_1 = typeBuilder != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Generated Type Builder cannot be NULL.");
        if (schemaNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)schemaNode;
            QName _qName = leaf.getQName();
            String leafName = _qName.getLocalName();
            this.resolveLeafSchemaNodeAsMethod(typeBuilder, leaf);
            boolean _contains = listKeys.contains(leafName);
            if (_contains) {
                this.resolveLeafSchemaNodeAsProperty(genTOBuilder, leaf, true);
            }
        } else {
            boolean _not;
            boolean _isAddedByUses = schemaNode.isAddedByUses();
            boolean bl = _not = !_isAddedByUses;
            if (_not) {
                if (schemaNode instanceof LeafListSchemaNode) {
                    this.resolveLeafListSchemaNode(typeBuilder, (LeafListSchemaNode)schemaNode);
                } else if (schemaNode instanceof ContainerSchemaNode) {
                    this.containerToGenType(module, basePackageName, typeBuilder, typeBuilder, (ContainerSchemaNode)schemaNode);
                } else if (schemaNode instanceof ChoiceNode) {
                    this.choiceToGeneratedType(module, basePackageName, typeBuilder, (ChoiceNode)schemaNode);
                } else if (schemaNode instanceof ListSchemaNode) {
                    this.listToGenType(module, basePackageName, typeBuilder, typeBuilder, (ListSchemaNode)schemaNode);
                }
            }
        }
    }

    private void typeBuildersToGenTypes(Module module, GeneratedTypeBuilder typeBuilder, GeneratedTOBuilder genTOBuilder) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals = typeBuilder != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"Generated Type Builder cannot be NULL.");
        boolean bl = _tripleNotEquals_1 = genTOBuilder != null;
        if (_tripleNotEquals_1) {
            GeneratedTransferObject genTO = genTOBuilder.toInstance();
            this.constructGetter(typeBuilder, "key", "Returns Primary Key of Yang List Type", (Type)genTO);
            ModuleContext _get = this.genCtx.get(module);
            _get.addGeneratedTOBuilder(genTOBuilder);
        }
    }

    private List<String> listKeys(ListSchemaNode list) {
        boolean _tripleNotEquals;
        ArrayList<String> _arrayList;
        ArrayList<String> listKeys = _arrayList = new ArrayList<String>();
        List _keyDefinition = list.getKeyDefinition();
        boolean bl = _tripleNotEquals = _keyDefinition != null;
        if (_tripleNotEquals) {
            List keyDefinitions = list.getKeyDefinition();
            for (QName keyDefinition : keyDefinitions) {
                String _localName = keyDefinition.getLocalName();
                listKeys.add(_localName);
            }
        }
        return listKeys;
    }

    private GeneratedTOBuilder resolveListKeyTOBuilder(String packageName, ListSchemaNode list) {
        boolean _tripleNotEquals;
        GeneratedTOBuilderImpl genTOBuilder = null;
        boolean _and = false;
        List _keyDefinition = list.getKeyDefinition();
        boolean bl = _tripleNotEquals = _keyDefinition != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            List _keyDefinition_1 = list.getKeyDefinition();
            boolean _isEmpty = _keyDefinition_1.isEmpty();
            boolean _not = !_isEmpty;
            boolean bl2 = _and = _tripleNotEquals && _not;
        }
        if (_and) {
            GeneratedTOBuilderImpl _generatedTOBuilderImpl;
            QName _qName = list.getQName();
            String _localName = _qName.getLocalName();
            String listName = _localName + "Key";
            String genTOName = BindingMapping.getClassName((String)listName);
            genTOBuilder = _generatedTOBuilderImpl = new GeneratedTOBuilderImpl(packageName, genTOName);
        }
        return genTOBuilder;
    }

    private GeneratedTOBuilder addTOToTypeBuilder(TypeDefinition<? extends Object> typeDef, GeneratedTypeBuilder typeBuilder, DataSchemaNode leaf, Module parentModule) {
        boolean _tripleNotEquals;
        ArrayList<GeneratedTOBuilder> _arrayList;
        QName _qName = leaf.getQName();
        String classNameFromLeaf = BindingMapping.getClassName((QName)_qName);
        ArrayList<GeneratedTOBuilder> genTOBuilders = _arrayList = new ArrayList<GeneratedTOBuilder>();
        String packageName = typeBuilder.getFullyQualifiedName();
        if (typeDef instanceof UnionTypeDefinition) {
            boolean _not;
            List types = ((TypeProviderImpl)this.typeProvider).provideGeneratedTOBuildersForUnionTypeDef(packageName, (UnionTypeDefinition)typeDef, classNameFromLeaf, (SchemaNode)leaf);
            genTOBuilders.addAll(types);
            GeneratedTOBuilder resultTOBuilder = null;
            boolean _isEmpty = types.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                GeneratedTOBuilder _remove;
                resultTOBuilder = _remove = (GeneratedTOBuilder)types.remove(0);
                for (GeneratedTOBuilder genTOBuilder : types) {
                    resultTOBuilder.addEnclosingTransferObject(genTOBuilder);
                }
            }
            GeneratedPropertyBuilder genPropBuilder = resultTOBuilder.addProperty("value");
            Type _primitiveType = Types.primitiveType((String)"char[]", null);
            genPropBuilder.setReturnType(_primitiveType);
            resultTOBuilder.addEqualsIdentity(genPropBuilder);
            resultTOBuilder.addHashIdentity(genPropBuilder);
            resultTOBuilder.addToStringProperty(genPropBuilder);
        } else if (typeDef instanceof BitsTypeDefinition) {
            GeneratedTOBuilder _provideGeneratedTOBuilderForBitsTypeDefinition = ((TypeProviderImpl)this.typeProvider).provideGeneratedTOBuilderForBitsTypeDefinition(packageName, typeDef, classNameFromLeaf);
            genTOBuilders.add(_provideGeneratedTOBuilderForBitsTypeDefinition);
        }
        boolean _and = false;
        boolean bl = _tripleNotEquals = genTOBuilders != null;
        if (!_tripleNotEquals) {
            _and = false;
        } else {
            boolean _isEmpty_1 = genTOBuilders.isEmpty();
            boolean _not_1 = !_isEmpty_1;
            boolean bl2 = _and = _tripleNotEquals && _not_1;
        }
        if (_and) {
            for (GeneratedTOBuilder genTOBuilder_1 : genTOBuilders) {
                typeBuilder.addEnclosingTransferObject(genTOBuilder_1);
            }
            return (GeneratedTOBuilder)genTOBuilders.get(0);
        }
        return null;
    }

    private GeneratedTypeBuilder addImplementedInterfaceFromUses(DataNodeContainer dataNodeContainer, GeneratedTypeBuilder builder) {
        Set _uses = dataNodeContainer.getUses();
        for (UsesNode usesNode : _uses) {
            boolean _tripleEquals;
            SchemaPath _groupingPath = usesNode.getGroupingPath();
            boolean _tripleNotEquals = _groupingPath != null;
            if (!_tripleNotEquals) continue;
            SchemaPath _groupingPath_1 = usesNode.getGroupingPath();
            GeneratedTypeBuilder _findGroupingByPath = this.findGroupingByPath(_groupingPath_1);
            GeneratedType genType = _findGroupingByPath.toInstance();
            boolean bl = _tripleEquals = genType == null;
            if (_tripleEquals) {
                SchemaPath _groupingPath_2 = usesNode.getGroupingPath();
                String _plus = "Grouping " + _groupingPath_2;
                String _plus_1 = _plus + "is not resolved for ";
                String _name = builder.getName();
                String _plus_2 = _plus_1 + _name;
                IllegalStateException _illegalStateException = new IllegalStateException(_plus_2);
                throw _illegalStateException;
            }
            builder.addImplementsType((Type)genType);
        }
        return builder;
    }

    private GeneratedTypeBuilder findChildNodeByPath(SchemaPath path) {
        Collection<ModuleContext> _values = this.genCtx.values();
        for (ModuleContext ctx : _values) {
            GeneratedTypeBuilder result = ctx.getChildNode(path);
            boolean _tripleNotEquals = result != null;
            if (!_tripleNotEquals) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findGroupingByPath(SchemaPath path) {
        Collection<ModuleContext> _values = this.genCtx.values();
        for (ModuleContext ctx : _values) {
            GeneratedTypeBuilder result = ctx.getGrouping(path);
            boolean _tripleNotEquals = result != null;
            if (!_tripleNotEquals) continue;
            return result;
        }
        return null;
    }

    private GeneratedTypeBuilder findCaseByPath(SchemaPath path) {
        Collection<ModuleContext> _values = this.genCtx.values();
        for (ModuleContext ctx : _values) {
            GeneratedTypeBuilder result = ctx.getCase(path);
            boolean _tripleNotEquals = result != null;
            if (!_tripleNotEquals) continue;
            return result;
        }
        return null;
    }

    private Module getParentModule(SchemaNode node) {
        SchemaPath _path = node.getPath();
        List _path_1 = _path.getPath();
        QName qname = (QName)_path_1.get(0);
        URI namespace = qname.getNamespace();
        Date revision = qname.getRevision();
        return this.schemaContext.findModuleByNamespaceAndRevision(namespace, revision);
    }

    public Map<Module, ModuleContext> getModuleContexts() {
        return this.genCtx;
    }
}

