/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import java.lang.reflect.Field;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.BindingCodec;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.impl.codec.IdentityCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.InstanceIdentifierCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecMapping {
    private static final Logger LOG = LoggerFactory.getLogger(CodecMapping.class);
    public static final String INSTANCE_IDENTIFIER_CODEC = "INSTANCE_IDENTIFIER_CODEC";
    public static final String IDENTITYREF_CODEC = "IDENTITYREF_CODEC";
    public static final String CLASS_TO_CASE_MAP = "CLASS_TO_CASE";
    public static final String COMPOSITE_TO_CASE = "COMPOSITE_TO_CASE";
    public static final String AUGMENTATION_CODEC = "AUGMENTATION_CODEC";

    public static void setIdentifierCodec(Class<?> obj, InstanceIdentifierCodec codec) {
        try {
            Field instanceIdField = obj.getField(INSTANCE_IDENTIFIER_CODEC);
            if (obj != null) {
                instanceIdField.set(null, codec);
            }
        }
        catch (NoSuchFieldException e) {
            LOG.trace("Instance identifier codec is not needed for {}", (Object)obj.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Instance identifier could not be set for {}", (Object)obj.getName(), (Object)e);
        }
    }

    public static void setIdentityRefCodec(Class<?> obj, IdentityCodec<?> codec) {
        try {
            Field instanceIdField = obj.getField(IDENTITYREF_CODEC);
            if (obj != null) {
                instanceIdField.set(null, codec);
            }
        }
        catch (NoSuchFieldException e) {
            LOG.trace("Instance identifier codec is not needed for {}", (Object)obj.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Instance identifier could not be set for {}", (Object)obj.getName(), (Object)e);
        }
    }

    public static void setClassToCaseMap(Class<? extends BindingCodec<?, ?>> codec, Map<Class<?>, BindingCodec<?, ?>> classToCaseRawCodec) {
        try {
            Field instanceIdField = codec.getField(CLASS_TO_CASE_MAP);
            instanceIdField.set(null, classToCaseRawCodec);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("BUG: Class to case mappping is not needed for {}", (Object)codec.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Class to case mappping could not be set for {}", (Object)codec.getName(), (Object)e);
        }
    }

    public static void setCompositeNodeToCaseMap(Class<? extends BindingCodec<?, ?>> codec, Map<CompositeNode, BindingCodec<?, ?>> compositeToCase) {
        try {
            Field instanceIdField = codec.getField(COMPOSITE_TO_CASE);
            instanceIdField.set(null, compositeToCase);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("BUG: Class to case mappping is not needed for {}", (Object)codec.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Composite node to case mappping could not be set for {}", (Object)codec.getName(), (Object)e);
        }
    }

    public static void setAugmentationCodec(Class<? extends BindingCodec<?, ?>> dataCodec, BindingCodec<?, ?> augmentableCodec) {
        try {
            Field instanceIdField = dataCodec.getField(AUGMENTATION_CODEC);
            instanceIdField.set(null, augmentableCodec);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("BUG: Augmentation codec is not needed for {}", (Object)dataCodec.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Augmentation codec could not be set for {}", (Object)dataCodec.getName(), (Object)e);
        }
    }

    public static BindingCodec<?, ?> getAugmentationCodec(Class<? extends BindingCodec<?, ?>> dataCodec) {
        try {
            Field instanceIdField = dataCodec.getField(AUGMENTATION_CODEC);
            return (BindingCodec)instanceIdField.get(null);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("BUG: Augmentation codec is not needed for {}", (Object)dataCodec.getName(), (Object)e);
        }
        catch (IllegalAccessException | SecurityException e) {
            LOG.error("Augmentation codec could not be set for {}", (Object)dataCodec.getName(), (Object)e);
        }
        return null;
    }
}

