/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class ModuleContext {
    private GeneratedTypeBuilder moduleNode;
    private final List<GeneratedTOBuilder> genTOs = new ArrayList<GeneratedTOBuilder>();
    private final Map<SchemaPath, Type> typedefs = new HashMap<SchemaPath, Type>();
    private final Map<SchemaPath, GeneratedTypeBuilder> childNodes = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final Map<SchemaPath, GeneratedTypeBuilder> groupings = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final Map<SchemaPath, GeneratedTypeBuilder> cases = new HashMap<SchemaPath, GeneratedTypeBuilder>();
    private final Map<QName, GeneratedTOBuilder> identities = new HashMap<QName, GeneratedTOBuilder>();
    private final Set<GeneratedTypeBuilder> topLevelNodes = new HashSet<GeneratedTypeBuilder>();
    private final List<GeneratedTypeBuilder> augmentations = new ArrayList<GeneratedTypeBuilder>();
    private final Map<Type, AugmentationSchema> typeToAugmentation = new HashMap<Type, AugmentationSchema>();

    List<Type> getGeneratedTypes() {
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.moduleNode != null) {
            result.add((Type)this.moduleNode.toInstance());
        }
        for (GeneratedTOBuilder generatedTOBuilder : this.genTOs) {
            result.add((Type)generatedTOBuilder.toInstance());
        }
        for (Type type : this.typedefs.values()) {
            if (type == null) continue;
            result.add(type);
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.childNodes.values()) {
            result.add((Type)generatedTypeBuilder.toInstance());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.groupings.values()) {
            result.add((Type)generatedTypeBuilder.toInstance());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.cases.values()) {
            result.add((Type)generatedTypeBuilder.toInstance());
        }
        for (GeneratedTOBuilder generatedTOBuilder : this.identities.values()) {
            result.add((Type)generatedTOBuilder.toInstance());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.topLevelNodes) {
            result.add((Type)generatedTypeBuilder.toInstance());
        }
        for (GeneratedTypeBuilder generatedTypeBuilder : this.augmentations) {
            result.add((Type)generatedTypeBuilder.toInstance());
        }
        return result;
    }

    public GeneratedTypeBuilder getModuleNode() {
        return this.moduleNode;
    }

    public GeneratedTypeBuilder getChildNode(SchemaPath p) {
        return this.childNodes.get(p);
    }

    public GeneratedTypeBuilder getGrouping(SchemaPath p) {
        return this.groupings.get(p);
    }

    public GeneratedTypeBuilder getCase(SchemaPath p) {
        return this.cases.get(p);
    }

    public void addModuleNode(GeneratedTypeBuilder moduleNode) {
        this.moduleNode = moduleNode;
    }

    public void addGeneratedTOBuilder(GeneratedTOBuilder b) {
        this.genTOs.add(b);
    }

    public void addChildNodeType(SchemaPath p, GeneratedTypeBuilder b) {
        this.childNodes.put(p, b);
    }

    public void addGroupingType(SchemaPath p, GeneratedTypeBuilder b) {
        this.groupings.put(p, b);
    }

    public void addTypedefType(SchemaPath p, Type t) {
        this.typedefs.put(p, t);
    }

    public void addCaseType(SchemaPath p, GeneratedTypeBuilder b) {
        this.cases.put(p, b);
    }

    public void addIdentityType(QName name, GeneratedTOBuilder b) {
        this.identities.put(name, b);
    }

    public void addTopLevelNodeType(GeneratedTypeBuilder b) {
        this.topLevelNodes.add(b);
    }

    public void addAugmentType(GeneratedTypeBuilder b) {
        this.augmentations.add(b);
    }

    public Map<SchemaPath, Type> getTypedefs() {
        return this.typedefs;
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getChildNodes() {
        return this.childNodes;
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getGroupings() {
        return this.groupings;
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getCases() {
        return this.cases;
    }

    public Map<QName, GeneratedTOBuilder> getIdentities() {
        return this.identities;
    }

    public Set<GeneratedTypeBuilder> getTopLevelNodes() {
        return this.topLevelNodes;
    }

    public List<GeneratedTypeBuilder> getAugmentations() {
        return this.augmentations;
    }

    public Map<Type, AugmentationSchema> getTypeToAugmentation() {
        return this.typeToAugmentation;
    }

    public void addTypeToAugmentation(GeneratedTypeBuilder builder, AugmentationSchema schema) {
        this.typeToAugmentation.put((Type)builder, schema);
    }
}

