/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.sal.binding.generator.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.generator.impl.GeneratorListener;
import org.opendaylight.yangtools.sal.binding.generator.util.ClassGenerator;
import org.opendaylight.yangtools.sal.binding.generator.util.ClassLoaderUtils;
import org.opendaylight.yangtools.sal.binding.generator.util.CodeGenerationException;
import org.opendaylight.yangtools.sal.binding.generator.util.JavassistUtils;
import org.opendaylight.yangtools.sal.binding.generator.util.MethodGenerator;
import org.opendaylight.yangtools.sal.binding.generator.util.XtendHelper;
import org.opendaylight.yangtools.sal.binding.generator.util.YangSchemaUtils;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingCodec;
import org.opendaylight.yangtools.yang.binding.BindingDeserializer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.EnumerationType;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformerGenerator {
    private static final Logger log = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(TransformerGenerator.class);
            return _logger;
        }
    }.apply();
    public static final ConcreteType STRING = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(String.class);
            return _typeForClass;
        }
    }.apply();
    public static final ConcreteType BOOLEAN = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(Boolean.class);
            return _typeForClass;
        }
    }.apply();
    public static final ConcreteType INTEGER = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(Integer.class);
            return _typeForClass;
        }
    }.apply();
    public static final ConcreteType INSTANCE_IDENTIFIER = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(InstanceIdentifier.class);
            return _typeForClass;
        }
    }.apply();
    public static final ConcreteType LONG = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(Long.class);
            return _typeForClass;
        }
    }.apply();
    private final ClassPool classPool;
    @Extension
    private final JavassistUtils utils;
    private CtClass BINDING_CODEC;
    private CtClass ctQName;
    private File _classFileCapturePath;
    private Map<Type, Type> _typeDefinitions = new Functions.Function0<Map<Type, Type>>(){

        public Map<Type, Type> apply() {
            ConcurrentHashMap<Type, Type> _concurrentHashMap = new ConcurrentHashMap<Type, Type>();
            return _concurrentHashMap;
        }
    }.apply();
    private Map<Type, GeneratedTypeBuilder> _typeToDefinition = new Functions.Function0<Map<Type, GeneratedTypeBuilder>>(){

        public Map<Type, GeneratedTypeBuilder> apply() {
            ConcurrentHashMap<Type, GeneratedTypeBuilder> _concurrentHashMap = new ConcurrentHashMap<Type, GeneratedTypeBuilder>();
            return _concurrentHashMap;
        }
    }.apply();
    private Map<SchemaPath, GeneratedTypeBuilder> _pathToType = new Functions.Function0<Map<SchemaPath, GeneratedTypeBuilder>>(){

        public Map<SchemaPath, GeneratedTypeBuilder> apply() {
            ConcurrentHashMap<SchemaPath, GeneratedTypeBuilder> _concurrentHashMap = new ConcurrentHashMap<SchemaPath, GeneratedTypeBuilder>();
            return _concurrentHashMap;
        }
    }.apply();
    private Map<Type, SchemaNode> _typeToSchemaNode = new Functions.Function0<Map<Type, SchemaNode>>(){

        public Map<Type, SchemaNode> apply() {
            ConcurrentHashMap<Type, SchemaNode> _concurrentHashMap = new ConcurrentHashMap<Type, SchemaNode>();
            return _concurrentHashMap;
        }
    }.apply();
    private Map<Type, AugmentationSchema> _typeToAugmentation = new Functions.Function0<Map<Type, AugmentationSchema>>(){

        public Map<Type, AugmentationSchema> apply() {
            ConcurrentHashMap<Type, AugmentationSchema> _concurrentHashMap = new ConcurrentHashMap<Type, AugmentationSchema>();
            return _concurrentHashMap;
        }
    }.apply();
    private GeneratorListener _listener;
    public static final ConcreteType CLASS_TYPE = new Functions.Function0<ConcreteType>(){

        public ConcreteType apply() {
            ConcreteType _typeForClass = Types.typeForClass(Class.class);
            return _typeForClass;
        }
    }.apply();

    public File getClassFileCapturePath() {
        return this._classFileCapturePath;
    }

    public void setClassFileCapturePath(File classFileCapturePath) {
        this._classFileCapturePath = classFileCapturePath;
    }

    public Map<Type, Type> getTypeDefinitions() {
        return this._typeDefinitions;
    }

    public void setTypeDefinitions(Map<Type, Type> typeDefinitions) {
        this._typeDefinitions = typeDefinitions;
    }

    public Map<Type, GeneratedTypeBuilder> getTypeToDefinition() {
        return this._typeToDefinition;
    }

    public void setTypeToDefinition(Map<Type, GeneratedTypeBuilder> typeToDefinition) {
        this._typeToDefinition = typeToDefinition;
    }

    public Map<SchemaPath, GeneratedTypeBuilder> getPathToType() {
        return this._pathToType;
    }

    public void setPathToType(Map<SchemaPath, GeneratedTypeBuilder> pathToType) {
        this._pathToType = pathToType;
    }

    public Map<Type, SchemaNode> getTypeToSchemaNode() {
        return this._typeToSchemaNode;
    }

    public void setTypeToSchemaNode(Map<Type, SchemaNode> typeToSchemaNode) {
        this._typeToSchemaNode = typeToSchemaNode;
    }

    public Map<Type, AugmentationSchema> getTypeToAugmentation() {
        return this._typeToAugmentation;
    }

    public void setTypeToAugmentation(Map<Type, AugmentationSchema> typeToAugmentation) {
        this._typeToAugmentation = typeToAugmentation;
    }

    public GeneratorListener getListener() {
        return this._listener;
    }

    public void setListener(GeneratorListener listener) {
        this._listener = listener;
    }

    public TransformerGenerator(ClassPool pool) {
        CtClass _asCtClass_1;
        CtClass _asCtClass;
        JavassistUtils _javassistUtils;
        this.classPool = pool;
        this.utils = _javassistUtils = new JavassistUtils(pool);
        this.BINDING_CODEC = _asCtClass = this.utils.asCtClass(BindingCodec.class);
        this.ctQName = _asCtClass_1 = this.utils.asCtClass(QName.class);
    }

    public Class<? extends BindingCodec<Map<QName, Object>, Object>> transformerFor(final Class<? extends Object> inputType) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                    boolean _tripleNotEquals;
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        GeneratorListener _listener = TransformerGenerator.this.getListener();
                        _listener.onClassProcessed(inputType);
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)inputType);
                    Map<Type, SchemaNode> _typeToSchemaNode = TransformerGenerator.this.getTypeToSchemaNode();
                    SchemaNode node = _typeToSchemaNode.get(ref);
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    boolean _tripleNotEquals_1 = typeSpecBuilder != null;
                    String _name = inputType.getName();
                    Preconditions.checkState((boolean)_tripleNotEquals_1, (String)"Could not find typedefinition for %s", (Object[])new Object[]{_name});
                    GeneratedType typeSpec = typeSpecBuilder.toInstance();
                    Class newret = TransformerGenerator.this.generateTransformerFor(inputType, typeSpec, node);
                    GeneratorListener _listener_1 = TransformerGenerator.this.getListener();
                    _listener_1.onClassProcessed(inputType);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Class<? extends BindingCodec<Map<QName, Object>, Object>> transformerFor(final Class<? extends Object> inputType, final DataSchemaNode node) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                    Map<Type, SchemaNode> _typeToSchemaNode;
                    SchemaNode schemaNode;
                    boolean _tripleEquals;
                    boolean _tripleNotEquals;
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        GeneratorListener _listener = TransformerGenerator.this.getListener();
                        _listener.onClassProcessed(inputType);
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)inputType);
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    boolean _equals = Objects.equal((Object)typeSpecBuilder, null);
                    if (_equals) {
                        GeneratedTypeBuilder _get;
                        Map<SchemaPath, GeneratedTypeBuilder> _pathToType = TransformerGenerator.this.getPathToType();
                        SchemaPath _path = node.getPath();
                        typeSpecBuilder = _get = _pathToType.get(_path);
                    }
                    boolean bl2 = _tripleEquals = (schemaNode = (_typeToSchemaNode = TransformerGenerator.this.getTypeToSchemaNode()).get(ref)) == null;
                    if (_tripleEquals) {
                        schemaNode = node;
                    }
                    boolean _tripleNotEquals_1 = typeSpecBuilder != null;
                    String _name = inputType.getName();
                    Preconditions.checkState((boolean)_tripleNotEquals_1, (String)"Could not find TypeDefinition for %s, $s", (Object[])new Object[]{_name, node});
                    GeneratedType typeSpec = typeSpecBuilder.toInstance();
                    Class newret = TransformerGenerator.this.generateTransformerFor(inputType, typeSpec, schemaNode);
                    GeneratorListener _listener_1 = TransformerGenerator.this.getListener();
                    _listener_1.onClassProcessed(inputType);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Class<? extends BindingCodec<Map<QName, Object>, Object>> augmentationTransformerFor(final Class<? extends Object> inputType) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                    boolean _tripleNotEquals;
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)inputType);
                    Map<Type, AugmentationSchema> _typeToAugmentation = TransformerGenerator.this.getTypeToAugmentation();
                    AugmentationSchema node = _typeToAugmentation.get(ref);
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    GeneratedType typeSpec = typeSpecBuilder.toInstance();
                    Class newret = TransformerGenerator.this.generateAugmentationTransformerFor(inputType, typeSpec, node);
                    GeneratorListener _listener = TransformerGenerator.this.getListener();
                    _listener.onClassProcessed(inputType);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Class<? extends BindingCodec<Object, Object>> caseCodecFor(final Class<? extends Object> inputType, final ChoiceCaseNode node) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Object, Object>>> _function = new Callable<Class<? extends BindingCodec<Object, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Object, Object>> call() throws Exception {
                    boolean _tripleNotEquals;
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)inputType);
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    GeneratedType typeSpec = typeSpecBuilder.toInstance();
                    Class newret = TransformerGenerator.this.generateCaseCodec(inputType, typeSpec, node);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public Class<? extends BindingCodec<Map<QName, Object>, Object>> keyTransformerForIdentifiable(final Class<? extends Object> parentType) {
        try {
            ClassLoader _classLoader = parentType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                    boolean _tripleNotEquals;
                    String _name = parentType.getName();
                    String inputName = _name + "Key";
                    Class<?> inputType = ClassLoaderUtils.loadClassWithTCCL(inputName);
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)parentType);
                    Map<Type, SchemaNode> _typeToSchemaNode = TransformerGenerator.this.getTypeToSchemaNode();
                    SchemaNode _get = _typeToSchemaNode.get(ref);
                    ListSchemaNode node = (ListSchemaNode)_get;
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    GeneratedTransferObject typeSpec = TransformerGenerator.this.getIdentifierDefinition(typeSpecBuilder);
                    Class newret = TransformerGenerator.this.generateKeyTransformerFor(inputType, (GeneratedType)typeSpec, node);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public GeneratedTransferObject getIdentifierDefinition(GeneratedTypeBuilder builder) {
        GeneratedType inst = builder.toInstance();
        List _methodDefinitions = inst.getMethodDefinitions();
        Functions.Function1<MethodSignature, Boolean> _function = new Functions.Function1<MethodSignature, Boolean>(){

            public Boolean apply(MethodSignature it) {
                String _name = it.getName();
                boolean _equals = Objects.equal((Object)_name, (Object)"getKey");
                return _equals;
            }
        };
        MethodSignature keyMethod = (MethodSignature)IterableExtensions.findFirst((Iterable)_methodDefinitions, (Functions.Function1)_function);
        Type _returnType = keyMethod.getReturnType();
        return (GeneratedTransferObject)_returnType;
    }

    public Class<? extends BindingCodec<Map<QName, Object>, Object>> keyTransformerForIdentifier(final Class<? extends Object> inputType) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                @Override
                public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                    boolean _tripleNotEquals;
                    Class ret = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _tripleNotEquals = ret != null;
                    if (_tripleNotEquals) {
                        return ret;
                    }
                    ConcreteType ref = Types.typeForClass((Class)inputType);
                    Map<Type, SchemaNode> _typeToSchemaNode = TransformerGenerator.this.getTypeToSchemaNode();
                    SchemaNode _get = _typeToSchemaNode.get(ref);
                    ListSchemaNode node = (ListSchemaNode)_get;
                    Map<Type, GeneratedTypeBuilder> _typeToDefinition = TransformerGenerator.this.getTypeToDefinition();
                    GeneratedTypeBuilder typeSpecBuilder = _typeToDefinition.get(ref);
                    GeneratedType typeSpec = typeSpecBuilder.toInstance();
                    Class newret = TransformerGenerator.this.generateKeyTransformerFor(inputType, typeSpec, node);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Class<? extends Object> keyTransformerFor(final Class<? extends Object> inputType, final GeneratedType type, final ListSchemaNode schema) {
        try {
            ClassLoader _classLoader = inputType.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends Object>> _function = new Callable<Class<? extends Object>>(){

                @Override
                public Class<? extends Object> call() throws Exception {
                    boolean _notEquals;
                    Class transformer = TransformerGenerator.this.getGeneratedClass(inputType);
                    boolean bl = _notEquals = !Objects.equal((Object)transformer, null);
                    if (_notEquals) {
                        return transformer;
                    }
                    Class newret = TransformerGenerator.this.generateKeyTransformerFor(inputType, type, schema);
                    return newret;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Class<? extends Object> getGeneratedClass(Class<? extends Object> cls) {
        try {
            String _codecClassName = this.codecClassName(cls);
            return ClassLoaderUtils.loadClassWithTCCL(_codecClassName);
        }
        catch (Throwable _e) {
            try {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
            catch (Throwable _t) {
                if (_t instanceof ClassNotFoundException) {
                    ClassNotFoundException e = (ClassNotFoundException)_t;
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    private Class<? extends Object> keyTransformer(GeneratedType type, ListSchemaNode node) {
        try {
            Class<? extends Object> _keyTransformerFor;
            Class<? extends Object> _xblockexpression = null;
            String _resolvedName = this.getResolvedName((Type)type);
            String _plus = _resolvedName + "Key";
            Class<?> cls = ClassLoaderUtils.loadClassWithTCCL(_plus);
            _xblockexpression = _keyTransformerFor = this.keyTransformerFor(cls, type, node);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> serializer(Type type, DataSchemaNode node) {
        try {
            Class<? extends BindingCodec<Map<QName, Object>, Object>> _transformerFor;
            Class<? extends BindingCodec<Map<QName, Object>, Object>> _xblockexpression = null;
            String _resolvedName = this.getResolvedName(type);
            Class<?> cls = ClassLoaderUtils.loadClassWithTCCL(_resolvedName);
            _xblockexpression = _transformerFor = this.transformerFor(cls, node);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Class<? extends Object> valueSerializer(final GeneratedTransferObject type, TypeDefinition<? extends Object> typeDefinition) {
        try {
            boolean _notEquals;
            boolean _tripleNotEquals;
            String _resolvedName = this.getResolvedName((Type)type);
            final Class<?> cls = ClassLoaderUtils.loadClassWithTCCL(_resolvedName);
            Class<? extends Object> transformer = this.getGeneratedClass(cls);
            boolean bl = _tripleNotEquals = transformer != null;
            if (_tripleNotEquals) {
                return transformer;
            }
            TypeDefinition baseType = typeDefinition;
            TypeDefinition _baseType = baseType.getBaseType();
            boolean _while = _notEquals = !Objects.equal((Object)_baseType, null);
            while (_while) {
                boolean _notEquals_1;
                TypeDefinition _baseType_1 = baseType.getBaseType();
                TypeDefinition _baseType_2 = (baseType = _baseType_1).getBaseType();
                _while = _notEquals_1 = !Objects.equal((Object)_baseType_2, null);
            }
            final TypeDefinition finalType = baseType;
            try {
                ClassLoader _classLoader = cls.getClassLoader();
                Lock _lock = this.utils.getLock();
                Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>> _function = new Callable<Class<? extends BindingCodec<Map<QName, Object>, Object>>>(){

                    @Override
                    public Class<? extends BindingCodec<Map<QName, Object>, Object>> call() throws Exception {
                        Class valueTransformer = TransformerGenerator.this.generateValueTransformer(cls, type, (TypeDefinition<? extends Object>)finalType);
                        return valueTransformer;
                    }
                };
                return this.withClassLoaderAndLock(_classLoader, _lock, _function);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        catch (Throwable _e_1) {
            throw Exceptions.sneakyThrow((Throwable)_e_1);
        }
    }

    /*
     * Loose catch block
     */
    private Class<? extends Object> valueSerializer(final Enumeration type, TypeDefinition<? extends Object> typeDefinition) {
        Class<?> cls;
        block5: {
            boolean _tripleNotEquals;
            String _resolvedName = this.getResolvedName((Type)type);
            cls = ClassLoaderUtils.loadClassWithTCCL(_resolvedName);
            Class<? extends Object> transformer = this.getGeneratedClass(cls);
            boolean bl = _tripleNotEquals = transformer != null;
            if (!_tripleNotEquals) break block5;
            return transformer;
            {
                catch (Throwable _e_1) {
                    throw Exceptions.sneakyThrow((Throwable)_e_1);
                }
            }
        }
        try {
            ClassLoader _classLoader = cls.getClassLoader();
            Lock _lock = this.utils.getLock();
            Callable<Class<? extends Object>> _function = new Callable<Class<? extends Object>>(){

                @Override
                public Class<? extends Object> call() throws Exception {
                    Class valueTransformer = TransformerGenerator.this.generateValueTransformer(cls, type);
                    return valueTransformer;
                }
            };
            return this.withClassLoaderAndLock(_classLoader, _lock, _function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, ? extends Object>> generateKeyTransformerFor(final Class<? extends Object> inputType, GeneratedType typeSpec, final ListSchemaNode node) {
        try {
            final HashMap<String, Type> properties = this.getAllProperties(typeSpec);
            String _codecClassName = this.codecClassName(inputType);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    QName _qName = node.getQName();
                    TransformerGenerator.this.staticQNameField(it, _qName);
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _resultName;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 != null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_resultName = ");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "        ");
                            _builder.append((Object)".create($1,QNAME.getLocalName());");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"} else {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_resultName = QNAME;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName(inputType);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" value = (");
                            String _name_2 = inputType.getName();
                            _builder.append((Object)_name_2, "    ");
                            _builder.append((Object)") $2;");
                            _builder.newLineIfNotEmpty();
                            List _keyDefinition = node.getKeyDefinition();
                            for (QName key : _keyDefinition) {
                                _builder.append((Object)"    ");
                                String propertyName = TransformerGenerator.getGetterName(key);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                DataSchemaNode keyDef = node.getDataChildByName(key);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                Type property = (Type)properties.get(propertyName);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                CharSequence _serializeProperty = TransformerGenerator.this.serializeProperty(keyDef, property, propertyName);
                                _builder.append((Object)_serializeProperty, "    ");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return ($r) java.util.Collections.singletonMap(_resultName,_childNodes);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomStatic", QName.class, Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($2 == null){");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return  null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _localQName = $1;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"boolean _is_empty = true;");
                            _builder.newLine();
                            List _keyDefinition = node.getKeyDefinition();
                            for (QName key : _keyDefinition) {
                                _builder.append((Object)"    ");
                                String propertyName = TransformerGenerator.getGetterName(key);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                DataSchemaNode keyDef = node.getDataChildByName(key);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                Type property = (Type)properties.get(propertyName);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                CharSequence _deserializeProperty = TransformerGenerator.this.deserializeProperty(keyDef, property, propertyName);
                                _builder.append((Object)_deserializeProperty, "    ");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName(inputType);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _value = new ");
                            String _name_1 = inputType.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)"(");
                            List _keyDefinition_1 = node.getKeyDefinition();
                            String _keyConstructorList = TransformerGenerator.this.keyConstructorList(_keyDefinition_1);
                            _builder.append((Object)_keyConstructorList, "    ");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return _value;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomStatic", QName.class, Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map.Entry _input =  (java.util.Map.Entry) $1;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _localQName = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)") _input.getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            String _name_2 = inputType.getName();
                            _builder.append((Object)_name_2, "    ");
                            _builder.append((Object)" _keyValue = (");
                            String _name_3 = inputType.getName();
                            _builder.append((Object)_name_3, "    ");
                            _builder.append((Object)") _input.getValue();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomStatic(_localQName,_keyValue);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _qname = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 instanceof java.util.Map.Entry) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_qname = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "        ");
                            _builder.append((Object)") ((java.util.Map.Entry) $1).getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return fromDomStatic(_qname,$1);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.processException(inputType, e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Object, Object>> generateCaseCodec(Class<? extends Object> inputType, final GeneratedType type, final ChoiceCaseNode node) {
        try {
            Class<? extends Object> _classImpl;
            String _codecClassName = this.codecClassName(type);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    QName _qName = node.getQName();
                    TransformerGenerator.this.staticQNameField(it, _qName);
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "AUGMENTATION_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _resultName = ");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)".create($1,QNAME.getLocalName());");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)type);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" value = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)type);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $2;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            HashMap _allProperties = TransformerGenerator.this.getAllProperties(type);
                            String _transformDataContainerBody = TransformerGenerator.this.transformDataContainerBody((Type)type, _allProperties, (DataNodeContainer)node);
                            _builder.append((Object)_transformDataContainerBody, "    ");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return ($r) _childNodes;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomStatic", QName.class, Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map.Entry _input = (java.util.Map.Entry) $1;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _localName = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if(_input.getKey() != null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_localName = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "        ");
                            _builder.append((Object)") _input.getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomStatic(_localName,_input.getValue());");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            String _deserializeBody = TransformerGenerator.this.deserializeBody(type, (SchemaNode)node);
                            TransformerGenerator.this.setBodyChecked(it, _deserializeBody);
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomStatic", QName.class, Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"//System.out.println(\"");
                            String _name = type.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)"#deserialize: \" +$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map.Entry _input = (java.util.Map.Entry) $1;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return fromDomStatic((");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)")_input.getKey(),_input.getValue());");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = _classImpl = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            GeneratorListener _listener = this.getListener();
            if (_listener != null) {
                _listener.onDataContainerCodecCreated(inputType, ret);
            }
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.processException(inputType, e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> _generateTransformerFor(Class<? extends Object> inputType, final GeneratedType typeSpec, final SchemaNode node) {
        try {
            Class<? extends Object> _classImpl;
            String _codecClassName = this.codecClassName(typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    QName _qName = node.getQName();
                    TransformerGenerator.this.staticQNameField(it, _qName);
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "AUGMENTATION_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            String _serializeBodyFacade = TransformerGenerator.this.serializeBodyFacade(typeSpec, node);
                            TransformerGenerator.this.setBodyChecked(it, _serializeBodyFacade);
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomStatic", QName.class, Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map.Entry _input = (java.util.Map.Entry) $1;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _localName = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if(_input.getKey() != null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_localName = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "        ");
                            _builder.append((Object)") _input.getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomStatic(_localName,_input.getValue());");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            String _deserializeBody = TransformerGenerator.this.deserializeBody(typeSpec, node);
                            TransformerGenerator.this.setBodyChecked(it, _deserializeBody);
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomStatic", QName.class, Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _qname = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 instanceof java.util.Map.Entry) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"_qname = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "        ");
                            _builder.append((Object)") ((java.util.Map.Entry) $1).getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return fromDomStatic(_qname,$1);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = _classImpl = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            GeneratorListener _listener = this.getListener();
            if (_listener != null) {
                _listener.onDataContainerCodecCreated(inputType, ret);
            }
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.processException(inputType, e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> generateAugmentationTransformerFor(Class<? extends Object> inputType, final GeneratedType type, final AugmentationSchema node) {
        try {
            Class<? extends Object> _classImpl;
            final HashMap<String, Type> properties = this.getAllProperties(type);
            String _codecClassName = this.codecClassName(type);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    QName _augmentationQName = YangSchemaUtils.getAugmentationQName(node);
                    TransformerGenerator.this.staticQNameField(it, _augmentationQName);
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "AUGMENTATION_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"Qname \" + $1);");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"Value \" + $2);");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _resultName = ");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)".create(QNAME,QNAME.getLocalName());");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)type);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" value = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)type);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $2;");
                            _builder.newLineIfNotEmpty();
                            Set _childNodes = node.getChildNodes();
                            for (DataSchemaNode child : _childNodes) {
                                _builder.append((Object)"    ");
                                Map.Entry<String, Type> signature = TransformerGenerator.this.getFor(properties, child);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"////System.out.println(\"");
                                String _key = signature.getKey();
                                _builder.append((Object)_key, "    ");
                                _builder.append((Object)"\" + value.");
                                String _key_1 = signature.getKey();
                                _builder.append((Object)_key_1, "    ");
                                _builder.append((Object)"());");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                Type _value = signature.getValue();
                                String _key_2 = signature.getKey();
                                CharSequence _serializeProperty = TransformerGenerator.this.serializeProperty(child, _value, _key_2);
                                _builder.append((Object)_serializeProperty, "    ");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return ($r) _childNodes;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomStatic", QName.class, Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"java.util.Map.Entry _input = (java.util.Map.Entry) $1;");
                            _builder.newLine();
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "");
                            _builder.append((Object)" _localName = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"if(_input.getKey() != null) {");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"_localName = (");
                            String _name_1 = QName.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)") _input.getKey();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"return toDomStatic(_localName,_input.getValue());");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = QName.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _localQName = QNAME;");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($2 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"//System.out.println(_localQName + \" \" + _compositeNode);");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            CharSequence _builderName = TransformerGenerator.this.getBuilderName(type);
                            _builder.append((Object)_builderName, "    ");
                            _builder.append((Object)" _builder = new ");
                            CharSequence _builderName_1 = TransformerGenerator.this.getBuilderName(type);
                            _builder.append((Object)_builderName_1, "    ");
                            _builder.append((Object)"();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"boolean _is_empty = true;");
                            _builder.newLine();
                            Set _childNodes = node.getChildNodes();
                            for (DataSchemaNode child : _childNodes) {
                                _builder.append((Object)"    ");
                                Map.Entry<String, Type> signature = TransformerGenerator.this.getFor(properties, child);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                Type _value = signature.getValue();
                                String _key = signature.getKey();
                                CharSequence _deserializeProperty = TransformerGenerator.this.deserializeProperty(child, _value, _key);
                                _builder.append((Object)_deserializeProperty, "    ");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"_builder.");
                                String _key_1 = signature.getKey();
                                String _setter = TransformerGenerator.toSetter(_key_1);
                                _builder.append((Object)_setter, "    ");
                                _builder.append((Object)"(");
                                String _key_2 = signature.getKey();
                                _builder.append((Object)_key_2, "    ");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if(_is_empty) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return _builder.build();");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomStatic", QName.class, Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"return fromDomStatic(QNAME,$1);");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = _classImpl = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            GeneratorListener _listener = this.getListener();
            if (_listener != null) {
                _listener.onDataContainerCodecCreated(inputType, ret);
            }
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.processException(inputType, e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> _generateTransformerFor(Class<? extends Object> inputType, final GeneratedType typeSpec, ChoiceNode node) {
        try {
            Class<? extends Object> rawRet;
            String _codecClassName = this.codecClassName(typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "CLASS_TO_CASE", Map.class);
                    TransformerGenerator.this.utils.staticField(it, "COMPOSITE_TO_CASE", Map.class);
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($2 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = DataObject.class.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _baValue = (");
                            String _name_1 = DataObject.class.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)") $2;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"Class _baClass = _baValue.getImplementedInterface();");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name_2 = TransformerGenerator.this.BINDING_CODEC.getName();
                            _builder.append((Object)_name_2, "    ");
                            _builder.append((Object)" _codec =  ");
                            _builder.append((Object)"CLASS_TO_CASE", "    ");
                            _builder.append((Object)".get(_baClass);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if(_codec == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"java.util.Map.Entry _input = new ");
                            String _name_3 = AbstractMap.SimpleEntry.class.getName();
                            _builder.append((Object)_name_3, "    ");
                            _builder.append((Object)"($1,_baValue);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"Object _ret =  _codec.serialize(_input);");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _name_4 = typeSpec.getName();
                            _builder.append((Object)_name_4, "    ");
                            _builder.append((Object)"#toDomStatic: \" + _ret);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return (");
                            String _name_5 = List.class.getName();
                            _builder.append((Object)_name_5, "    ");
                            _builder.append((Object)") _ret;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, List.class, "toDomStatic", QName.class, Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"throw new ");
                            String _name = UnsupportedOperationException.class.getName();
                            _builder.append((Object)_name, "");
                            _builder.append((Object)"(\"Direct invocation not supported.\");");
                            _builder.newLineIfNotEmpty();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _name = TransformerGenerator.this.BINDING_CODEC.getName();
                            _builder.append((Object)_name, "    ");
                            _builder.append((Object)" _codec = (");
                            String _name_1 = TransformerGenerator.this.BINDING_CODEC.getName();
                            _builder.append((Object)_name_1, "    ");
                            _builder.append((Object)") ");
                            _builder.append((Object)"COMPOSITE_TO_CASE", "    ");
                            _builder.append((Object)".get($2);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if(_codec != null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return _codec.deserialize(new ");
                            String _name_2 = AbstractMap.SimpleEntry.class.getName();
                            _builder.append((Object)_name_2, "        ");
                            _builder.append((Object)"($1,$2));");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomStatic", QName.class, Map.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"throw new ");
                            String _name = UnsupportedOperationException.class.getName();
                            _builder.append((Object)_name, "");
                            _builder.append((Object)"(\"Direct invocation not supported.\");");
                            _builder.newLineIfNotEmpty();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = rawRet = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            GeneratorListener _listener = this.getListener();
            if (_listener != null) {
                _listener.onChoiceCodecCreated(inputType, ret, node);
            }
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.processException(inputType, e);
                return null;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private String keyConstructorList(List<QName> qnames) {
        TreeSet<String> _treeSet;
        TreeSet<String> names = _treeSet = new TreeSet<String>();
        for (QName name : qnames) {
            String fieldName = TransformerGenerator.getGetterName(name);
            names.add(fieldName);
        }
        Joiner _on = Joiner.on((String)",");
        return _on.join(names);
    }

    private String serializeBodyFacade(GeneratedType type, SchemaNode node) {
        String ret = this.serializeBody(type, node);
        return ret;
    }

    private String deserializeBody(GeneratedType type, SchemaNode node) {
        String ret = this.deserializeBodyImpl(type, node);
        return ret;
    }

    private String deserializeKey(GeneratedType type, ListSchemaNode node) {
        boolean _notEquals;
        String _xifexpression = null;
        boolean _and = false;
        List _keyDefinition = node.getKeyDefinition();
        boolean bl = _notEquals = !Objects.equal((Object)_keyDefinition, null);
        if (!_notEquals) {
            _and = false;
        } else {
            List _keyDefinition_1 = node.getKeyDefinition();
            boolean _isEmpty = _keyDefinition_1.isEmpty();
            boolean _not = !_isEmpty;
            boolean bl2 = _and = _notEquals && _not;
        }
        if (_and) {
            StringConcatenation _builder = new StringConcatenation();
            String _resolvedName = this.getResolvedName((Type)type);
            _builder.append((Object)_resolvedName, "");
            _builder.append((Object)"Key getKey = (");
            String _resolvedName_1 = this.getResolvedName((Type)type);
            _builder.append((Object)_resolvedName_1, "");
            _builder.append((Object)"Key) ");
            Class<? extends Object> _keyTransformer = this.keyTransformer(type, node);
            String _canonicalName = _keyTransformer.getCanonicalName();
            _builder.append((Object)_canonicalName, "");
            _builder.append((Object)".fromDomStatic(_localQName,_compositeNode);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"_builder.setKey(getKey);");
            _builder.newLine();
            return _builder.toString();
        }
        return _xifexpression;
    }

    private String _deserializeBodyImpl(GeneratedType type, SchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _localQName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if($2 == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _builderName = this.getBuilderName(type);
        _builder.append((Object)_builderName, "    ");
        _builder.append((Object)" _builder = new ");
        CharSequence _builderName_1 = this.getBuilderName(type);
        _builder.append((Object)_builderName_1, "    ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return _builder.build();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _deserializeBodyImpl(GeneratedType type, ListSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _localQName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"if($2 == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"//System.out.println(_localQName + \" \" + _compositeNode);");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _builderName = this.getBuilderName(type);
        _builder.append((Object)_builderName, "    ");
        _builder.append((Object)" _builder = new ");
        CharSequence _builderName_1 = this.getBuilderName(type);
        _builder.append((Object)_builderName_1, "    ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _deserializeKey = this.deserializeKey(type, node);
        _builder.append((Object)_deserializeKey, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _deserializeDataNodeContainerBody = this.deserializeDataNodeContainerBody(type, (DataNodeContainer)node);
        _builder.append((Object)_deserializeDataNodeContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _deserializeAugmentations = this.deserializeAugmentations();
        _builder.append((Object)_deserializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return _builder.build();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _deserializeBodyImpl(GeneratedType type, ContainerSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _localQName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"if($2 == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"//System.out.println(_localQName + \" \" + _compositeNode);");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _builderName = this.getBuilderName(type);
        _builder.append((Object)_builderName, "    ");
        _builder.append((Object)" _builder = new ");
        CharSequence _builderName_1 = this.getBuilderName(type);
        _builder.append((Object)_builderName_1, "    ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _deserializeDataNodeContainerBody = this.deserializeDataNodeContainerBody(type, (DataNodeContainer)node);
        _builder.append((Object)_deserializeDataNodeContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _deserializeAugmentations = this.deserializeAugmentations();
        _builder.append((Object)_deserializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return _builder.build();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _deserializeBodyImpl(GeneratedType type, ChoiceCaseNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _localQName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"if($2 == null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map _compositeNode = (java.util.Map) $2;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"//System.out.println(_localQName + \" \" + _compositeNode);");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _builderName = this.getBuilderName(type);
        _builder.append((Object)_builderName, "    ");
        _builder.append((Object)" _builder = new ");
        CharSequence _builderName_1 = this.getBuilderName(type);
        _builder.append((Object)_builderName_1, "    ");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _deserializeDataNodeContainerBody = this.deserializeDataNodeContainerBody(type, (DataNodeContainer)node);
        _builder.append((Object)_deserializeDataNodeContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _deserializeAugmentations = this.deserializeAugmentations();
        _builder.append((Object)_deserializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return _builder.build();");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String deserializeDataNodeContainerBody(GeneratedType type, DataNodeContainer node) {
        HashMap<String, Type> _allProperties = this.getAllProperties(type);
        String _deserializeNodeContainerBodyImpl = this.deserializeNodeContainerBodyImpl(type, _allProperties, node);
        return _deserializeNodeContainerBodyImpl;
    }

    private String deserializeNodeContainerBodyImpl(GeneratedType type, HashMap<String, Type> properties, DataNodeContainer node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"boolean _is_empty = true;");
        _builder.newLine();
        Set _childNodes = node.getChildNodes();
        for (DataSchemaNode child : _childNodes) {
            Map.Entry<String, Type> signature = this.getFor(properties, child);
            _builder.newLineIfNotEmpty();
            boolean _tripleNotEquals = signature != null;
            if (!_tripleNotEquals) continue;
            Type _value = signature.getValue();
            String _key = signature.getKey();
            CharSequence _deserializeProperty = this.deserializeProperty(child, _value, _key);
            _builder.append((Object)_deserializeProperty, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"_builder.");
            String _key_1 = signature.getKey();
            String _setter = TransformerGenerator.toSetter(_key_1);
            _builder.append((Object)_setter, "");
            _builder.append((Object)"(");
            String _key_2 = signature.getKey();
            _builder.append((Object)_key_2, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        String ret = _builder.toString();
        return ret;
    }

    public CharSequence deserializeAugmentations() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.Map _augmentation = (java.util.Map) ");
        _builder.append((Object)"AUGMENTATION_CODEC", "");
        _builder.append((Object)".deserialize(_compositeNode);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_augmentation != null) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = Iterator.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _entries = _augmentation.entrySet().iterator();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"while(_entries.hasNext()) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"java.util.Map.Entry _entry = (java.util.Map.Entry) _entries.next();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"////System.out.println(\"Aug. key:\" + _entry.getKey());");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Class _type = (Class) _entry.getKey();");
        _builder.newLine();
        _builder.append((Object)"        ");
        String _resolvedName = this.getResolvedName(Augmentation.class);
        _builder.append((Object)_resolvedName, "        ");
        _builder.append((Object)" _value = (");
        String _name_1 = Augmentation.class.getName();
        _builder.append((Object)_name_1, "        ");
        _builder.append((Object)") _entry.getValue();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"if(_value != null) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"_builder.addAugmentation(_type,_value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _deserializeProperty(ListSchemaNode schema, ParameterizedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = _compositeNode.get(");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".create(_localQName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"////System.out.println(\"");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"#deCode\"+_dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"java.util.List ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = new java.util.ArrayList();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _serialized = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Iterator _iterator = _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)".iterator();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"boolean _hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while(_hasNext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _listItem = _iterator.next();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_is_empty = false;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"////System.out.println(\"  item\" + _listItem);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _value = ");
        Type[] _actualTypeArguments = type.getActualTypeArguments();
        Type _get = _actualTypeArguments[0];
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer(_get, (DataSchemaNode)schema);
        String _resolvedName = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName, "        ");
        _builder.append((Object)".fromDomStatic(_localQName,_listItem);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"////System.out.println(\"  value\" + _value);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)propertyName, "        ");
        _builder.append((Object)".add(_value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"_hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"////System.out.println(\" list\" + ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _deserializeProperty(LeafListSchemaNode schema, ParameterizedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = _compositeNode.get(");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".create(_localQName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"java.util.List ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = new java.util.ArrayList();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _serialized = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Iterator _iterator = _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)".iterator();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"boolean _hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while(_hasNext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_is_empty = false;");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _listItem = _iterator.next();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"if(_listItem instanceof java.util.Map.Entry) {");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Object _innerValue = ((java.util.Map.Entry) _listItem).getValue();");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"Object _value = ");
        Type[] _actualTypeArguments = type.getActualTypeArguments();
        Type _get = _actualTypeArguments[0];
        TypeDefinition _type = schema.getType();
        String _deserializeValue = this.deserializeValue(_get, "_innerValue", (TypeDefinition<? extends Object>)_type);
        _builder.append((Object)_deserializeValue, "            ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"            ");
        _builder.append((Object)propertyName, "            ");
        _builder.append((Object)".add(_value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _deserializeProperty(LeafSchemaNode schema, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list =");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_compositeNode.get(");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)".create(_localQName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "    ");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list != null && _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list.size() > 0) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_is_empty = false;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map.Entry _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)" = (java.util.Map.Entry) _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)"_list.get(0);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"Object _inner_value = _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)".getValue();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)" = ");
        TypeDefinition _type = schema.getType();
        String _deserializeValue = this.deserializeValue(type, "_inner_value", (TypeDefinition<? extends Object>)_type);
        _builder.append((Object)_deserializeValue, "    ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _deserializeProperty(ContainerSchemaNode schema, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list =");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_compositeNode.get(");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)".create(_localQName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "    ");
        _builder.append((Object)"\"));");
        _builder.newLineIfNotEmpty();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = null;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list != null && _dom_");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"_list.size() > 0) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_is_empty = false;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Map _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)" = (java.util.Map) _dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)"_list.get(0);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)" =  ");
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer(type, (DataSchemaNode)schema);
        String _resolvedName_1 = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)".fromDomStatic(_localQName,_dom_");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _deserializeProperty(ChoiceNode schema, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = ");
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer(type, (DataSchemaNode)schema);
        String _resolvedName_1 = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName_1, "");
        _builder.append((Object)".fromDomStatic(_localQName,_compositeNode);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_is_empty = false;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String _deserializeValue(GeneratedTransferObject type, String domParameter, TypeDefinition<? extends Object> typeDefinition) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)") ");
        Class<? extends Object> _valueSerializer = this.valueSerializer(type, typeDefinition);
        String _resolvedName_1 = this.getResolvedName(_valueSerializer);
        _builder.append((Object)_resolvedName_1, "");
        _builder.append((Object)".fromDomValue(");
        _builder.append((Object)domParameter, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String _deserializeValue(Enumeration type, String domParameter, TypeDefinition<? extends Object> typeDefinition) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"(");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)") ");
        Class<? extends Object> _valueSerializer = this.valueSerializer(type, typeDefinition);
        String _resolvedName_1 = this.getResolvedName(_valueSerializer);
        _builder.append((Object)_resolvedName_1, "");
        _builder.append((Object)".fromDomValue(");
        _builder.append((Object)domParameter, "");
        _builder.append((Object)")");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> _generateValueTransformer(final Class<? extends Object> inputType, final GeneratedTransferObject typeSpec, TypeDefinition<? extends Object> typeDef) {
        try {
            final Type returnType = this.getValueReturnType(typeSpec);
            boolean _equals = Objects.equal((Object)returnType, null);
            if (_equals) {
                CtClass ctCls = this.createDummyImplementation(inputType, typeSpec);
                ClassLoader _classLoader = inputType.getClassLoader();
                ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
                Class<? extends Object> ret = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
                return ret;
            }
            String _codecClassName = this.codecClassName((GeneratedType)typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    boolean _isYangBindingAvailable = TransformerGenerator.this.isYangBindingAvailable(inputType);
                    if (_isYangBindingAvailable) {
                        TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                        TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                        TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                        CtClass _asCtClass = TransformerGenerator.this.utils.asCtClass(BindingDeserializer.class);
                        TransformerGenerator.this.utils.implementsType(it, _asCtClass);
                    }
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            CtClass ctSpec = TransformerGenerator.this.asCtClass((Type)typeSpec);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#toDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _encapsulatedValue = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $1;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName_1 = inputType.getSimpleName();
                            _builder.append((Object)_simpleName_1, "    ");
                            _builder.append((Object)"#toDomValue:Enc: \"+_encapsulatedValue);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            String _resolvedName_2 = TransformerGenerator.this.getResolvedName(returnType);
                            _builder.append((Object)_resolvedName_2, "    ");
                            _builder.append((Object)" _value =  _encapsulatedValue.getValue();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName_2 = inputType.getSimpleName();
                            _builder.append((Object)_simpleName_2, "    ");
                            _builder.append((Object)"#toDomValue:DeEnc: \"+_value);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"Object _domValue = ");
                            CharSequence _serializeValue = TransformerGenerator.this.serializeValue(returnType, "_value", (TypeDefinition<? extends Object>)null);
                            _builder.append((Object)_serializeValue, "    ");
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return _domValue;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomValue", Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#fromDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName(returnType);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _simpleValue = ");
                            String _deserializeValue = TransformerGenerator.this.deserializeValue(returnType, "$1", (TypeDefinition<? extends Object>)null);
                            _builder.append((Object)_deserializeValue, "    ");
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)" _value = new ");
                            String _resolvedName_2 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_2, "    ");
                            _builder.append((Object)"(_simpleValue);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return _value;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomValue", Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"return fromDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"                    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls_1 = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader_1 = inputType.getClassLoader();
            ProtectionDomain _protectionDomain_1 = inputType.getProtectionDomain();
            Class<? extends Object> ret_1 = this.toClassImpl(ctCls_1, _classLoader_1, _protectionDomain_1);
            log.debug("DOM Codec for {} was generated {}", inputType, ret_1);
            return ret_1;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                CodeGenerationException _codeGenerationException;
                Exception e = (Exception)_t;
                log.error("Cannot compile DOM Codec for {}", inputType, (Object)e);
                String _plus = "Cannot compile Transformator for " + inputType;
                CodeGenerationException exception = _codeGenerationException = new CodeGenerationException(_plus);
                exception.addSuppressed(e);
                throw exception;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> _generateValueTransformer(final Class<? extends Object> inputType, final GeneratedTransferObject typeSpec, final UnionTypeDefinition typeDef) {
        try {
            String _codecClassName = this.codecClassName((GeneratedType)typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    final HashMap properties = TransformerGenerator.this.getAllProperties((GeneratedType)typeSpec);
                    Iterable<TypeDefinition> _types = XtendHelper.getTypes(typeDef);
                    Functions.Function1<TypeDefinition, String> _function = new Functions.Function1<TypeDefinition, String>(){

                        public String apply(TypeDefinition type) {
                            QName _qName = type.getQName();
                            String _getterName = TransformerGenerator.getGetterName(_qName);
                            return _getterName;
                        }
                    };
                    final Map getterToTypeDefinition = IterableExtensions.toMap(_types, (Functions.Function1)_function);
                    boolean _isYangBindingAvailable = TransformerGenerator.this.isYangBindingAvailable(inputType);
                    if (_isYangBindingAvailable) {
                        TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                        TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                        TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                        CtClass _asCtClass = TransformerGenerator.this.utils.asCtClass(BindingDeserializer.class);
                        TransformerGenerator.this.utils.implementsType(it, _asCtClass);
                    }
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            CtClass ctSpec = TransformerGenerator.this.utils.asCtClass(inputType);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#toDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _value = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $1;");
                            _builder.newLineIfNotEmpty();
                            Set _entrySet = properties.entrySet();
                            for (Map.Entry property : _entrySet) {
                                String _key = (String)property.getKey();
                                boolean _notEquals = !Objects.equal((Object)_key, (Object)"getValue");
                                if (!_notEquals) continue;
                                _builder.append((Object)"    ");
                                Type _value = (Type)property.getValue();
                                String _resolvedName_2 = TransformerGenerator.this.getResolvedName(_value);
                                _builder.append((Object)_resolvedName_2, "    ");
                                _builder.append((Object)" ");
                                String _key_1 = (String)property.getKey();
                                _builder.append((Object)_key_1, "    ");
                                _builder.append((Object)" = (");
                                Type _value_1 = (Type)property.getValue();
                                String _resolvedName_3 = TransformerGenerator.this.getResolvedName(_value_1);
                                _builder.append((Object)_resolvedName_3, "    ");
                                _builder.append((Object)") _value.");
                                String _key_2 = (String)property.getKey();
                                _builder.append((Object)_key_2, "    ");
                                _builder.append((Object)"();");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"if(");
                                String _key_3 = (String)property.getKey();
                                _builder.append((Object)_key_3, "    ");
                                _builder.append((Object)" != null) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"    ");
                                _builder.append((Object)"return ");
                                Type _value_2 = (Type)property.getValue();
                                String _key_4 = (String)property.getKey();
                                String _key_5 = (String)property.getKey();
                                TypeDefinition _get = (TypeDefinition)getterToTypeDefinition.get(_key_5);
                                CharSequence _serializeValue = TransformerGenerator.this.serializeValue(_value_2, _key_4, (TypeDefinition<? extends Object>)_get);
                                _builder.append((Object)_serializeValue, "        ");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                            }
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomValue", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#fromDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 instanceof String) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"String _simpleValue = (String) $1;");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return new ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName, "        ");
                            _builder.append((Object)"(_simpleValue.toCharArray());");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomValue", Object.class, _function_3);
                    MethodGenerator _function_4 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"return fromDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"                    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_4);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                CodeGenerationException _codeGenerationException;
                Exception e = (Exception)_t;
                log.error("Cannot compile DOM Codec for {}", inputType, (Object)e);
                String _plus = "Cannot compile Transformator for " + inputType;
                CodeGenerationException exception = _codeGenerationException = new CodeGenerationException(_plus);
                exception.addSuppressed(e);
                throw exception;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> _generateValueTransformer(final Class<? extends Object> inputType, final GeneratedTransferObject typeSpec, final BitsTypeDefinition typeDef) {
        try {
            String _codecClassName = this.codecClassName((GeneratedType)typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    boolean _isYangBindingAvailable = TransformerGenerator.this.isYangBindingAvailable(inputType);
                    if (_isYangBindingAvailable) {
                        TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                        TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                        TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                        CtClass _asCtClass = TransformerGenerator.this.utils.asCtClass(BindingDeserializer.class);
                        TransformerGenerator.this.utils.implementsType(it, _asCtClass);
                    }
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            CtClass ctSpec = TransformerGenerator.this.asCtClass((Type)typeSpec);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"////System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#toDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _encapsulatedValue = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $1;");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            String _resolvedName_2 = TransformerGenerator.this.getResolvedName(HashSet.class);
                            _builder.append((Object)_resolvedName_2, "    ");
                            _builder.append((Object)" _value = new ");
                            String _resolvedName_3 = TransformerGenerator.this.getResolvedName(HashSet.class);
                            _builder.append((Object)_resolvedName_3, "    ");
                            _builder.append((Object)"();");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"//System.out.println(\"");
                            String _simpleName_1 = inputType.getSimpleName();
                            _builder.append((Object)_simpleName_1, "    ");
                            _builder.append((Object)"#toDomValue:Enc: \"+_encapsulatedValue);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            List _bits = typeDef.getBits();
                            for (BitsTypeDefinition.Bit bit : _bits) {
                                _builder.append((Object)"    ");
                                String getter = TransformerGenerator.this.getterName(bit);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"if(Boolean.TRUE.equals(_encapsulatedValue.");
                                _builder.append((Object)getter, "    ");
                                _builder.append((Object)"())) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"    ");
                                _builder.append((Object)"_value.add(\"");
                                String _name = bit.getName();
                                _builder.append((Object)_name, "        ");
                                _builder.append((Object)"\");");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                            }
                            _builder.append((Object)"    ");
                            String _resolvedName_4 = TransformerGenerator.this.getResolvedName(Set.class);
                            _builder.append((Object)_resolvedName_4, "    ");
                            _builder.append((Object)" _domValue =  ");
                            String _resolvedName_5 = TransformerGenerator.this.getResolvedName(Collections.class);
                            _builder.append((Object)_resolvedName_5, "    ");
                            _builder.append((Object)".unmodifiableSet(_value);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"//System.out.println(\"");
                            String _simpleName_2 = inputType.getSimpleName();
                            _builder.append((Object)_simpleName_2, "    ");
                            _builder.append((Object)"#toDomValue:DeEnc: \"+_domValue);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return _domValue;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomValue", Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return toDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            List _bits = typeDef.getBits();
                            Comparator<BitsTypeDefinition.Bit> _function = new Comparator<BitsTypeDefinition.Bit>(){

                                @Override
                                public int compare(BitsTypeDefinition.Bit o1, BitsTypeDefinition.Bit o2) {
                                    String _propertyName = TransformerGenerator.this.getPropertyName(o1);
                                    String _propertyName_1 = TransformerGenerator.this.getPropertyName(o2);
                                    int _compareTo = _propertyName.compareTo(_propertyName_1);
                                    return _compareTo;
                                }
                            };
                            List sortedBits = IterableExtensions.sort((Iterable)_bits, (Comparator)_function);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"//System.out.println(\"");
                            String _simpleName = inputType.getSimpleName();
                            _builder.append((Object)_simpleName, "    ");
                            _builder.append((Object)"#fromDomValue: \"+$1);");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName(Set.class);
                            _builder.append((Object)_resolvedName, "    ");
                            _builder.append((Object)" _domValue = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName(Set.class);
                            _builder.append((Object)_resolvedName_1, "    ");
                            _builder.append((Object)") $1;");
                            _builder.newLineIfNotEmpty();
                            for (BitsTypeDefinition.Bit bit : sortedBits) {
                                _builder.append((Object)"    ");
                                _builder.append((Object)"Boolean ");
                                String _propertyName = TransformerGenerator.this.getPropertyName(bit);
                                _builder.append((Object)_propertyName, "    ");
                                _builder.append((Object)" = Boolean.valueOf(_domValue.contains(\"");
                                String _name = bit.getName();
                                _builder.append((Object)_name, "    ");
                                _builder.append((Object)"\"));");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return new ");
                            String _resolvedName_2 = TransformerGenerator.this.getResolvedName(inputType);
                            _builder.append((Object)_resolvedName_2, "    ");
                            _builder.append((Object)"(");
                            boolean _hasElements = false;
                            for (BitsTypeDefinition.Bit bit_1 : sortedBits) {
                                if (!_hasElements) {
                                    _hasElements = true;
                                } else {
                                    _builder.appendImmediate((Object)",", "    ");
                                }
                                String _propertyName_1 = TransformerGenerator.this.getPropertyName(bit_1);
                                _builder.append((Object)_propertyName_1, "    ");
                            }
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomValue", Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"return fromDomValue($1);");
                            _builder.newLine();
                            _builder.append((Object)"                    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                CodeGenerationException _codeGenerationException;
                Exception e = (Exception)_t;
                log.error("Cannot compile DOM Codec for {}", inputType, (Object)e);
                String _plus = "Cannot compile Transformator for " + inputType;
                CodeGenerationException exception = _codeGenerationException = new CodeGenerationException(_plus);
                exception.addSuppressed(e);
                throw exception;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public String getPropertyName(BitsTypeDefinition.Bit bit) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"_");
        String _name = bit.getName();
        String _parseToValidParamName = BindingGeneratorUtil.parseToValidParamName((String)_name);
        _builder.append((Object)_parseToValidParamName, "");
        return _builder.toString();
    }

    public String getterName(BitsTypeDefinition.Bit bit) {
        String _name = bit.getName();
        String paramName = BindingGeneratorUtil.parseToValidParamName((String)_name);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"is");
        String _firstUpper = StringExtensions.toFirstUpper((String)paramName);
        _builder.append((Object)_firstUpper, "");
        return _builder.toString();
    }

    public boolean isYangBindingAvailable(Class<? extends Object> class1) {
        try {
            ClassLoader _classLoader = class1.getClassLoader();
            String _name = this.BINDING_CODEC.getName();
            Class<?> bindingCodecClass = _classLoader.loadClass(_name);
            return bindingCodecClass != null;
        }
        catch (Throwable _t) {
            if (_t instanceof ClassNotFoundException) {
                ClassNotFoundException e = (ClassNotFoundException)_t;
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private CtClass createDummyImplementation(final Class<? extends Object> object, GeneratedTransferObject typeSpec) {
        ClassLoader _classLoader = object.getClassLoader();
        log.trace("Generating Dummy DOM Codec for {} with {}", object, (Object)_classLoader);
        String _codecClassName = this.codecClassName((GeneratedType)typeSpec);
        ClassGenerator _function = new ClassGenerator(){

            @Override
            public void process(CtClass it) {
                boolean _isYangBindingAvailable = TransformerGenerator.this.isYangBindingAvailable(object);
                if (_isYangBindingAvailable) {
                    TransformerGenerator.this.utils.implementsType(it, TransformerGenerator.this.BINDING_CODEC);
                    TransformerGenerator.this.utils.staticField(it, "INSTANCE_IDENTIFIER_CODEC", BindingCodec.class);
                    TransformerGenerator.this.utils.staticField(it, "IDENTITYREF_CODEC", BindingCodec.class);
                    CtClass _asCtClass = TransformerGenerator.this.utils.asCtClass(BindingDeserializer.class);
                    TransformerGenerator.this.utils.implementsType(it, _asCtClass);
                }
                MethodGenerator _function = new MethodGenerator(){

                    @Override
                    public void process(CtMethod it) {
                        int _plus = 17;
                        int _plus_1 = _plus + 8;
                        it.setModifiers(_plus_1);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"                    ");
                        _builder.append((Object)"if($1 == null) {");
                        _builder.newLine();
                        _builder.append((Object)"                        ");
                        _builder.append((Object)"return null;");
                        _builder.newLine();
                        _builder.append((Object)"                    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        _builder.append((Object)"                    ");
                        _builder.append((Object)"return $1.toString();");
                        _builder.newLine();
                        _builder.newLine();
                        _builder.append((Object)"                    ");
                        _builder.append((Object)"}");
                        TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                    }
                };
                TransformerGenerator.this.utils.method(it, Object.class, "toDomValue", Object.class, _function);
                MethodGenerator _function_1 = new MethodGenerator(){

                    @Override
                    public void process(CtMethod it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"    ");
                        _builder.append((Object)"return toDomValue($1);");
                        _builder.newLine();
                        _builder.append((Object)"}");
                        _builder.newLine();
                        TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                    }
                };
                TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                MethodGenerator _function_2 = new MethodGenerator(){

                    @Override
                    public void process(CtMethod it) {
                        int _plus = 17;
                        int _plus_1 = _plus + 8;
                        it.setModifiers(_plus_1);
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"return null;");
                        TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                    }
                };
                TransformerGenerator.this.utils.method(it, Object.class, "fromDomValue", Object.class, _function_2);
                MethodGenerator _function_3 = new MethodGenerator(){

                    @Override
                    public void process(CtMethod it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append((Object)"{");
                        _builder.newLine();
                        _builder.append((Object)"                        ");
                        _builder.append((Object)"return fromDomValue($1);");
                        _builder.newLine();
                        _builder.append((Object)"                    ");
                        _builder.append((Object)"}");
                        _builder.newLine();
                        TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                    }
                };
                TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
            }
        };
        return this.utils.createClass(_codecClassName, _function);
    }

    private Type getValueReturnType(GeneratedTransferObject object) {
        boolean _notEquals;
        List _properties = object.getProperties();
        for (GeneratedProperty prop : _properties) {
            String _name = prop.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)"value");
            if (!_equals) continue;
            return prop.getReturnType();
        }
        GeneratedTransferObject _superType = object.getSuperType();
        boolean bl = _notEquals = !Objects.equal((Object)_superType, null);
        if (_notEquals) {
            GeneratedTransferObject _superType_1 = object.getSuperType();
            return this.getValueReturnType(_superType_1);
        }
        return null;
    }

    private Class<? extends Object> generateValueTransformer(Class<? extends Object> inputType, final Enumeration typeSpec) {
        try {
            ReferencedTypeImpl _referencedTypeImpl;
            String _packageName = typeSpec.getPackageName();
            String _name = typeSpec.getName();
            ReferencedTypeImpl typeRef = _referencedTypeImpl = new ReferencedTypeImpl(_packageName, _name);
            Map<Type, SchemaNode> _typeToSchemaNode = this.getTypeToSchemaNode();
            SchemaNode _get = _typeToSchemaNode.get(typeRef);
            ExtendedType schema = (ExtendedType)_get;
            TypeDefinition _baseType = schema.getBaseType();
            final EnumerationType enumSchema = (EnumerationType)_baseType;
            String _codecClassName = this.codecClassName((GeneratedType)typeSpec);
            ClassGenerator _function = new ClassGenerator(){

                @Override
                public void process(CtClass it) {
                    MethodGenerator _function = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"                                ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"                            ");
                            String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName, "                            ");
                            _builder.append((Object)" _value = (");
                            String _resolvedName_1 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                            _builder.append((Object)_resolvedName_1, "                            ");
                            _builder.append((Object)") $1;");
                            _builder.newLineIfNotEmpty();
                            List _values = enumSchema.getValues();
                            for (EnumTypeDefinition.EnumPair en : _values) {
                                _builder.append((Object)"                            ");
                                _builder.append((Object)"if(");
                                String _resolvedName_2 = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                                _builder.append((Object)_resolvedName_2, "                            ");
                                _builder.append((Object)".");
                                String _name = en.getName();
                                String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_name);
                                _builder.append((Object)_parseToClassName, "                            ");
                                _builder.append((Object)".equals(_value)) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"                            ");
                                _builder.append((Object)"    ");
                                _builder.append((Object)"return \"");
                                String _name_1 = en.getName();
                                _builder.append((Object)_name_1, "                                ");
                                _builder.append((Object)"\";");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"                            ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                            }
                            _builder.append((Object)"                            ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"                        ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "toDomValue", Object.class, _function);
                    MethodGenerator _function_1 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"return toDomValue($1);");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "serialize", Object.class, _function_1);
                    MethodGenerator _function_2 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            int _plus = 17;
                            int _plus_1 = _plus + 8;
                            it.setModifiers(_plus_1);
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"{");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"if($1 == null) {");
                            _builder.newLine();
                            _builder.append((Object)"        ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"}");
                            _builder.newLine();
                            _builder.append((Object)"    ");
                            _builder.append((Object)"String _value = (String) $1;");
                            _builder.newLine();
                            List _values = enumSchema.getValues();
                            for (EnumTypeDefinition.EnumPair en : _values) {
                                _builder.append((Object)"    ");
                                _builder.append((Object)"if(\"");
                                String _name = en.getName();
                                _builder.append((Object)_name, "    ");
                                _builder.append((Object)"\".equals(_value)) {");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"    ");
                                _builder.append((Object)"return ");
                                String _resolvedName = TransformerGenerator.this.getResolvedName((Type)typeSpec);
                                _builder.append((Object)_resolvedName, "        ");
                                _builder.append((Object)".");
                                String _name_1 = en.getName();
                                String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_name_1);
                                _builder.append((Object)_parseToClassName, "        ");
                                _builder.append((Object)";");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"    ");
                                _builder.append((Object)"}");
                                _builder.newLine();
                            }
                            _builder.append((Object)"    ");
                            _builder.append((Object)"return null;");
                            _builder.newLine();
                            _builder.append((Object)"}");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "fromDomValue", Object.class, _function_2);
                    MethodGenerator _function_3 = new MethodGenerator(){

                        @Override
                        public void process(CtMethod it) {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append((Object)"return fromDomValue($1);");
                            _builder.newLine();
                            TransformerGenerator.this.setBodyChecked(it, _builder.toString());
                        }
                    };
                    TransformerGenerator.this.utils.method(it, Object.class, "deserialize", Object.class, _function_3);
                }
            };
            CtClass ctCls = this.utils.createClass(_codecClassName, _function);
            ClassLoader _classLoader = inputType.getClassLoader();
            ProtectionDomain _protectionDomain = inputType.getProtectionDomain();
            Class<? extends Object> ret = this.toClassImpl(ctCls, _classLoader, _protectionDomain);
            log.debug("DOM Codec for {} was generated {}", inputType, ret);
            return ret;
        }
        catch (Throwable _t) {
            if (_t instanceof CodeGenerationException) {
                CodeGenerationException e = (CodeGenerationException)_t;
                String _plus = "Cannot compile Transformator for " + inputType;
                CodeGenerationException _codeGenerationException = new CodeGenerationException(_plus, e);
                throw _codeGenerationException;
            }
            if (_t instanceof Exception) {
                CodeGenerationException _codeGenerationException_1;
                Exception e_1 = (Exception)_t;
                log.error("Cannot compile DOM Codec for {}", inputType, (Object)e_1);
                String _plus_1 = "Cannot compile Transformator for " + inputType;
                CodeGenerationException exception = _codeGenerationException_1 = new CodeGenerationException(_plus_1);
                exception.addSuppressed(e_1);
                throw exception;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Class<? extends Object> toClassImpl(CtClass newClass, ClassLoader loader, ProtectionDomain domain) {
        try {
            GeneratorListener _listener;
            boolean _tripleNotEquals;
            Class cls = newClass.toClass(loader, domain);
            File _classFileCapturePath = this.getClassFileCapturePath();
            boolean bl = _tripleNotEquals = _classFileCapturePath != null;
            if (_tripleNotEquals) {
                File _classFileCapturePath_1 = this.getClassFileCapturePath();
                String _absolutePath = _classFileCapturePath_1.getAbsolutePath();
                newClass.writeFile(_absolutePath);
            }
            if ((_listener = this.getListener()) != null) {
                _listener.onCodecCreated(cls);
            }
            return cls;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public boolean debugWriteClass(CtClass class1) {
        try {
            boolean _createNewFile;
            File _file;
            boolean _xblockexpression = false;
            String _name = class1.getName();
            String _replace = _name.replace(".", "/");
            String path = _replace + ".class";
            File _classFileCapturePath = this.getClassFileCapturePath();
            File captureFile = _file = new File(_classFileCapturePath, path);
            _xblockexpression = _createNewFile = captureFile.createNewFile();
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String _deserializeValue(Type type, String domParameter, TypeDefinition<? extends Object> typeDef) {
        boolean _equals = INSTANCE_IDENTIFIER.equals(type);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"(");
            String _name = InstanceIdentifier.class.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)") ");
            _builder.append((Object)"INSTANCE_IDENTIFIER_CODEC", "");
            _builder.append((Object)".deserialize(");
            _builder.append((Object)domParameter, "");
            _builder.append((Object)")");
            return _builder.toString();
        }
        boolean _equals_1 = CLASS_TYPE.equals(type);
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"(");
            String _name_1 = Class.class.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)") ");
            _builder_1.append((Object)"IDENTITYREF_CODEC", "");
            _builder_1.append((Object)".deserialize(");
            _builder_1.append((Object)domParameter, "");
            _builder_1.append((Object)")");
            return _builder_1.toString();
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"(");
        String _resolvedName = this.getResolvedName(type);
        _builder_2.append((Object)_resolvedName, "");
        _builder_2.append((Object)") ");
        _builder_2.append((Object)domParameter, "");
        return _builder_2.toString();
    }

    private CharSequence _deserializeProperty(DataSchemaNode container, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = null;");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _deserializeProperty(DataSchemaNode container, GeneratedTypeBuilder type, String propertyName) {
        GeneratedType _instance = type.toInstance();
        CharSequence __deserializeProperty = this._deserializeProperty(container, (Type)_instance, propertyName);
        return __deserializeProperty;
    }

    public static String toSetter(String it) {
        boolean _startsWith = it.startsWith("is");
        if (_startsWith) {
            String _substring = it.substring(2);
            return "set" + _substring;
        }
        boolean _startsWith_1 = it.startsWith("get");
        if (_startsWith_1) {
            String _substring_1 = it.substring(3);
            return "set" + _substring_1;
        }
        return "set" + it;
    }

    private CharSequence getBuilderName(GeneratedType type) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)"Builder");
        return _builder;
    }

    private void staticQNameField(CtClass it, QName node) {
        try {
            CtField _ctField;
            CtField field = _ctField = new CtField(this.ctQName, "QNAME", it);
            int _plus = 17;
            int _plus_1 = _plus + 8;
            field.setModifiers(_plus_1);
            StringConcatenation _builder = new StringConcatenation();
            CtClass _asCtClass = this.utils.asCtClass(QName.class);
            String _name = _asCtClass.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".create(\"");
            URI _namespace = node.getNamespace();
            _builder.append((Object)_namespace, "");
            _builder.append((Object)"\",\"");
            String _formattedRevision = node.getFormattedRevision();
            _builder.append((Object)_formattedRevision, "");
            _builder.append((Object)"\",\"");
            String _localName = node.getLocalName();
            _builder.append((Object)_localName, "");
            _builder.append((Object)"\")");
            it.addField(field, _builder.toString());
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private String _serializeBody(GeneratedType type, ListSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _resultName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "    ");
        _builder.append((Object)" value = (");
        String _resolvedName_1 = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)") $2;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        HashMap<String, Type> _allProperties = this.getAllProperties(type);
        String _transformDataContainerBody = this.transformDataContainerBody((Type)type, _allProperties, (DataNodeContainer)node);
        _builder.append((Object)_transformDataContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _serializeAugmentations = this.serializeAugmentations();
        _builder.append((Object)_serializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return ($r) java.util.Collections.singletonMap(_resultName,_childNodes);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _serializeBody(GeneratedType type, ContainerSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _resultName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "    ");
        _builder.append((Object)" value = (");
        String _resolvedName_1 = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)") $2;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        HashMap<String, Type> _allProperties = this.getAllProperties(type);
        String _transformDataContainerBody = this.transformDataContainerBody((Type)type, _allProperties, (DataNodeContainer)node);
        _builder.append((Object)_transformDataContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _serializeAugmentations = this.serializeAugmentations();
        _builder.append((Object)_serializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return ($r) java.util.Collections.singletonMap(_resultName,_childNodes);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _serializeBody(GeneratedType type, ChoiceCaseNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        String _name = QName.class.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" _resultName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "    ");
        _builder.append((Object)" value = (");
        String _resolvedName_1 = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)") $2;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        HashMap<String, Type> _allProperties = this.getAllProperties(type);
        String _transformDataContainerBody = this.transformDataContainerBody((Type)type, _allProperties, (DataNodeContainer)node);
        _builder.append((Object)_transformDataContainerBody, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        CharSequence _serializeAugmentations = this.serializeAugmentations();
        _builder.append((Object)_serializeAugmentations, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return ($r) java.util.Collections.singletonMap(_resultName,_childNodes);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String _serializeBody(GeneratedType type, SchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        String _name = QName.class.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" _resultName = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)".create($1,QNAME.getLocalName());");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List _childNodes = new java.util.ArrayList();");
        _builder.newLine();
        _builder.append((Object)"    ");
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "    ");
        _builder.append((Object)" value = (");
        String _resolvedName_1 = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)") $2;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"return ($r) java.util.Collections.singletonMap(_resultName,_childNodes);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    private String transformDataContainerBody(Type type, Map<String, Type> properties, DataNodeContainer node) {
        StringConcatenation _builder = new StringConcatenation();
        Set _childNodes = node.getChildNodes();
        for (DataSchemaNode child : _childNodes) {
            Map.Entry<String, Type> signature = this.getFor(properties, child);
            _builder.newLineIfNotEmpty();
            boolean _tripleNotEquals = signature != null;
            if (!_tripleNotEquals) continue;
            _builder.append((Object)"////System.out.println(\"");
            String _name = type.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"#");
            String _key = signature.getKey();
            _builder.append((Object)_key, "");
            _builder.append((Object)"\" + value.");
            String _key_1 = signature.getKey();
            _builder.append((Object)_key_1, "");
            _builder.append((Object)"());");
            _builder.newLineIfNotEmpty();
            Type _value = signature.getValue();
            String _key_2 = signature.getKey();
            CharSequence _serializeProperty = this.serializeProperty(child, _value, _key_2);
            _builder.append((Object)_serializeProperty, "");
            _builder.newLineIfNotEmpty();
        }
        String ret = _builder.toString();
        return ret;
    }

    private CharSequence serializeAugmentations() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"java.util.List _augmentations = (java.util.List) ");
        _builder.append((Object)"AUGMENTATION_CODEC", "");
        _builder.append((Object)".serialize(value);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(_augmentations != null) {");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"_childNodes.addAll(_augmentations);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public Map.Entry<String, Type> getFor(Map<String, Type> map, DataSchemaNode node) {
        boolean _notEquals_1;
        boolean _notEquals;
        String _getterName = TransformerGenerator.getGetterName(node);
        Type sig = map.get(_getterName);
        boolean bl = _notEquals = !Objects.equal((Object)sig, null);
        if (_notEquals) {
            String _getterName_1 = TransformerGenerator.getGetterName(node);
            AbstractMap.SimpleEntry<String, Type> _simpleEntry = new AbstractMap.SimpleEntry<String, Type>(_getterName_1, sig);
            return _simpleEntry;
        }
        String _booleanGetterName = TransformerGenerator.getBooleanGetterName(node);
        Type _get = map.get(_booleanGetterName);
        sig = _get;
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)sig, null);
        if (_notEquals_1) {
            String _booleanGetterName_1 = TransformerGenerator.getBooleanGetterName(node);
            String _booleanGetterName_2 = TransformerGenerator.getBooleanGetterName(node);
            Type _get_1 = map.get(_booleanGetterName_2);
            AbstractMap.SimpleEntry<String, Type> _simpleEntry_1 = new AbstractMap.SimpleEntry<String, Type>(_booleanGetterName_1, _get_1);
            return _simpleEntry_1;
        }
        return null;
    }

    private static String getBooleanGetterName(DataSchemaNode node) {
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_localName);
        return "is" + _parseToClassName;
    }

    private static String getGetterName(DataSchemaNode node) {
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_localName);
        return "get" + _parseToClassName;
    }

    private static String getGetterName(QName node) {
        String _localName = node.getLocalName();
        String _parseToClassName = BindingGeneratorUtil.parseToClassName((String)_localName);
        return "get" + _parseToClassName;
    }

    private CharSequence _serializeProperty(ListSchemaNode schema, ParameterizedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"////System.out.println(\"");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)":\" + ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Iterator _iterator = ");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)".iterator();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"boolean _hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while(_hasNext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _listItem = _iterator.next();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _domValue = ");
        Type[] _actualTypeArguments = type.getActualTypeArguments();
        Type _get = _actualTypeArguments[0];
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer(_get, (DataSchemaNode)schema);
        String _resolvedName_1 = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName_1, "        ");
        _builder.append((Object)".toDomStatic(_resultName,_listItem);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"_childNodes.add(_domValue);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _serializeProperty(LeafSchemaNode schema, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _qname = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create(_resultName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "    ");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"Object _propValue = ");
        TypeDefinition _type = schema.getType();
        CharSequence _serializeValue = this.serializeValue(type, propertyName, (TypeDefinition<? extends Object>)_type);
        _builder.append((Object)_serializeValue, "    ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"if(_propValue != null) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _domValue = java.util.Collections.singletonMap(_qname,_propValue);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_childNodes.add(_domValue);");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _serializeValue(GeneratedTransferObject type, String parameter, TypeDefinition<? extends Object> typeDefinition) {
        StringConcatenation _builder = new StringConcatenation();
        Class<? extends Object> _valueSerializer = this.valueSerializer(type, typeDefinition);
        String _resolvedName = this.getResolvedName(_valueSerializer);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)".toDomValue(");
        _builder.append((Object)parameter, "");
        _builder.append((Object)")");
        return _builder;
    }

    private CharSequence _serializeValue(Enumeration type, String parameter, TypeDefinition<? extends Object> typeDefinition) {
        StringConcatenation _builder = new StringConcatenation();
        Class<? extends Object> _valueSerializer = this.valueSerializer(type, typeDefinition);
        String _resolvedName = this.getResolvedName(_valueSerializer);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)".toDomValue(");
        _builder.append((Object)parameter, "");
        _builder.append((Object)")");
        return _builder;
    }

    private CharSequence _serializeValue(Type signature, String property, TypeDefinition<? extends Object> typeDefinition) {
        boolean _equals = Objects.equal((Object)INSTANCE_IDENTIFIER, (Object)signature);
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"INSTANCE_IDENTIFIER_CODEC", "");
            _builder.append((Object)".serialize(");
            _builder.append((Object)property, "");
            _builder.append((Object)")");
            return _builder.toString();
        }
        boolean _equals_1 = CLASS_TYPE.equals(signature);
        if (_equals_1) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"(");
            String _resolvedName = this.getResolvedName(QName.class);
            _builder_1.append((Object)_resolvedName, "");
            _builder_1.append((Object)") ");
            _builder_1.append((Object)"IDENTITYREF_CODEC", "");
            _builder_1.append((Object)".serialize(");
            _builder_1.append((Object)property, "");
            _builder_1.append((Object)")");
            return _builder_1.toString();
        }
        String _name = signature.getName();
        boolean _equals_2 = Objects.equal((Object)"char[]", (Object)_name);
        if (_equals_2) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"new String(");
            _builder_2.append((Object)property, "");
            _builder_2.append((Object)")");
            return _builder_2.toString();
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append((Object)property, "");
        return _builder_3.toString();
    }

    private CharSequence _serializeProperty(LeafListSchemaNode schema, ParameterizedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _name = QName.class.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)" _qname = ");
        String _name_1 = QName.class.getName();
        _builder.append((Object)_name_1, "    ");
        _builder.append((Object)".create(_resultName,\"");
        QName _qName = schema.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "    ");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.Iterator _iterator = ");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)".iterator();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"boolean _hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"while(_hasNext) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _listItem = _iterator.next();");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _propValue = ");
        Type[] _actualTypeArguments = type.getActualTypeArguments();
        Type _get = _actualTypeArguments[0];
        TypeDefinition _type = schema.getType();
        CharSequence _serializeValue = this.serializeValue(_get, "_listItem", (TypeDefinition<? extends Object>)_type);
        _builder.append((Object)_serializeValue, "        ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"Object _domValue = java.util.Collections.singletonMap(_qname,_propValue);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_childNodes.add(_domValue);");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"_hasNext = _iterator.hasNext();");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _serializeProperty(ChoiceNode container, GeneratedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"java.util.List domValue = ");
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer((Type)type, (DataSchemaNode)container);
        String _resolvedName_1 = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)".toDomStatic(_resultName,");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_childNodes.addAll(domValue);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _serializeProperty(DataSchemaNode container, Type type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName(type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"Object domValue = ");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_childNodes.add(domValue);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _serializeProperty(DataSchemaNode container, GeneratedTypeBuilder type, String propertyName) {
        GeneratedType _instance = type.toInstance();
        CharSequence _serializeProperty = this.serializeProperty(container, (Type)_instance, propertyName);
        return _serializeProperty;
    }

    private CharSequence _serializeProperty(DataSchemaNode container, GeneratedType type, String propertyName) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)type);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)" ");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" = value.");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)"();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"if(");
        _builder.append((Object)propertyName, "");
        _builder.append((Object)" != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"Object domValue = ");
        Class<? extends BindingCodec<Map<QName, Object>, Object>> _serializer = this.serializer((Type)type, container);
        String _resolvedName_1 = this.getResolvedName(_serializer);
        _builder.append((Object)_resolvedName_1, "    ");
        _builder.append((Object)".toDomStatic(_resultName,");
        _builder.append((Object)propertyName, "    ");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"_childNodes.add(domValue);");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    private String codecClassName(GeneratedType typeSpec) {
        StringConcatenation _builder = new StringConcatenation();
        String _resolvedName = this.getResolvedName((Type)typeSpec);
        _builder.append((Object)_resolvedName, "");
        _builder.append((Object)"$Broker$Codec$DOM");
        return _builder.toString();
    }

    private String codecClassName(Class<? extends Object> typeSpec) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = typeSpec.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"$Broker$Codec$DOM");
        return _builder.toString();
    }

    private HashMap<String, Type> getAllProperties(GeneratedType type) {
        HashMap<String, Type> _hashMap;
        HashMap<String, Type> ret = _hashMap = new HashMap<String, Type>();
        this.collectAllProperties((Type)type, ret);
        return ret;
    }

    private void _collectAllProperties(GeneratedType type, Map<String, Type> set) {
        List _methodDefinitions = type.getMethodDefinitions();
        for (MethodSignature definition : _methodDefinitions) {
            String _name = definition.getName();
            Type _returnType = definition.getReturnType();
            set.put(_name, _returnType);
        }
        List _properties = type.getProperties();
        for (GeneratedProperty property : _properties) {
            String _getterName = this.getGetterName(property);
            Type _returnType_1 = property.getReturnType();
            set.put(_getterName, _returnType_1);
        }
        List _implements = type.getImplements();
        for (Type parent : _implements) {
            this.collectAllProperties(parent, set);
        }
    }

    public String getGetterName(GeneratedProperty property) {
        String _name = property.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        return "get" + _firstUpper;
    }

    private void _collectAllProperties(Type type, Map<String, Type> set) {
    }

    public String getResolvedName(Type type) {
        CtClass _asCtClass = this.asCtClass(type);
        return _asCtClass.getName();
    }

    public String getResolvedName(Class<? extends Object> type) {
        CtClass _asCtClass = this.utils.asCtClass(type);
        return _asCtClass.getName();
    }

    public CtClass asCtClass(Type type) {
        try {
            String _fullyQualifiedName = type.getFullyQualifiedName();
            Class<?> cls = ClassLoaderUtils.loadClassWithTCCL(_fullyQualifiedName);
            return this.utils.asCtClass(cls);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void _processException(Class<? extends Object> inputType, CodeGenerationException e) {
        log.error("Cannot compile DOM Codec for {}. One of it's prerequisites was not generated.", inputType);
        throw e;
    }

    private void _processException(Class<? extends Object> inputType, Exception e) {
        CodeGenerationException _codeGenerationException;
        log.error("Cannot compile DOM Codec for {}", inputType, (Object)e);
        String _plus = "Cannot compile Transformator for " + inputType;
        CodeGenerationException exception = _codeGenerationException = new CodeGenerationException(_plus, e);
        throw exception;
    }

    private void setBodyChecked(CtMethod method, String body) {
        try {
            try {
                method.setBody(body);
            }
            catch (Throwable _t) {
                if (_t instanceof CannotCompileException) {
                    CannotCompileException e = (CannotCompileException)_t;
                    CtClass _declaringClass = method.getDeclaringClass();
                    String _name = method.getName();
                    String _signature = method.getSignature();
                    String _message = e.getMessage();
                    log.error("Cannot compile method: {}#{} {}, Reason: {} Body: {}", new Object[]{_declaringClass, _name, _signature, _message, body});
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private <V> V withClassLoaderAndLock(ClassLoader cls, Lock lock, Callable<V> function) throws Exception {
        V _xblockexpression = null;
        this.utils.appendClassLoaderIfMissing(cls);
        V _withClassLoaderAndLock = ClassLoaderUtils.withClassLoaderAndLock(cls, lock, function);
        _xblockexpression = _withClassLoaderAndLock;
        return _xblockexpression;
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> generateTransformerFor(Class<? extends Object> inputType, GeneratedType typeSpec, SchemaNode node) {
        if (node instanceof ChoiceNode) {
            return this._generateTransformerFor(inputType, typeSpec, (ChoiceNode)node);
        }
        if (node != null) {
            return this._generateTransformerFor(inputType, typeSpec, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputType, typeSpec, node).toString());
    }

    private String deserializeBodyImpl(GeneratedType type, SchemaNode node) {
        if (node instanceof ChoiceCaseNode) {
            return this._deserializeBodyImpl(type, (ChoiceCaseNode)node);
        }
        if (node instanceof ContainerSchemaNode) {
            return this._deserializeBodyImpl(type, (ContainerSchemaNode)node);
        }
        if (node instanceof ListSchemaNode) {
            return this._deserializeBodyImpl(type, (ListSchemaNode)node);
        }
        if (node != null) {
            return this._deserializeBodyImpl(type, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, node).toString());
    }

    private CharSequence deserializeProperty(DataSchemaNode schema, Type type, String propertyName) {
        if (schema instanceof LeafListSchemaNode && type instanceof ParameterizedType) {
            return this._deserializeProperty((LeafListSchemaNode)schema, (ParameterizedType)type, propertyName);
        }
        if (schema instanceof ListSchemaNode && type instanceof ParameterizedType) {
            return this._deserializeProperty((ListSchemaNode)schema, (ParameterizedType)type, propertyName);
        }
        if (schema instanceof ChoiceNode && type != null) {
            return this._deserializeProperty((ChoiceNode)schema, type, propertyName);
        }
        if (schema instanceof ContainerSchemaNode && type != null) {
            return this._deserializeProperty((ContainerSchemaNode)schema, type, propertyName);
        }
        if (schema instanceof LeafSchemaNode && type != null) {
            return this._deserializeProperty((LeafSchemaNode)schema, type, propertyName);
        }
        if (schema != null && type instanceof GeneratedTypeBuilder) {
            return this._deserializeProperty(schema, (GeneratedTypeBuilder)type, propertyName);
        }
        if (schema != null && type != null) {
            return this._deserializeProperty(schema, type, propertyName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(schema, type, propertyName).toString());
    }

    private String deserializeValue(Type type, String domParameter, TypeDefinition<? extends Object> typeDefinition) {
        if (type instanceof Enumeration) {
            return this._deserializeValue((Enumeration)type, domParameter, typeDefinition);
        }
        if (type instanceof GeneratedTransferObject) {
            return this._deserializeValue((GeneratedTransferObject)type, domParameter, typeDefinition);
        }
        if (type != null) {
            return this._deserializeValue(type, domParameter, typeDefinition);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, domParameter, typeDefinition).toString());
    }

    private Class<? extends BindingCodec<Map<QName, Object>, Object>> generateValueTransformer(Class<? extends Object> inputType, GeneratedTransferObject typeSpec, TypeDefinition<? extends Object> typeDef) {
        if (typeDef instanceof BitsTypeDefinition) {
            return this._generateValueTransformer(inputType, typeSpec, (BitsTypeDefinition)typeDef);
        }
        if (typeDef instanceof UnionTypeDefinition) {
            return this._generateValueTransformer(inputType, typeSpec, (UnionTypeDefinition)typeDef);
        }
        if (typeDef != null) {
            return this._generateValueTransformer(inputType, typeSpec, typeDef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputType, typeSpec, typeDef).toString());
    }

    private String serializeBody(GeneratedType type, SchemaNode node) {
        if (node instanceof ChoiceCaseNode) {
            return this._serializeBody(type, (ChoiceCaseNode)node);
        }
        if (node instanceof ContainerSchemaNode) {
            return this._serializeBody(type, (ContainerSchemaNode)node);
        }
        if (node instanceof ListSchemaNode) {
            return this._serializeBody(type, (ListSchemaNode)node);
        }
        if (node != null) {
            return this._serializeBody(type, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, node).toString());
    }

    private CharSequence serializeProperty(DataSchemaNode container, Type type, String propertyName) {
        if (container instanceof ChoiceNode && type instanceof GeneratedType) {
            return this._serializeProperty((ChoiceNode)container, (GeneratedType)type, propertyName);
        }
        if (container instanceof LeafListSchemaNode && type instanceof ParameterizedType) {
            return this._serializeProperty((LeafListSchemaNode)container, (ParameterizedType)type, propertyName);
        }
        if (container instanceof ListSchemaNode && type instanceof ParameterizedType) {
            return this._serializeProperty((ListSchemaNode)container, (ParameterizedType)type, propertyName);
        }
        if (container instanceof LeafSchemaNode && type != null) {
            return this._serializeProperty((LeafSchemaNode)container, type, propertyName);
        }
        if (container != null && type instanceof GeneratedTypeBuilder) {
            return this._serializeProperty(container, (GeneratedTypeBuilder)type, propertyName);
        }
        if (container != null && type instanceof GeneratedType) {
            return this._serializeProperty(container, (GeneratedType)type, propertyName);
        }
        if (container != null && type != null) {
            return this._serializeProperty(container, type, propertyName);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(container, type, propertyName).toString());
    }

    private CharSequence serializeValue(Type type, String parameter, TypeDefinition<? extends Object> typeDefinition) {
        if (type instanceof Enumeration) {
            return this._serializeValue((Enumeration)type, parameter, typeDefinition);
        }
        if (type instanceof GeneratedTransferObject) {
            return this._serializeValue((GeneratedTransferObject)type, parameter, typeDefinition);
        }
        if (type != null) {
            return this._serializeValue(type, parameter, typeDefinition);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, parameter, typeDefinition).toString());
    }

    private void collectAllProperties(Type type, Map<String, Type> set) {
        if (type instanceof GeneratedType) {
            this._collectAllProperties((GeneratedType)type, set);
            return;
        }
        if (type != null) {
            this._collectAllProperties(type, set);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, set).toString());
    }

    private void processException(Class<? extends Object> inputType, Exception e) {
        if (e instanceof CodeGenerationException) {
            this._processException(inputType, (CodeGenerationException)e);
            return;
        }
        if (e != null) {
            this._processException(inputType, e);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputType, e).toString());
    }
}

