/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;

public final class BindingGeneratorUtil {
    private static final CharMatcher DOT_MATCHER = CharMatcher.is((char)'.');
    private static final CharMatcher DASH_COLON_MATCHER = CharMatcher.anyOf((CharSequence)"-:");
    private static final Restrictions EMPTY_RESTRICTIONS = new Restrictions(){

        public List<LengthConstraint> getLengthConstraints() {
            return Collections.emptyList();
        }

        public List<PatternConstraint> getPatternConstraints() {
            return Collections.emptyList();
        }

        public List<RangeConstraint> getRangeConstraints() {
            return Collections.emptyList();
        }

        public boolean isEmpty() {
            return true;
        }
    };
    private static final Comparator<TypeMemberBuilder<?>> SUID_MEMBER_COMPARATOR = new Comparator<TypeMemberBuilder<?>>(){

        @Override
        public int compare(TypeMemberBuilder<?> o1, TypeMemberBuilder<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Type> SUID_NAME_COMPARATOR = new Comparator<Type>(){

        @Override
        public int compare(Type o1, Type o2) {
            return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
        }
    };

    private BindingGeneratorUtil() {
    }

    public static String resolveJavaReservedWordEquivalency(String parameterName) {
        if (parameterName != null && BindingMapping.JAVA_RESERVED_WORDS.contains(parameterName)) {
            return "_" + parameterName;
        }
        return parameterName;
    }

    @Deprecated
    public static String moduleNamespaceToPackageName(Module module) {
        return BindingMapping.getRootPackageName((QNameModule)module.getQNameModule());
    }

    public static String packageNameForGeneratedType(String basePackageName, SchemaPath schemaPath) {
        return BindingGeneratorUtil.packageNameForGeneratedType(basePackageName, schemaPath, false);
    }

    public static String packageNameForGeneratedType(String basePackageName, SchemaPath schemaPath, boolean isUsesAugment) {
        if (basePackageName == null) {
            throw new IllegalArgumentException("Base Package Name cannot be NULL!");
        }
        if (schemaPath == null) {
            throw new IllegalArgumentException("Schema Path cannot be NULL!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(basePackageName);
        Iterable iterable = schemaPath.getPathFromRoot();
        Iterator iterator = iterable.iterator();
        int size = Iterables.size((Iterable)iterable);
        int traversalSteps = isUsesAugment ? size : size - 1;
        for (int i = 0; i < traversalSteps; ++i) {
            builder.append('.');
            String nodeLocalName = ((QName)iterator.next()).getLocalName();
            builder.append(DASH_COLON_MATCHER.replaceFrom((CharSequence)nodeLocalName, '.'));
        }
        return BindingMapping.normalizePackageName((String)builder.toString());
    }

    public static String packageNameForTypeDefinition(String basePackageName, TypeDefinition<?> typeDefinition) {
        if (basePackageName == null) {
            throw new IllegalArgumentException("Base Package Name cannot be NULL!");
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Type Definition reference cannot be NULL!");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(basePackageName);
        return BindingMapping.normalizePackageName((String)builder.toString());
    }

    @Deprecated
    public static String parseToClassName(String token) {
        return BindingGeneratorUtil.parseToCamelCase(token, true);
    }

    @Deprecated
    public static String parseToValidParamName(String token) {
        return BindingGeneratorUtil.resolveJavaReservedWordEquivalency(BindingGeneratorUtil.parseToCamelCase(token, false));
    }

    private static String parseToCamelCase(String token, boolean uppercase) {
        if (token == null) {
            throw new IllegalArgumentException("Name can not be null");
        }
        String correctStr = DOT_MATCHER.removeFrom((CharSequence)token.trim());
        if (correctStr.isEmpty()) {
            throw new IllegalArgumentException("Name can not be empty");
        }
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, ' ');
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, '-');
        correctStr = BindingGeneratorUtil.replaceWithCamelCase(correctStr, '_');
        char firstChar = correctStr.charAt(0);
        char c = firstChar = uppercase ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar);
        if (firstChar >= '0' && firstChar <= '9') {
            return '_' + correctStr;
        }
        return firstChar + correctStr.substring(1);
    }

    private static String replaceWithCamelCase(String text, char removalChar) {
        int toBeRemovedPos = text.indexOf(removalChar);
        if (toBeRemovedPos == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        String toBeRemoved = String.valueOf(removalChar);
        do {
            sb.replace(toBeRemovedPos, toBeRemovedPos + 1, "");
            if (sb.length() == 0) {
                throw new IllegalArgumentException("The resulting string can not be empty");
            }
            char replacement = Character.toUpperCase(sb.charAt(toBeRemovedPos));
            sb.setCharAt(toBeRemovedPos, replacement);
        } while ((toBeRemovedPos = sb.indexOf(toBeRemoved)) != -1);
        return sb.toString();
    }

    private static <T> Iterable<T> sortedCollection(Comparator<? super T> comparator, Collection<T> input) {
        if (input.size() > 1) {
            ArrayList<T> ret = new ArrayList<T>(input);
            Collections.sort(ret, comparator);
            return ret;
        }
        return input;
    }

    public static long computeDefaultSUID(GeneratedTypeBuilderBase<?> to) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(to.getName());
            dout.writeInt(to.isAbstract() ? 3 : 7);
            for (Type type : BindingGeneratorUtil.sortedCollection(SUID_NAME_COMPARATOR, to.getImplementsTypes())) {
                dout.writeUTF(type.getFullyQualifiedName());
            }
            for (GeneratedPropertyBuilder generatedPropertyBuilder : BindingGeneratorUtil.sortedCollection(SUID_MEMBER_COMPARATOR, to.getProperties())) {
                dout.writeUTF(generatedPropertyBuilder.getName());
            }
            for (MethodSignatureBuilder methodSignatureBuilder : BindingGeneratorUtil.sortedCollection(SUID_MEMBER_COMPARATOR, to.getMethodDefinitions())) {
                if (methodSignatureBuilder.getAccessModifier().equals((Object)AccessModifier.PRIVATE)) continue;
                dout.writeUTF(methodSignatureBuilder.getName());
                dout.write(methodSignatureBuilder.getAccessModifier().ordinal());
            }
            dout.flush();
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                byte[] byArray = md.digest(bout.toByteArray());
                long hash = 0L;
                for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                    hash = hash << 8 | (long)(byArray[i] & 0xFF);
                }
                return hash;
            }
            catch (NoSuchAlgorithmException ex) {
                throw new SecurityException(ex.getMessage());
            }
        }
        catch (IOException ex) {
            throw new InternalError();
        }
    }

    public static Restrictions getRestrictions(TypeDefinition<?> type) {
        if (!(type instanceof ExtendedType)) {
            return EMPTY_RESTRICTIONS;
        }
        ExtendedType ext = (ExtendedType)type;
        final List length = ext.getLengthConstraints();
        final List pattern = ext.getPatternConstraints();
        List tmp = ext.getRangeConstraints();
        if (tmp.isEmpty()) {
            TypeDefinition base = ext.getBaseType();
            if (base instanceof IntegerTypeDefinition) {
                tmp = ((IntegerTypeDefinition)base).getRangeConstraints();
            } else if (base instanceof UnsignedIntegerTypeDefinition) {
                tmp = ((UnsignedIntegerTypeDefinition)base).getRangeConstraints();
            } else if (base instanceof DecimalTypeDefinition) {
                tmp = ((DecimalTypeDefinition)base).getRangeConstraints();
            }
        }
        if (length.isEmpty() && pattern.isEmpty() && tmp.isEmpty()) {
            return EMPTY_RESTRICTIONS;
        }
        final List range = tmp;
        return new Restrictions(){

            public List<RangeConstraint> getRangeConstraints() {
                return range;
            }

            public List<PatternConstraint> getPatternConstraints() {
                return pattern;
            }

            public List<LengthConstraint> getLengthConstraints() {
                return length;
            }

            public boolean isEmpty() {
                return false;
            }
        };
    }
}

