/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.sal.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.WildcardType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public final class Types {
    private static final CacheLoader<Class<?>, ConcreteType> TYPE_LOADER = new CacheLoader<Class<?>, ConcreteType>(){

        public ConcreteType load(Class<?> key) {
            return new ConcreteTypeImpl(key.getPackage().getName(), key.getSimpleName(), null);
        }
    };
    private static final LoadingCache<Class<?>, ConcreteType> TYPE_CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build(TYPE_LOADER);
    private static final Type SET_TYPE = Types.typeForClass(Set.class);
    private static final Type LIST_TYPE = Types.typeForClass(List.class);
    private static final Type MAP_TYPE = Types.typeForClass(Map.class);
    public static final ConcreteType BOOLEAN = Types.typeForClass(Boolean.class);
    public static final ConcreteType FUTURE = Types.typeForClass(Future.class);
    public static final ConcreteType STRING = Types.typeForClass(String.class);
    public static final ConcreteType VOID = Types.typeForClass(Void.class);
    public static final ConcreteType BYTE_ARRAY = Types.primitiveType("byte[]", null);
    public static final ConcreteType CHAR_ARRAY = Types.primitiveType("char[]", null);
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');

    private Types() {
    }

    public static ConcreteType voidType() {
        return VOID;
    }

    public static ConcreteType primitiveType(String primitiveType, Restrictions restrictions) {
        return new ConcreteTypeImpl("", primitiveType, restrictions);
    }

    public static ConcreteType typeForClass(Class<?> cls) {
        return (ConcreteType)TYPE_CACHE.getUnchecked(cls);
    }

    public static ConcreteType typeForClass(Class<?> cls, Restrictions restrictions) {
        if (restrictions != null) {
            return new ConcreteTypeImpl(cls.getPackage().getName(), cls.getSimpleName(), restrictions);
        }
        return Types.typeForClass(cls);
    }

    public static ParameterizedType mapTypeFor(Type keyType, Type valueType) {
        return Types.parameterizedTypeFor(MAP_TYPE, keyType, valueType);
    }

    public static ParameterizedType setTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(SET_TYPE, valueType);
    }

    public static ParameterizedType listTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(LIST_TYPE, valueType);
    }

    public static ParameterizedType parameterizedTypeFor(Type type, Type ... parameters) {
        return new ParametrizedTypeImpl(type, parameters);
    }

    public static WildcardType wildcardTypeFor(String packageName, String typeName) {
        return new WildcardTypeImpl(packageName, typeName);
    }

    public static ParameterizedType augmentableTypeFor(Type valueType) {
        ConcreteType augmentable = Types.typeForClass(Augmentable.class);
        return Types.parameterizedTypeFor((Type)augmentable, valueType);
    }

    public static ParameterizedType augmentationTypeFor(Type valueType) {
        ConcreteType augmentation = Types.typeForClass(Augmentation.class);
        return Types.parameterizedTypeFor((Type)augmentation, valueType);
    }

    @Nullable
    public static String getOuterClassName(Type valueType) {
        String pkgName = valueType.getPackageName();
        if (CharMatcher.JAVA_UPPER_CASE.indexIn((CharSequence)pkgName) >= 0) {
            return (String)Iterables.getLast((Iterable)DOT_SPLITTER.split((CharSequence)pkgName));
        }
        return null;
    }

    private static class WildcardTypeImpl
    extends AbstractBaseType
    implements WildcardType {
        public WildcardTypeImpl(String packageName, String typeName) {
            super(packageName, typeName);
        }
    }

    private static class ParametrizedTypeImpl
    extends AbstractBaseType
    implements ParameterizedType {
        private final Type[] actualTypes;
        private final Type rawType;

        public Type[] getActualTypeArguments() {
            return this.actualTypes;
        }

        public Type getRawType() {
            return this.rawType;
        }

        public ParametrizedTypeImpl(Type rawType, Type[] actTypes) {
            super(rawType.getPackageName(), rawType.getName());
            this.rawType = rawType;
            this.actualTypes = (Type[])actTypes.clone();
        }
    }

    private static final class ConcreteTypeImpl
    extends AbstractBaseType
    implements ConcreteType {
        private final Restrictions restrictions;

        private ConcreteTypeImpl(String pkName, String name, Restrictions restrictions) {
            super(pkName, name);
            this.restrictions = restrictions;
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }
    }
}

