/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.ConstantImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.EnumerationBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedPropertyBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.GeneratedTOBuilderImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.MethodSignatureBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.util.LazyCollections;

abstract class AbstractGeneratedTypeBuilder<T extends GeneratedTypeBuilderBase<T>>
extends AbstractBaseType
implements GeneratedTypeBuilderBase<T> {
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private List<Type> implementsTypes = Collections.emptyList();
    private List<EnumBuilder> enumDefinitions = Collections.emptyList();
    private List<Constant> constants = Collections.emptyList();
    private List<MethodSignatureBuilder> methodDefinitions = Collections.emptyList();
    private final List<GeneratedTypeBuilder> enclosedTypes = Collections.emptyList();
    private List<GeneratedTOBuilder> enclosedTransferObjects = Collections.emptyList();
    private List<GeneratedPropertyBuilder> properties = Collections.emptyList();
    private String comment = "";
    private boolean isAbstract;

    protected AbstractGeneratedTypeBuilder(String packageName, String name) {
        super(packageName, name);
    }

    protected String getComment() {
        return this.comment;
    }

    protected List<AnnotationTypeBuilder> getAnnotations() {
        return this.annotationBuilders;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<Type> getImplementsTypes() {
        return this.implementsTypes;
    }

    protected List<EnumBuilder> getEnumerations() {
        return this.enumDefinitions;
    }

    protected List<Constant> getConstants() {
        return this.constants;
    }

    public List<MethodSignatureBuilder> getMethodDefinitions() {
        return this.methodDefinitions;
    }

    protected List<GeneratedTypeBuilder> getEnclosedTypes() {
        return this.enclosedTypes;
    }

    protected List<GeneratedTOBuilder> getEnclosedTransferObjects() {
        return this.enclosedTransferObjects;
    }

    protected abstract T thisInstance();

    public GeneratedTOBuilder addEnclosingTransferObject(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name for Enclosing Generated Transfer Object cannot be null!");
        GeneratedTOBuilderImpl builder = new GeneratedTOBuilderImpl(this.getFullyQualifiedName(), name);
        Preconditions.checkArgument((!this.enclosedTransferObjects.contains(builder) ? 1 : 0) != 0, (Object)"This generated type already contains equal enclosing transfer object.");
        this.enclosedTransferObjects = LazyCollections.lazyAdd(this.enclosedTransferObjects, (Object)builder);
        return builder;
    }

    public T addEnclosingTransferObject(GeneratedTOBuilder genTOBuilder) {
        Preconditions.checkArgument((genTOBuilder != null ? 1 : 0) != 0, (Object)"Parameter genTOBuilder cannot be null!");
        Preconditions.checkArgument((!this.enclosedTransferObjects.contains(genTOBuilder) ? 1 : 0) != 0, (Object)"This generated type already contains equal enclosing transfer object.");
        this.enclosedTransferObjects = LazyCollections.lazyAdd(this.enclosedTransferObjects, (Object)genTOBuilder);
        return this.thisInstance();
    }

    public T addComment(String comment) {
        this.comment = comment;
        return this.thisInstance();
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        Preconditions.checkArgument((packageName != null ? 1 : 0) != 0, (Object)"Package Name for Annotation Type cannot be null!");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of Annotation Type cannot be null!");
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(packageName, name);
        Preconditions.checkArgument((!this.annotationBuilders.contains(builder) ? 1 : 0) != 0, (Object)"This generated type already contains equal annotation.");
        this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
        return builder;
    }

    public T setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this.thisInstance();
    }

    public T addImplementsType(Type genType) {
        Preconditions.checkArgument((genType != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkArgument((!this.implementsTypes.contains(genType) ? 1 : 0) != 0, (Object)"This generated type already contains equal implements type.");
        this.implementsTypes = LazyCollections.lazyAdd(this.implementsTypes, (Object)genType);
        return this.thisInstance();
    }

    public Constant addConstant(Type type, String name, Object value) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Returning Type for Constant cannot be null!");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of constant cannot be null!");
        Preconditions.checkArgument((!this.containsConstant(name) ? 1 : 0) != 0, (Object)"This generated type already contains constant with the same name.");
        ConstantImpl constant = new ConstantImpl(this, type, name, value);
        this.constants = LazyCollections.lazyAdd(this.constants, (Object)constant);
        return constant;
    }

    public boolean containsConstant(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (Constant constant : this.constants) {
            if (!name.equals(constant.getName())) continue;
            return true;
        }
        return false;
    }

    public EnumBuilder addEnumeration(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of enumeration cannot be null!");
        EnumerationBuilderImpl builder = new EnumerationBuilderImpl(this.getFullyQualifiedName(), name);
        Preconditions.checkArgument((!this.enumDefinitions.contains(builder) ? 1 : 0) != 0, (Object)"This generated type already contains equal enumeration.");
        this.enumDefinitions = LazyCollections.lazyAdd(this.enumDefinitions, (Object)builder);
        return builder;
    }

    public MethodSignatureBuilder addMethod(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name of method cannot be null!");
        MethodSignatureBuilderImpl builder = new MethodSignatureBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        builder.setAbstract(true);
        this.methodDefinitions = LazyCollections.lazyAdd(this.methodDefinitions, (Object)builder);
        return builder;
    }

    public boolean containsMethod(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (MethodSignatureBuilder methodDefinition : this.methodDefinitions) {
            if (!name.equals(methodDefinition.getName())) continue;
            return true;
        }
        return false;
    }

    public GeneratedPropertyBuilder addProperty(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        Preconditions.checkArgument((!this.containsProperty(name) ? 1 : 0) != 0, (Object)"This generated type already contains property with the same name.");
        GeneratedPropertyBuilderImpl builder = new GeneratedPropertyBuilderImpl(name);
        builder.setAccessModifier(AccessModifier.PUBLIC);
        this.properties = LazyCollections.lazyAdd(this.properties, (Object)builder);
        return builder;
    }

    public boolean containsProperty(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Parameter name can't be null");
        for (GeneratedPropertyBuilder property : this.properties) {
            if (!name.equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeneratedTypeBuilder other = (AbstractGeneratedTypeBuilder)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getPackageName() == null ? other.getPackageName() != null : !this.getPackageName().equals(other.getPackageName()));
    }

    public Type getParent() {
        return null;
    }

    public List<GeneratedPropertyBuilder> getProperties() {
        return this.properties;
    }
}

