/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.List;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.TypeMember;

abstract class AbstractTypeMember
implements TypeMember {
    private final String name;
    private final String comment;
    private final Type definingType;
    private final Type returnType;
    private final List<AnnotationType> annotations;
    private final boolean isFinal;
    private final boolean isStatic;
    private final AccessModifier accessModifier;

    protected AbstractTypeMember(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, boolean isFinal, boolean isStatic) {
        this.definingType = definingType;
        this.name = name;
        this.annotations = annotations;
        this.comment = comment;
        this.accessModifier = accessModifier;
        this.returnType = returnType;
        this.isFinal = isFinal;
        this.isStatic = isStatic;
    }

    public List<AnnotationType> getAnnotations() {
        return this.annotations;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public Type getDefiningType() {
        return this.definingType;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTypeMember other = (AbstractTypeMember)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodSignatureImpl [name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        if (this.getDefiningType() != null) {
            builder.append(", definingType=");
            builder.append(this.getDefiningType().getPackageName());
            builder.append(".");
            builder.append(this.getDefiningType().getName());
        } else {
            builder.append(", definingType= null");
        }
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append("]");
        return builder.toString();
    }
}

