/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.yangtools.util.LazyCollections;

abstract class AbstractTypeMemberBuilder<T extends TypeMemberBuilder<T>>
implements TypeMemberBuilder<T> {
    private final String name;
    private Type returnType;
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private String comment = "";
    private boolean isFinal;
    private boolean isStatic;
    private AccessModifier accessModifier;

    public AbstractTypeMemberBuilder(String name) {
        this.name = name;
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        Preconditions.checkArgument((packageName != null ? 1 : 0) != 0, (Object)"Annotation Type cannot have package name null!");
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Annotation Type cannot have name as null!");
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(packageName, name);
        this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
        return builder;
    }

    protected Type getReturnType() {
        return this.returnType;
    }

    protected Iterable<AnnotationTypeBuilder> getAnnotationBuilders() {
        return this.annotationBuilders;
    }

    protected String getComment() {
        return this.comment;
    }

    protected boolean isFinal() {
        return this.isFinal;
    }

    protected boolean isStatic() {
        return this.isStatic;
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public String getName() {
        return this.name;
    }

    protected abstract T thisInstance();

    public T setReturnType(Type returnType) {
        Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (Object)"Return Type of member cannot be null!");
        this.returnType = returnType;
        return this.thisInstance();
    }

    public T setAccessModifier(AccessModifier modifier) {
        Preconditions.checkArgument((modifier != null ? 1 : 0) != 0, (Object)"Access Modifier for member type cannot be null!");
        this.accessModifier = modifier;
        return this.thisInstance();
    }

    public T setComment(String comment) {
        if (comment == null) {
            this.comment = "";
        }
        this.comment = comment;
        return this.thisInstance();
    }

    public T setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this.thisInstance();
    }

    public T setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this.thisInstance();
    }

    protected List<AnnotationType> toAnnotationTypes() {
        ArrayList<AnnotationType> annotations = new ArrayList<AnnotationType>();
        for (AnnotationTypeBuilder annotBuilder : this.getAnnotationBuilders()) {
            if (annotBuilder == null) continue;
            annotations.add(annotBuilder.toInstance());
        }
        return ImmutableList.copyOf(annotations);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTypeMemberBuilder other = (AbstractTypeMemberBuilder)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedPropertyImpl [name=");
        builder.append(this.getName());
        builder.append(", annotations=");
        builder.append(this.getAnnotationBuilders());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", isFinal=");
        builder.append(this.isFinal());
        builder.append(", modifier=");
        builder.append(this.getAccessModifier());
        builder.append("]");
        return builder.toString();
    }
}

