/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.AbstractBaseType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.Constant;
import org.opendaylight.yangtools.sal.binding.model.api.Enumeration;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

public final class EnumerationBuilderImpl
extends AbstractBaseType
implements EnumBuilder {
    private final String packageName;
    private final String name;
    private List<Enumeration.Pair> values = Collections.emptyList();
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private List<Enumeration.Pair> unmodifiableValues = Collections.emptyList();
    private String description;
    private String reference;
    private String moduleName;
    private Iterable<QName> schemaPath;

    public EnumerationBuilderImpl(String packageName, String name) {
        super(packageName, name);
        this.packageName = packageName;
        this.name = name;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setSchemaPath(Iterable<QName> schemaPath) {
        this.schemaPath = schemaPath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        AnnotationTypeBuilderImpl builder;
        if (packageName != null && name != null && !this.annotationBuilders.contains(builder = new AnnotationTypeBuilderImpl(packageName, name))) {
            this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
            return builder;
        }
        return null;
    }

    public void addValue(String name, Integer value, String description) {
        EnumPairImpl p = new EnumPairImpl(name, value, description);
        this.values = LazyCollections.lazyAdd(this.values, (Object)p);
        this.unmodifiableValues = Collections.unmodifiableList(this.values);
    }

    public Enumeration toInstance(Type definingType) {
        return new EnumerationImpl(definingType, this.annotationBuilders, this.packageName, this.name, this.unmodifiableValues, this.description, this.reference, this.moduleName, this.schemaPath);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnumerationBuilderImpl [packageName=");
        builder.append(this.packageName);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }

    public void updateEnumPairsFromEnumTypeDef(EnumTypeDefinition enumTypeDef) {
        List enums = enumTypeDef.getValues();
        if (enums != null) {
            int listIndex = 0;
            for (EnumTypeDefinition.EnumPair enumPair : enums) {
                if (enumPair == null) continue;
                String enumPairName = BindingMapping.getClassName((String)enumPair.getName());
                Integer enumPairValue = enumPair.getValue();
                if (enumPairValue == null) {
                    enumPairValue = listIndex;
                } else {
                    listIndex = enumPairValue;
                }
                this.addValue(enumPairName, enumPairValue, enumPair.getDescription());
                ++listIndex;
            }
        }
    }

    private static final class EnumerationImpl
    extends AbstractBaseType
    implements Enumeration {
        private final Type definingType;
        private final String description;
        private final String reference;
        private final String moduleName;
        private final Iterable<QName> schemaPath;
        private final List<Enumeration.Pair> values;
        private final List<AnnotationType> annotations;

        public EnumerationImpl(Type definingType, List<AnnotationTypeBuilder> annotationBuilders, String packageName, String name, List<Enumeration.Pair> values, String description, String reference, String moduleName, Iterable<QName> schemaPath) {
            super(packageName, name);
            this.definingType = definingType;
            this.values = values;
            this.description = description;
            this.moduleName = moduleName;
            this.schemaPath = schemaPath;
            this.reference = reference;
            ArrayList<AnnotationType> a = new ArrayList<AnnotationType>();
            for (AnnotationTypeBuilder builder : annotationBuilders) {
                a.add(builder.toInstance());
            }
            this.annotations = ImmutableList.copyOf(a);
        }

        public Type getParentType() {
            return this.definingType;
        }

        public List<Enumeration.Pair> getValues() {
            return this.values;
        }

        public List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        public String toFormattedString() {
            StringBuilder builder = new StringBuilder();
            builder.append("public enum");
            builder.append(" ");
            builder.append(this.getName());
            builder.append(" {");
            builder.append("\n");
            int i = 0;
            for (Enumeration.Pair valPair : this.values) {
                builder.append("\t");
                builder.append(" ");
                builder.append(valPair.getName());
                builder.append(" (");
                builder.append(valPair.getValue());
                if (i == this.values.size() - 1) {
                    builder.append(" );");
                } else {
                    builder.append(" ),");
                }
                ++i;
            }
            builder.append("\n}");
            return builder.toString();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Enumeration [packageName=");
            builder.append(this.getPackageName());
            if (this.definingType != null) {
                builder.append(", definingType=");
                builder.append(this.definingType.getPackageName());
                builder.append(".");
                builder.append(this.definingType.getName());
            } else {
                builder.append(", definingType= null");
            }
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }

        public String getComment() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public List<Type> getImplements() {
            return Collections.emptyList();
        }

        public List<GeneratedType> getEnclosedTypes() {
            return Collections.emptyList();
        }

        public List<Enumeration> getEnumerations() {
            return Collections.emptyList();
        }

        public List<Constant> getConstantDefinitions() {
            return Collections.emptyList();
        }

        public List<MethodSignature> getMethodDefinitions() {
            return Collections.emptyList();
        }

        public List<GeneratedProperty> getProperties() {
            return Collections.emptyList();
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Iterable<QName> getSchemaPath() {
            return this.schemaPath;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }

    private static final class EnumPairImpl
    implements Enumeration.Pair {
        private final String name;
        private final Integer value;
        private final String description;

        public EnumPairImpl(String name, Integer value, String description) {
            this.name = name;
            this.value = value;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnumPairImpl other = (EnumPairImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EnumPair [name=");
            builder.append(this.name);
            builder.append(", value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return null;
        }

        public Status getStatus() {
            return null;
        }
    }
}

