/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractGeneratedType;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.sal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.sal.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.sal.binding.model.api.Restrictions;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public final class GeneratedTOBuilderImpl
extends AbstractGeneratedTypeBuilder<GeneratedTOBuilder>
implements GeneratedTOBuilder {
    private GeneratedTransferObject extendsType;
    private List<GeneratedPropertyBuilder> equalsProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> hashProperties = Collections.emptyList();
    private List<GeneratedPropertyBuilder> toStringProperties = Collections.emptyList();
    private boolean isTypedef = false;
    private boolean isUnionType = false;
    private boolean isUnionTypeBuilder = false;
    private TypeDefinition<?> baseType = null;
    private Restrictions restrictions;
    private GeneratedPropertyBuilder SUID;
    private String reference;
    private String description;
    private String moduleName;
    private Iterable<QName> schemaPath;

    public GeneratedTOBuilderImpl(String packageName, String name) {
        super(packageName, name);
        this.setAbstract(false);
    }

    public GeneratedTOBuilder setExtendsType(GeneratedTransferObject genTransObj) {
        Preconditions.checkArgument((genTransObj != null ? 1 : 0) != 0, (Object)"Generated Transfer Object cannot be null!");
        this.extendsType = genTransObj;
        return this;
    }

    @Override
    public MethodSignatureBuilder addMethod(String name) {
        MethodSignatureBuilder builder = super.addMethod(name);
        builder.setAbstract(false);
        return builder;
    }

    public GeneratedTOBuilder addEqualsIdentity(GeneratedPropertyBuilder property) {
        this.equalsProperties = LazyCollections.lazyAdd(this.equalsProperties, (Object)property);
        return this;
    }

    public GeneratedTOBuilder addHashIdentity(GeneratedPropertyBuilder property) {
        this.hashProperties = LazyCollections.lazyAdd(this.hashProperties, (Object)property);
        return this;
    }

    public GeneratedTOBuilder addToStringProperty(GeneratedPropertyBuilder property) {
        this.toStringProperties = LazyCollections.lazyAdd(this.toStringProperties, (Object)property);
        return this;
    }

    @Override
    protected GeneratedTOBuilder thisInstance() {
        return this;
    }

    public void setRestrictions(Restrictions restrictions) {
        this.restrictions = restrictions;
    }

    public void setSUID(GeneratedPropertyBuilder suid) {
        this.SUID = suid;
    }

    public GeneratedTransferObject toInstance() {
        return new GeneratedTransferObjectImpl(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedTransferObject [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append(", constants=");
        builder.append(this.getConstants());
        builder.append(", enumerations=");
        builder.append(this.getEnumerations());
        builder.append(", equalsProperties=");
        builder.append(this.equalsProperties);
        builder.append(", hashCodeProperties=");
        builder.append(this.hashProperties);
        builder.append(", stringProperties=");
        builder.append(this.toStringProperties);
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append(", methods=");
        builder.append(this.getMethodDefinitions());
        builder.append("]");
        return builder.toString();
    }

    public void setTypedef(boolean isTypedef) {
        this.isTypedef = isTypedef;
    }

    public void setBaseType(TypeDefinition<?> typeDef) {
        this.baseType = typeDef;
    }

    public void setIsUnion(boolean isUnion) {
        this.isUnionType = isUnion;
    }

    public void setIsUnionBuilder(boolean isUnionTypeBuilder) {
        this.isUnionTypeBuilder = isUnionTypeBuilder;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setSchemaPath(Iterable<QName> schemaPath) {
        this.schemaPath = schemaPath;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    private static final class GeneratedTransferObjectImpl
    extends AbstractGeneratedType
    implements GeneratedTransferObject {
        private final List<GeneratedProperty> equalsProperties;
        private final List<GeneratedProperty> hashCodeProperties;
        private final List<GeneratedProperty> stringProperties;
        private final GeneratedTransferObject extendsType;
        private final boolean isTypedef;
        private final TypeDefinition<?> baseType;
        private final boolean isUnionType;
        private final boolean isUnionTypeBuilder;
        private final Restrictions restrictions;
        private final GeneratedProperty SUID;
        private final String reference;
        private final String description;
        private final String moduleName;
        private final Iterable<QName> schemaPath;

        public GeneratedTransferObjectImpl(GeneratedTOBuilderImpl builder) {
            super(builder);
            this.extendsType = builder.extendsType;
            this.equalsProperties = this.toUnmodifiableProperties(builder.equalsProperties);
            this.hashCodeProperties = this.toUnmodifiableProperties(builder.hashProperties);
            this.stringProperties = this.toUnmodifiableProperties(builder.toStringProperties);
            this.isTypedef = builder.isTypedef;
            this.baseType = builder.baseType;
            this.isUnionType = builder.isUnionType;
            this.isUnionTypeBuilder = builder.isUnionTypeBuilder;
            this.restrictions = builder.restrictions;
            this.reference = builder.reference;
            this.description = builder.description;
            this.moduleName = builder.moduleName;
            this.schemaPath = builder.schemaPath;
            this.SUID = builder.SUID == null ? null : builder.SUID.toInstance((Type)this);
        }

        public boolean isTypedef() {
            return this.isTypedef;
        }

        public TypeDefinition<?> getBaseType() {
            return this.baseType;
        }

        public boolean isUnionType() {
            return this.isUnionType;
        }

        public boolean isUnionTypeBuilder() {
            return this.isUnionTypeBuilder;
        }

        public GeneratedTransferObject getSuperType() {
            return this.extendsType;
        }

        public List<GeneratedProperty> getEqualsIdentifiers() {
            return this.equalsProperties;
        }

        public List<GeneratedProperty> getHashCodeIdentifiers() {
            return this.hashCodeProperties;
        }

        public List<GeneratedProperty> getToStringIdentifiers() {
            return this.stringProperties;
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }

        public GeneratedProperty getSUID() {
            return this.SUID;
        }

        @Override
        public String toString() {
            if (this.isTypedef) {
                return this.serializeTypedef(this);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("GeneratedTransferObject [packageName=");
            builder.append(this.getPackageName());
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", comment=");
            builder.append(", annotations=");
            builder.append(this.getAnnotations());
            builder.append(this.getComment());
            builder.append(", extends=");
            builder.append(this.getSuperType());
            builder.append(", implements=");
            builder.append(this.getImplements());
            builder.append(", enclosedTypes=");
            builder.append(this.getEnclosedTypes());
            builder.append(", constants=");
            builder.append(this.getConstantDefinitions());
            builder.append(", enumerations=");
            builder.append(this.getEnumerations());
            builder.append(", properties=");
            builder.append(this.getProperties());
            builder.append(", equalsProperties=");
            builder.append(this.equalsProperties);
            builder.append(", hashCodeProperties=");
            builder.append(this.hashCodeProperties);
            builder.append(", stringProperties=");
            builder.append(this.stringProperties);
            builder.append(", methods=");
            builder.append(this.getMethodDefinitions());
            builder.append("]");
            return builder.toString();
        }

        public String serializeTypedef(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                StringBuilder sb = new StringBuilder();
                sb.append(parameterizedType.getRawType().getFullyQualifiedName());
                sb.append('<');
                boolean first = true;
                for (Type parameter : parameterizedType.getActualTypeArguments()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(this.serializeTypedef(parameter));
                }
                sb.append('>');
                return sb.toString();
            }
            return type.getFullyQualifiedName();
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Iterable<QName> getSchemaPath() {
            return this.schemaPath;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }
}

