/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractTypeMemberBuilder;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.MethodParameterImpl;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.MethodSignatureImpl;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.sal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.util.LazyCollections;

final class MethodSignatureBuilderImpl
extends AbstractTypeMemberBuilder<MethodSignatureBuilder>
implements MethodSignatureBuilder {
    private List<MethodSignature.Parameter> parameters = Collections.emptyList();
    private List<MethodSignature.Parameter> unmodifiableParams = Collections.emptyList();
    private boolean isAbstract;

    public MethodSignatureBuilderImpl(String name) {
        super(name);
    }

    public MethodSignatureBuilder setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public MethodSignatureBuilder addParameter(Type type, String name) {
        this.parameters = LazyCollections.lazyAdd(this.parameters, (Object)new MethodParameterImpl(name, type));
        this.unmodifiableParams = Collections.unmodifiableList(this.parameters);
        return this;
    }

    @Override
    protected MethodSignatureBuilder thisInstance() {
        return this;
    }

    public MethodSignature toInstance(Type definingType) {
        List<AnnotationType> annotations = this.toAnnotationTypes();
        return new MethodSignatureImpl(definingType, this.getName(), annotations, this.getComment(), this.getAccessModifier(), this.getReturnType(), this.unmodifiableParams, this.isFinal(), this.isAbstract, this.isStatic());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureBuilderImpl other = (MethodSignatureBuilderImpl)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodSignatureBuilderImpl [name=");
        builder.append(this.getName());
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", annotationBuilders=");
        builder.append(this.getAnnotationBuilders());
        builder.append(", comment=");
        builder.append(this.getComment());
        builder.append("]");
        return builder.toString();
    }
}

