/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.util.generated.type.builder;

import java.util.List;
import org.opendaylight.yangtools.binding.generator.util.generated.type.builder.AbstractTypeMember;
import org.opendaylight.yangtools.sal.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.sal.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.sal.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

class MethodSignatureImpl
extends AbstractTypeMember
implements MethodSignature {
    private final List<MethodSignature.Parameter> params;
    private final boolean isAbstract;

    public MethodSignatureImpl(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic) {
        super(definingType, name, annotations, comment, accessModifier, returnType, isFinal, isStatic);
        this.params = params;
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public List<MethodSignature.Parameter> getParameters() {
        return this.params;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.getReturnType() == null ? 0 : this.getReturnType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureImpl other = (MethodSignatureImpl)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.getReturnType() == null ? other.getReturnType() != null : !this.getReturnType().equals(other.getReturnType()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MethodSignatureImpl [name=");
        builder.append(this.getName());
        builder.append(", comment=");
        builder.append(this.getComment());
        if (this.getDefiningType() != null) {
            builder.append(", definingType=");
            builder.append(this.getDefiningType().getPackageName());
            builder.append(".");
            builder.append(this.getDefiningType().getName());
        } else {
            builder.append(", definingType= null");
        }
        builder.append(", returnType=");
        builder.append(this.getReturnType());
        builder.append(", params=");
        builder.append(this.params);
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append("]");
        return builder.toString();
    }
}

