/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.osgi;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Uint64;

@Beta
@NonNullByDefault
public interface ModelGenerationAware<S>
extends Immutable {
    public Uint64 generation();

    public @NonNull S service();

    default public int getServiceRanking() {
        return ModelGenerationAware.computeServiceRanking(this.generation().longValue());
    }

    public static int computeServiceRanking(long generation) {
        return generation >= 0L && generation <= Integer.MAX_VALUE ? (int)generation : Integer.MAX_VALUE;
    }
}

