/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BindingObject;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.YangFeature;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yangtools.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.spi.ModuleInfoSnapshotResolver;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;

@Beta
public final class ModuleInfoSnapshotBuilder {
    private final SetMultimap<Class<? extends DataRoot<?>>, YangFeature<?, ?>> moduleFeatures = HashMultimap.create();
    private final Set<YangModuleInfo> moduleInfos = new HashSet<YangModuleInfo>();
    private final YangParserFactory parserFactory;

    public ModuleInfoSnapshotBuilder(YangParserFactory parserFactory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> clazz) {
        YangModuleInfo moduleInfo;
        try {
            moduleInfo = BindingRuntimeHelpers.getYangModuleInfo(clazz);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to introspect " + String.valueOf(clazz), e);
        }
        return this.add(moduleInfo);
    }

    @SafeVarargs
    public final @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> ... classes) {
        for (Class<? extends BindingObject> clazz : classes) {
            this.add(clazz);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo info) {
        ModuleInfoSnapshotResolver.flatDependencies(this.moduleInfos, info);
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo ... infos) {
        for (YangModuleInfo info : infos) {
            this.add(info);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Iterable<? extends YangModuleInfo> infos) {
        for (YangModuleInfo yangModuleInfo : infos) {
            this.add(yangModuleInfo);
        }
        return this;
    }

    public <R extends DataRoot<R>> @NonNull ModuleInfoSnapshotBuilder addModuleFeatures(Class<R> module, Set<? extends YangFeature<?, R>> supportedFeatures) {
        this.moduleFeatures.putAll(Objects.requireNonNull(module), (Iterable)ImmutableList.copyOf(supportedFeatures));
        return this;
    }

    public @NonNull ModuleInfoSnapshot build() throws YangParserException {
        YangParser parser = this.parserFactory.createParser();
        HashMap<SourceIdentifier, YangModuleInfo> mappedInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        HashMap<String, QNameModule> namespaces = new HashMap<String, QNameModule>();
        for (YangModuleInfo info : this.moduleInfos) {
            YangTextSource source = ModuleInfoSnapshotResolver.toYangTextSource(info);
            mappedInfos.put(source.sourceId(), info);
            String infoRoot = Naming.getRootPackageName((QNameModule)info.getName().getModule());
            classLoaders.put(infoRoot, info.getClass().getClassLoader());
            namespaces.put(infoRoot, info.getName().getModule());
            try {
                parser.addSource((SourceRepresentation)source);
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new YangParserException("Failed to add source for " + String.valueOf(info), e);
            }
        }
        if (!this.moduleFeatures.isEmpty()) {
            FeatureSet.Builder featuresByModule = FeatureSet.builder();
            for (Map.Entry entry : Multimaps.asMap(this.moduleFeatures).entrySet()) {
                Class moduleData = (Class)entry.getKey();
                String moduleRoot = Naming.getModelRootPackageName((String)moduleData.getPackage().getName());
                QNameModule moduleNamespace = (QNameModule)namespaces.get(moduleRoot);
                if (moduleNamespace == null) {
                    throw new YangParserException("Failed to resolve namespace of " + String.valueOf(moduleData));
                }
                featuresByModule.addModuleFeatures(moduleNamespace, (Collection)((Set)entry.getValue()).stream().map(YangFeature::qname).map(AbstractQName::getLocalName).sorted().collect(ImmutableSet.toImmutableSet()));
            }
            parser.setSupportedFeatures(featuresByModule.build());
        }
        return new DefaultModuleInfoSnapshot(parser.buildEffectiveModel(), mappedInfos, classLoaders);
    }
}

