/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.objcache.spi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableSoftReference;
import com.google.common.cache.Cache;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.ProductAwareBuilder;
import org.opendaylight.yangtools.objcache.ObjectCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectCache
implements ObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractObjectCache.class);
    private final FinalizableReferenceQueue queue;
    private final Cache<SoftKey<?>, Object> cache;

    protected AbstractObjectCache(Cache<SoftKey<?>, Object> cache, FinalizableReferenceQueue queue) {
        this.queue = Objects.requireNonNull(queue);
        this.cache = Objects.requireNonNull(cache);
    }

    protected <T> SoftKey<T> createSoftKey(T object) {
        return new SoftKey<T>(object, this.queue){

            public void finalizeReferent() {
                LOG.trace("Invalidating key {}", (Object)this);
                AbstractObjectCache.this.cache.invalidate((Object)this);
            }
        };
    }

    @Override
    public final <B extends ProductAwareBuilder<P>, P> P getProduct(@Nonnull B builder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final <T> T getReference(T object) {
        LOG.debug("Looking up reference for {}", object);
        if (object == null) {
            return null;
        }
        SoftKey<T> key = this.createSoftKey(object);
        try {
            return (T)this.cache.get(key, () -> object);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load value", e);
        }
    }

    protected static abstract class SoftKey<T>
    extends FinalizableSoftReference<T> {
        private final int hashCode;

        public SoftKey(T referent, FinalizableReferenceQueue queue) {
            super(Objects.requireNonNull(referent), queue);
            this.hashCode = referent.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this == obj || obj.equals(this.get());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @VisibleForTesting
    static final class BuilderKey {
        private final ProductAwareBuilder<?> builder;

        private BuilderKey(ProductAwareBuilder<?> builder) {
            this.builder = Objects.requireNonNull(builder);
        }

        public int hashCode() {
            return this.builder.productHashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SoftKey) {
                obj = ((SoftKey)((Object)obj)).get();
            }
            return this.builder.productEquals(obj);
        }
    }
}

