/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.objcache;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.yangtools.objcache.ObjectCache;
import org.opendaylight.yangtools.objcache.impl.StaticObjectCacheBinder;
import org.opendaylight.yangtools.objcache.spi.IObjectCacheFactory;
import org.opendaylight.yangtools.objcache.spi.NoopObjectCacheBinder;

public final class ObjectCacheFactory {
    private static volatile IObjectCacheFactory factory;

    private ObjectCacheFactory() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    @GuardedBy(value="this")
    private static synchronized IObjectCacheFactory initialize() {
        IObjectCacheFactory fa = factory;
        if (fa != null) {
            return fa;
        }
        try {
            factory = fa = StaticObjectCacheBinder.getInstance().getProductCacheFactory();
        }
        catch (NoClassDefFoundError e) {
            fa = NoopObjectCacheBinder.INSTANCE.getProductCacheFactory();
        }
        return fa;
    }

    public static synchronized void reset() {
        factory = null;
    }

    public static ObjectCache getObjectCache(@Nonnull Class<?> objClass) {
        IObjectCacheFactory fa = factory;
        if (fa == null) {
            fa = ObjectCacheFactory.initialize();
        }
        return fa.getObjectCache(Objects.requireNonNull(objClass));
    }
}

