/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.model.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc6643.model.api.AliasEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.AliasStatement;
import org.opendaylight.yangtools.rfc6643.model.api.DefValEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.DefValStatement;
import org.opendaylight.yangtools.rfc6643.model.api.DisplayHintEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.DisplayHintStatement;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2Constants;
import org.opendaylight.yangtools.rfc6643.model.api.ImpliedEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.ImpliedStatement;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessStatement;
import org.opendaylight.yangtools.rfc6643.model.api.OidEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.OidStatement;
import org.opendaylight.yangtools.rfc6643.model.api.SubIdEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.SubIdStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@Beta
public enum IetfYangSmiv2ExtensionsMapping implements StatementDefinition
{
    DISPLAY_HINT(DisplayHintStatement.class, DisplayHintEffectiveStatement.class, "display-hint", "format"),
    MAX_ACCESS(MaxAccessStatement.class, MaxAccessEffectiveStatement.class, "max-access", "access"),
    DEFVAL(DefValStatement.class, DefValEffectiveStatement.class, "defval", "value"),
    IMPLIED(ImpliedStatement.class, ImpliedEffectiveStatement.class, "implied", "index"),
    SUB_ID(SubIdStatement.class, SubIdEffectiveStatement.class, "subid", "value"),
    OBJECT_ID(OidStatement.class, OidEffectiveStatement.class, "oid", "value"),
    ALIAS(AliasStatement.class, AliasEffectiveStatement.class, "alias", "descriptor");

    private final @NonNull Class<? extends DeclaredStatement<?>> type;
    private final @NonNull Class<? extends EffectiveStatement<?, ?>> effectiveType;
    private final @NonNull QName name;
    private final @NonNull ArgumentDefinition argument;

    private IetfYangSmiv2ExtensionsMapping(Class<? extends DeclaredStatement<?>> declared, Class<? extends EffectiveStatement<?, ?>> effective, String nameStr, String argumentStr) {
        this.type = Objects.requireNonNull(declared);
        this.effectiveType = Objects.requireNonNull(effective);
        this.name = IetfYangSmiv2ExtensionsMapping.createQName(nameStr);
        this.argument = ArgumentDefinition.of((QName)IetfYangSmiv2ExtensionsMapping.createQName(argumentStr), (boolean)false);
    }

    private static @NonNull QName createQName(String localName) {
        return QName.create((QNameModule)IetfYangSmiv2Constants.RFC6643_MODULE, (String)localName).intern();
    }

    public QName getStatementName() {
        return this.name;
    }

    public Optional<ArgumentDefinition> getArgumentDefinition() {
        return Optional.of(this.argument);
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.type;
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveType;
    }
}

