/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadataStreamWriter;
import org.opendaylight.yangtools.rfc7952.data.util.ImmutableNormalizedMetadata;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public final class ImmutableNormalizedMetadataStreamWriter
implements NormalizedMetadataStreamWriter {
    private final Deque<ImmutableNormalizedMetadata.Builder> builders = new ArrayDeque<ImmutableNormalizedMetadata.Builder>();
    private ImmutableNormalizedMetadata result;

    public void enter(YangInstanceIdentifier.PathArgument identifier) {
        this.checkNotDone();
        this.builders.push(ImmutableNormalizedMetadata.builder().withIdentifier(identifier));
    }

    public void exit() {
        this.checkNotDone();
        ImmutableNormalizedMetadata metadata = this.builders.pop().build();
        ImmutableNormalizedMetadata.Builder parent = this.builders.peek();
        if (parent != null) {
            if (!metadata.getAnnotations().isEmpty()) {
                parent.withChild(metadata);
            }
        } else {
            this.result = metadata;
        }
    }

    public Optional<NormalizedMetadata> getResult() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Metadata tree has not been completely built");
        return this.result.getAnnotations().isEmpty() ? Optional.empty() : Optional.of(this.result);
    }

    public void metadata(ImmutableMap<QName, Object> metadata) throws IOException {
        this.builders.peek().withAnnotations((Map<QName, Object>)metadata);
    }

    private void checkNotDone() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Metadata already completed");
    }
}

