/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadataStreamWriter;
import org.opendaylight.yangtools.rfc7952.data.util.NormalizedNodeStreamWriterMetadataDecorator;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;

@Beta
public final class NormalizedMetadataWriter
implements Closeable,
Flushable {
    private final NormalizedNodeStreamWriter writer;
    private final boolean orderKeyLeaves;

    private NormalizedMetadataWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        this.writer = Objects.requireNonNull(writer);
        this.orderKeyLeaves = orderKeyLeaves;
    }

    public static @NonNull NormalizedMetadataWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        return new NormalizedMetadataWriter(writer, orderKeyLeaves);
    }

    public static @NonNull NormalizedMetadataWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        return NormalizedMetadataWriter.forStreamWriter(writer, true);
    }

    public @NonNull NormalizedMetadataWriter write(NormalizedNode<?, ?> data, NormalizedMetadata metadata) throws IOException {
        YangInstanceIdentifier.PathArgument dataId = data.getIdentifier();
        YangInstanceIdentifier.PathArgument metaId = (YangInstanceIdentifier.PathArgument)metadata.getIdentifier();
        Preconditions.checkArgument((boolean)dataId.equals(metaId), (String)"Mismatched data %s and metadata %s", (Object)dataId, (Object)metaId);
        NormalizedMetadataStreamWriter metaWriter = (NormalizedMetadataStreamWriter)this.writer.getExtensions().getInstance(NormalizedMetadataStreamWriter.class);
        Object delegate = metaWriter == null ? this.writer : new NormalizedNodeStreamWriterMetadataDecorator(this.writer, metaWriter, metadata);
        NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)delegate, (boolean)this.orderKeyLeaves);
        nnWriter.write(data);
        nnWriter.flush();
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.flush();
        }
        finally {
            this.writer.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

