/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.data.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadata;
import org.opendaylight.yangtools.rfc7952.data.api.NormalizedMetadataStreamWriter;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ForwardingNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;

final class NormalizedNodeStreamWriterMetadataDecorator
extends ForwardingNormalizedNodeStreamWriter {
    private final Deque<NormalizedMetadata> stack = new ArrayDeque<NormalizedMetadata>();
    private final NormalizedMetadataStreamWriter metaWriter;
    private final NormalizedNodeStreamWriter writer;
    private final NormalizedMetadata metadata;
    private int absentDepth = 0;

    NormalizedNodeStreamWriterMetadataDecorator(NormalizedNodeStreamWriter writer, NormalizedMetadataStreamWriter metaWriter, NormalizedMetadata metadata) {
        this.writer = Objects.requireNonNull(writer);
        this.metaWriter = Objects.requireNonNull(metaWriter);
        this.metadata = Objects.requireNonNull(metadata);
    }

    protected NormalizedNodeStreamWriter delegate() {
        return this.writer;
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        super.startLeafNode(name);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startLeafSet(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedLeafSet(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        super.startLeafSetEntryNode(name);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startContainerNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedList(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startUnkeyedListItem(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startMapNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        super.startMapEntryNode(identifier, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)identifier);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startOrderedMapNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startChoiceNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        super.startAugmentationNode(identifier);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)identifier);
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        super.startAnyxmlNode(name);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        super.startYangModeledAnyXmlNode(name, childSizeHint);
        this.enterMetadataNode((YangInstanceIdentifier.PathArgument)name);
    }

    public void endNode() throws IOException {
        super.endNode();
        if (this.absentDepth > 0) {
            --this.absentDepth;
        } else {
            this.stack.pop();
        }
    }

    private void enterMetadataNode(YangInstanceIdentifier.PathArgument name) throws IOException {
        if (this.absentDepth > 0) {
            ++this.absentDepth;
            return;
        }
        NormalizedMetadata current = this.stack.peek();
        if (current != null) {
            NormalizedMetadata child = (NormalizedMetadata)current.getChildren().get(name);
            if (child != null) {
                this.enterChild(child);
            } else {
                this.absentDepth = 1;
            }
        } else {
            this.enterChild(this.metadata);
        }
    }

    private void enterChild(NormalizedMetadata child) throws IOException {
        Map annotations = child.getAnnotations();
        if (!annotations.isEmpty()) {
            this.metaWriter.metadata(ImmutableMap.copyOf((Map)annotations));
        }
        this.stack.push(child);
    }
}

