/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

@Beta
public interface AnnotationSchemaNode
extends UnknownSchemaNode,
TypeAware {
    public static Optional<AnnotationSchemaNode> find(SchemaContext context, QName qname) {
        return context.findModule(qname.getModule()).flatMap(module -> module.getUnknownSchemaNodes().stream().filter(AnnotationSchemaNode.class::isInstance).map(AnnotationSchemaNode.class::cast).filter(annotation -> qname.equals((Object)annotation.getQName())).findAny());
    }

    public static Map<QName, AnnotationSchemaNode> findAll(SchemaContext context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Module module : context.getModules()) {
            for (UnknownSchemaNode node : module.getUnknownSchemaNodes()) {
                if (!(node instanceof AnnotationSchemaNode)) continue;
                AnnotationSchemaNode annotation = (AnnotationSchemaNode)node;
                builder.put((Object)annotation.getQName(), (Object)annotation);
            }
        }
        return builder.build();
    }
}

