/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.parser;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationStatement;
import org.opendaylight.yangtools.rfc7952.model.api.MetadataStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsStatement;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class AnnotationStatementSupport
extends AbstractStatementSupport<QName, AnnotationStatement, AnnotationEffectiveStatement> {
    private static final AnnotationStatementSupport INSTANCE = new AnnotationStatementSupport((StatementDefinition)MetadataStatements.ANNOTATION);
    private final SubstatementValidator validator;

    AnnotationStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addMandatory((StatementDefinition)YangStmtMapping.TYPE).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.IF_FEATURE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).addOptional((StatementDefinition)YangStmtMapping.UNITS).build();
    }

    public static AnnotationStatementSupport getInstance() {
        return INSTANCE;
    }

    public AnnotationStatement createDeclared(StmtContext<QName, AnnotationStatement, ?> ctx) {
        return new Declared(ctx);
    }

    public AnnotationEffectiveStatement createEffective(StmtContext<QName, AnnotationStatement, AnnotationEffectiveStatement> ctx) {
        return new Effective(ctx);
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public void onStatementAdded(StmtContext.Mutable<QName, AnnotationStatement, AnnotationEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().getPublicDefinition();
        SourceException.throwIf((YangStmtMapping.MODULE != parentDef && YangStmtMapping.SUBMODULE != parentDef ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Annotations may only be defined at root of either a module or a submodule", (Object[])new Object[0]);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<QName, AnnotationStatement>
    implements AnnotationEffectiveStatement,
    AnnotationSchemaNode {
        private final @NonNull TypeDefinition<?> type;
        private final @NonNull SchemaPath path;

        Effective(StmtContext<QName, AnnotationStatement, ?> ctx) {
            super(ctx);
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild((QName)this.argument());
            TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)this.firstSubstatementOfType(TypeEffectiveStatement.class), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"AnnotationStatementSupport %s is missing a 'type' statement", (Object[])new Object[]{this.argument()});
            ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (SchemaPath)this.path);
            StmtContext unitsStmt = StmtContextUtils.findFirstEffectiveSubstatement(ctx, UnitsStatement.class);
            if (unitsStmt != null) {
                builder.setUnits((String)unitsStmt.getStatementArgument());
            }
            this.type = builder.build();
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        public SchemaPath getPath() {
            return this.path;
        }

        public TypeDefinition<?> getType() {
            return this.type;
        }

        public TypeDefinition<?> getTypeDefinition() {
            return this.type;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement<QName>
    implements AnnotationStatement {
        Declared(StmtContext<QName, ?, ?> context) {
            super(context);
        }

        public QName getArgument() {
            return (QName)this.argument();
        }
    }
}

