/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.parser;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaNodeDefaults;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.ri.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.ConcreteTypes;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SchemaPathSupport;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

final class AnnotationEffectiveStatementImpl
extends UnknownEffectiveStatementBase<QName, AnnotationStatement>
implements AnnotationEffectiveStatement,
AnnotationSchemaNode {
    private final @NonNull TypeDefinition<?> type;
    private final @Nullable SchemaPath path;

    AnnotationEffectiveStatementImpl(EffectiveStmtCtx.Current<QName, AnnotationStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        super(stmt, substatements);
        QName qname = (QName)stmt.getArgument();
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)SourceException.throwIfNull((Object)((TypeEffectiveStatement)this.firstSubstatementOfType(TypeEffectiveStatement.class)), stmt, (String)"AnnotationStatementSupport %s is missing a 'type' statement", (Object[])new Object[]{qname});
        ConcreteTypeBuilder builder = ConcreteTypes.concreteTypeBuilder((TypeDefinition)typeStmt.getTypeDefinition(), (QName)qname);
        UnitsEffectiveStatement unitsStmt = (UnitsEffectiveStatement)this.firstSubstatementOfType(UnitsEffectiveStatement.class);
        if (unitsStmt != null) {
            builder.setUnits((String)unitsStmt.argument());
        }
        this.type = builder.build();
        this.path = SchemaPathSupport.toOptionalPath((SchemaPath)stmt.getEffectiveParent().getSchemaPath().createChild(qname));
    }

    public QName getQName() {
        return (QName)Verify.verifyNotNull((Object)((QName)this.argument()));
    }

    @Deprecated
    public SchemaPath getPath() {
        return SchemaNodeDefaults.throwUnsupportedIfNull((Object)((Object)this), (SchemaPath)this.path);
    }

    public TypeDefinition<?> getType() {
        return this.type;
    }

    public TypeDefinition<?> getTypeDefinition() {
        return this.type;
    }

    public AnnotationEffectiveStatement asEffectiveStatement() {
        return this;
    }
}

