/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;

@Beta
final class YangDataEffectiveStatementImpl
extends UnknownEffectiveStatementBase<String, YangDataStatement>
implements YangDataEffectiveStatement {
    private final @NonNull SchemaPath path;
    private final @NonNull QName maybeQNameArgument;
    private final @NonNull ContainerEffectiveStatement container;

    YangDataEffectiveStatementImpl(StmtContext<String, YangDataStatement, ?> ctx) {
        super(ctx);
        QName maybeQNameArgumentInit;
        try {
            maybeQNameArgumentInit = StmtContextUtils.parseIdentifier(ctx, (String)((String)this.argument()));
        }
        catch (IllegalArgumentException e) {
            maybeQNameArgumentInit = this.getNodeType();
        }
        this.maybeQNameArgument = maybeQNameArgumentInit;
        this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild(this.maybeQNameArgument);
        this.container = (ContainerEffectiveStatement)this.findFirstEffectiveSubstatement(ContainerEffectiveStatement.class).get();
        Verify.verify((boolean)(this.container instanceof ContainerSchemaNode));
    }

    public @NonNull QName getQName() {
        return this.maybeQNameArgument;
    }

    public @NonNull SchemaPath getPath() {
        return this.path;
    }

    public ContainerEffectiveStatement getContainer() {
        return this.container;
    }

    public @NonNull ContainerSchemaNode getContainerSchemaNode() {
        return (ContainerSchemaNode)this.container;
    }

    public int hashCode() {
        return Objects.hash(this.maybeQNameArgument, this.path);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangDataEffectiveStatementImpl)) {
            return false;
        }
        YangDataEffectiveStatementImpl other = (YangDataEffectiveStatementImpl)((Object)obj);
        return Objects.equals(this.maybeQNameArgument, other.maybeQNameArgument) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("qname", (Object)this.maybeQNameArgument).add("path", (Object)this.path).add("container", (Object)this.container).toString();
    }
}

