/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNodeDefaults;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.SchemaPathSupport;

@Beta
final class YangDataEffectiveStatementImpl
extends UnknownEffectiveStatementBase<String, YangDataStatement>
implements YangDataEffectiveStatement,
YangDataSchemaNode {
    private final @Nullable SchemaPath path;
    private final @NonNull QName argumentQName;
    private final @NonNull ContainerEffectiveStatement container;

    YangDataEffectiveStatementImpl(EffectiveStmtCtx.Current<String, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, QName qname) {
        super(stmt, substatements);
        this.argumentQName = Objects.requireNonNull(qname);
        this.path = SchemaPathSupport.toOptionalPath((SchemaPath)stmt.getEffectiveParent().getSchemaPath().createChild(qname));
        this.container = (ContainerEffectiveStatement)this.findFirstEffectiveSubstatement(ContainerEffectiveStatement.class).get();
        Verify.verify((boolean)(this.container instanceof ContainerSchemaNode));
    }

    public QName getQName() {
        return this.argumentQName;
    }

    @Deprecated
    public SchemaPath getPath() {
        return SchemaNodeDefaults.throwUnsupportedIfNull((Object)((Object)this), (SchemaPath)this.path);
    }

    public ContainerEffectiveStatement getContainer() {
        return this.container;
    }

    public ContainerSchemaNode getContainerSchemaNode() {
        return (ContainerSchemaNode)this.container;
    }

    public YangDataEffectiveStatement asEffectiveStatement() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("qname", (Object)this.argumentQName).add("path", (Object)this.path).add("container", (Object)this.container).toString();
    }
}

