/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatements;
import org.opendaylight.yangtools.rfc8040.parser.RefYangDataStatement;
import org.opendaylight.yangtools.rfc8040.parser.YangDataArgumentNamespace;
import org.opendaylight.yangtools.rfc8040.parser.YangDataEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8040.parser.YangDataStatementImpl;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStringStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.InvalidSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.MissingSubstatementException;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class YangDataStatementSupport
extends AbstractStringStatementSupport<YangDataStatement, YangDataEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangDataStatements.YANG_DATA).addMandatory((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.USES).build();

    public YangDataStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangDataStatements.YANG_DATA, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public void onStatementAdded(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        if (ctx.coerceParentContext().getParentContext() != null) {
            ctx.setIsSupportedToBuildEffective(false);
        }
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        String argument = (String)SourceException.throwIfNull((Object)((String)ctx.argument()), ctx, (String)"yang-data requires an argument", (Object[])new Object[0]);
        QName qname = StmtContextUtils.parseIdentifier(ctx, (String)argument);
        ctx.addToNs(YangDataArgumentNamespace.class, (Object)Empty.value(), (Object)qname);
    }

    public boolean isIgnoringIfFeatures() {
        return true;
    }

    public boolean isIgnoringConfig() {
        return true;
    }

    protected YangDataStatement createDeclared(@NonNull StmtContext<String, YangDataStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new YangDataStatementImpl(ctx.getRawArgument(), substatements);
    }

    protected YangDataStatement attachDeclarationReference(YangDataStatement stmt, DeclarationReference reference) {
        return new RefYangDataStatement(stmt, reference);
    }

    protected YangDataEffectiveStatement createEffective(EffectiveStmtCtx.Current<String, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        long dataDefs = substatements.stream().filter(DataTreeEffectiveStatement.class::isInstance).count();
        if (dataDefs == 0L) {
            throw new MissingSubstatementException("yang-data requires exactly one container", stmt.sourceReference());
        }
        if (dataDefs > 1L) {
            throw new InvalidSubstatementException(stmt, "yang-data requires exactly one data definition node, found %s", new Object[]{dataDefs});
        }
        return new YangDataEffectiveStatementImpl(stmt, substatements, (QName)Verify.verifyNotNull((Object)((QName)stmt.namespaceItem(YangDataArgumentNamespace.class, (Object)Empty.value()))));
    }
}

