/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataSchemaNode;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.model.spi.meta.AbstractEffectiveUnknownSchmemaNode;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;

@Beta
final class YangDataEffectiveStatementImpl
extends AbstractEffectiveUnknownSchmemaNode<String, YangDataStatement>
implements YangDataEffectiveStatement,
YangDataSchemaNode {
    private final @NonNull QName argumentQName;
    private final @NonNull ContainerEffectiveStatement container;

    YangDataEffectiveStatementImpl(EffectiveStmtCtx.Current<String, YangDataStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, QName qname) {
        super((UnknownStatement)((YangDataStatement)stmt.declared()), (Object)((String)stmt.argument()), (CopyableNode)stmt.history(), substatements);
        this.argumentQName = Objects.requireNonNull(qname);
        this.container = (ContainerEffectiveStatement)this.findFirstEffectiveSubstatement(ContainerEffectiveStatement.class).get();
        Verify.verify((boolean)(this.container instanceof ContainerSchemaNode), (String)"Incompatible container %s", (Object)this.container);
    }

    public QName getQName() {
        return this.argumentQName;
    }

    public ContainerEffectiveStatement getContainer() {
        return this.container;
    }

    public ContainerSchemaNode getContainerSchemaNode() {
        return (ContainerSchemaNode)this.container;
    }

    public YangDataEffectiveStatement asEffectiveStatement() {
        return this;
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> Optional<? extends Map<K, V>> getNamespaceContents(Class<N> namespace) {
        if (SchemaTreeAwareEffectiveStatement.SchemaTreeNamespace.class.equals(namespace) || DataTreeAwareEffectiveStatement.DataTreeNamespace.class.equals(namespace)) {
            Map<QName, ContainerEffectiveStatement> ns = Map.of((QName)this.container.argument(), this.container);
            return Optional.of(ns);
        }
        return super.getNamespaceContents(namespace);
    }
}

