/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rcf8528.data.util;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.rcf8528.data.util.EmptyMountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointChild;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.YangLibraryConstants;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractDynamicMountPointContextFactory
extends AbstractIdentifiable<MountPointIdentifier>
implements MountPointContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDynamicMountPointContextFactory.class);

    protected AbstractDynamicMountPointContextFactory(@NonNull MountPointIdentifier mountId) {
        super((Object)mountId);
    }

    public final MountPointContext createContext(Map<YangLibraryConstants.ContainerName, MountPointChild> libraryContainers, MountPointChild schemaMounts) throws YangParserException {
        for (Map.Entry<YangLibraryConstants.ContainerName, MountPointChild> entry : libraryContainers.entrySet()) {
            NormalizedNode mountData;
            NormalizedNode libData;
            Optional<SchemaContext> optLibContext = this.findSchemaForLibrary(entry.getKey());
            if (!optLibContext.isPresent()) {
                LOG.debug("YANG Library context for mount point {} container {} not found", this.getIdentifier(), (Object)entry.getKey());
                continue;
            }
            try {
                libData = entry.getValue().normalizeTo(optLibContext.get());
            }
            catch (IOException e) {
                throw new YangParserException("Failed to interpret yang-library data", (Throwable)e);
            }
            if (!(libData instanceof ContainerNode)) {
                throw new YangParserException("Invalid yang-library non-container " + libData);
            }
            SchemaContext schemaContext = this.bindLibrary(entry.getKey(), (ContainerNode)libData);
            if (schemaMounts == null) {
                return new EmptyMountPointContext(schemaContext);
            }
            try {
                mountData = schemaMounts.normalizeTo(schemaContext);
            }
            catch (IOException e) {
                throw new YangParserException("Failed to interpret schema-mount data", (Throwable)e);
            }
            if (!(mountData instanceof ContainerNode)) {
                throw new YangParserException("Invalid schema-mount non-container " + mountData);
            }
            return this.createMountPointContext(schemaContext, (ContainerNode)mountData);
        }
        throw new YangParserException("Failed to interpret " + libraryContainers);
    }

    protected abstract @NonNull MountPointContext createMountPointContext(@NonNull SchemaContext var1, @NonNull ContainerNode var2);

    protected abstract @NonNull SchemaContext bindLibrary(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangLibraryConstants.ContainerName var1, @NonNull ContainerNode var2) throws YangParserException;

    protected abstract Optional<SchemaContext> findSchemaForLibrary(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangLibraryConstants.ContainerName var1);
}

