/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.concepts.Codec;
import org.opendaylight.yangtools.yang.data.api.codec.BooleanCodec;
import org.opendaylight.yangtools.yang.data.api.codec.DecimalCodec;
import org.opendaylight.yangtools.yang.data.api.codec.Int16Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Int32Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Int64Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Int8Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Uint16Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Uint32Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Uint64Codec;
import org.opendaylight.yangtools.yang.data.api.codec.Uint8Codec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.QuotedJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.UnquotedJSONCodec;

abstract class AbstractJSONCodec<T>
implements JSONCodec<T> {
    private final Codec<String, T> codec;

    protected AbstractJSONCodec(Codec<String, T> codec) {
        this.codec = (Codec)Preconditions.checkNotNull(codec);
    }

    public static <T> JSONCodec<T> create(Codec<String, T> codec) {
        if (codec instanceof BooleanCodec || codec instanceof DecimalCodec || codec instanceof Int8Codec || codec instanceof Int16Codec || codec instanceof Int32Codec || codec instanceof Int64Codec || codec instanceof Uint8Codec || codec instanceof Uint16Codec || codec instanceof Uint32Codec || codec instanceof Uint64Codec) {
            return new UnquotedJSONCodec<T>(codec);
        }
        return new QuotedJSONCodec<T>(codec);
    }

    public final T deserialize(String input) {
        return (T)this.codec.deserialize((Object)input);
    }

    public final String serialize(T input) {
        return (String)this.codec.serialize(input);
    }
}

