/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

@Beta
abstract class AbstractNodeDataWithSchema {
    private final DataSchemaNode schema;

    protected AbstractNodeDataWithSchema(DataSchemaNode schema) {
        this.schema = (DataSchemaNode)Preconditions.checkNotNull((Object)schema);
    }

    public final DataSchemaNode getSchema() {
        return this.schema;
    }

    public abstract void write(NormalizedNodeStreamWriter var1) throws IOException;

    protected final YangInstanceIdentifier.NodeIdentifier provideNodeIdentifier() {
        return new YangInstanceIdentifier.NodeIdentifier(this.schema.getQName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeDataWithSchema other = (AbstractNodeDataWithSchema)obj;
        return this.schema.equals(other.schema);
    }
}

