/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.CaseNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.ChoiceNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.ContainerNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

class CompositeNodeDataWithSchema
extends AbstractNodeDataWithSchema {
    private static final Function<DataSchemaNode, QName> QNAME_FUNCTION = new Function<DataSchemaNode, QName>(){

        public QName apply(@Nonnull DataSchemaNode input) {
            return input.getQName();
        }
    };
    protected final Multimap<AugmentationSchema, AbstractNodeDataWithSchema> augmentationsToChild = ArrayListMultimap.create();
    protected final List<AbstractNodeDataWithSchema> children = new ArrayList<AbstractNodeDataWithSchema>();

    public CompositeNodeDataWithSchema(DataSchemaNode schema) {
        super(schema);
    }

    public AbstractNodeDataWithSchema addChild(Deque<DataSchemaNode> schemas) {
        Collection<AbstractNodeDataWithSchema> childNodes;
        CompositeNodeDataWithSchema caseNodeDataWithSchema;
        Preconditions.checkArgument((!schemas.isEmpty() ? 1 : 0) != 0, (Object)"Expecting at least one schema");
        DataSchemaNode schema = schemas.pop();
        if (schemas.isEmpty()) {
            return this.addChild(schema);
        }
        DataSchemaNode choiceCandidate = schema;
        Preconditions.checkArgument((boolean)(choiceCandidate instanceof ChoiceNode), (String)"Expected node of type ChoiceNode but was %s", (Object[])new Object[]{choiceCandidate.getClass().getSimpleName()});
        ChoiceNode choiceNode = (ChoiceNode)choiceCandidate;
        DataSchemaNode caseCandidate = schemas.pop();
        Preconditions.checkArgument((boolean)(caseCandidate instanceof ChoiceCaseNode), (String)"Expected node of type ChoiceCaseNode but was %s", (Object[])new Object[]{caseCandidate.getClass().getSimpleName()});
        ChoiceCaseNode caseNode = (ChoiceCaseNode)caseCandidate;
        AugmentationSchema augSchema = null;
        if (choiceCandidate.isAugmenting()) {
            augSchema = this.findCorrespondingAugment(this.getSchema(), choiceCandidate);
        }
        if ((caseNodeDataWithSchema = this.findChoice(childNodes = augSchema != null ? this.augmentationsToChild.get((Object)augSchema) : this.children, choiceCandidate, caseCandidate)) == null) {
            ChoiceNodeDataWithSchema choiceNodeDataWithSchema = new ChoiceNodeDataWithSchema(choiceNode);
            this.addChild(choiceNodeDataWithSchema);
            caseNodeDataWithSchema = choiceNodeDataWithSchema.addCompositeChild((DataSchemaNode)caseNode);
        }
        return caseNodeDataWithSchema.addChild(schemas);
    }

    private AbstractNodeDataWithSchema addSimpleChild(DataSchemaNode schema) {
        SimpleNodeDataWithSchema newChild = null;
        if (schema instanceof LeafSchemaNode) {
            newChild = new LeafNodeDataWithSchema(schema);
        } else if (schema instanceof AnyXmlSchemaNode) {
            newChild = new AnyXmlNodeDataWithSchema(schema);
        } else {
            return null;
        }
        AugmentationSchema augSchema = null;
        if (schema.isAugmenting()) {
            augSchema = this.findCorrespondingAugment(this.getSchema(), schema);
        }
        if (augSchema != null) {
            this.augmentationsToChild.put((Object)augSchema, (Object)newChild);
        } else {
            this.addChild(newChild);
        }
        return newChild;
    }

    private CaseNodeDataWithSchema findChoice(Collection<AbstractNodeDataWithSchema> childNodes, DataSchemaNode choiceCandidate, DataSchemaNode caseCandidate) {
        if (childNodes != null) {
            for (AbstractNodeDataWithSchema nodeDataWithSchema : childNodes) {
                if (!(nodeDataWithSchema instanceof ChoiceNodeDataWithSchema) || !nodeDataWithSchema.getSchema().getQName().equals((Object)choiceCandidate.getQName())) continue;
                CaseNodeDataWithSchema casePrevious = ((ChoiceNodeDataWithSchema)nodeDataWithSchema).getCase();
                Preconditions.checkArgument((boolean)casePrevious.getSchema().getQName().equals((Object)caseCandidate.getQName()), (String)"Data from case %s are specified but other data from case %s were specified erlier. Data aren't from the same case.", (Object[])new Object[]{caseCandidate.getQName(), casePrevious.getSchema().getQName()});
                return casePrevious;
            }
        }
        return null;
    }

    AbstractNodeDataWithSchema addCompositeChild(DataSchemaNode schema) {
        CompositeNodeDataWithSchema newChild = schema instanceof ListSchemaNode ? new ListNodeDataWithSchema(schema) : (schema instanceof LeafListSchemaNode ? new LeafListNodeDataWithSchema(schema) : (schema instanceof ContainerSchemaNode ? new ContainerNodeDataWithSchema(schema) : new CompositeNodeDataWithSchema(schema)));
        this.addCompositeChild(newChild);
        return newChild;
    }

    void addCompositeChild(CompositeNodeDataWithSchema newChild) {
        AugmentationSchema augSchema = this.findCorrespondingAugment(this.getSchema(), newChild.getSchema());
        if (augSchema != null) {
            this.augmentationsToChild.put((Object)augSchema, (Object)newChild);
        } else {
            this.addChild(newChild);
        }
    }

    private AbstractNodeDataWithSchema addChild(DataSchemaNode schema) {
        AbstractNodeDataWithSchema newChild = this.addSimpleChild(schema);
        return newChild == null ? this.addCompositeChild(schema) : newChild;
    }

    public void addChild(AbstractNodeDataWithSchema newChild) {
        this.children.add(newChild);
    }

    protected final int childSizeHint() {
        return this.children.size();
    }

    AugmentationSchema findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (parent instanceof AugmentationTarget && !(parent instanceof ChoiceCaseNode) && !(parent instanceof ChoiceNode)) {
            for (AugmentationSchema augmentation : ((AugmentationTarget)parent).getAvailableAugmentations()) {
                DataSchemaNode childInAugmentation = augmentation.getDataChildByName(child.getQName());
                if (childInAugmentation == null) continue;
                return augmentation;
            }
        }
        return null;
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer) throws IOException {
        for (AbstractNodeDataWithSchema abstractNodeDataWithSchema : this.children) {
            abstractNodeDataWithSchema.write(writer);
        }
        for (Map.Entry entry : this.augmentationsToChild.asMap().entrySet()) {
            Collection childsFromAgumentation = (Collection)entry.getValue();
            if (childsFromAgumentation.isEmpty()) continue;
            writer.startAugmentationNode(CompositeNodeDataWithSchema.toAugmentationIdentifier((AugmentationSchema)entry.getKey()));
            for (AbstractNodeDataWithSchema nodeDataWithSchema : childsFromAgumentation) {
                nodeDataWithSchema.write(writer);
            }
            writer.endNode();
        }
    }

    private static YangInstanceIdentifier.AugmentationIdentifier toAugmentationIdentifier(AugmentationSchema schema) {
        Collection qnames = Collections2.transform((Collection)schema.getChildNodes(), QNAME_FUNCTION);
        return new YangInstanceIdentifier.AugmentationIdentifier((Set)ImmutableSet.copyOf((Collection)qnames));
    }
}

