/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

abstract class JSONStreamWriterContext {
    private final JSONStreamWriterContext parent;
    private final boolean mandatory;
    private final int depth;
    private boolean emittedMyself = false;
    private boolean haveChild = false;

    protected JSONStreamWriterContext(JSONStreamWriterContext parent, boolean mandatory) {
        this.mandatory = mandatory;
        this.parent = parent;
        this.depth = parent != null ? parent.depth + 1 : 0;
    }

    final void writeChildJsonIdentifier(SchemaContext schema, Writer writer, QName qname) throws IOException {
        writer.append('\"');
        URI ns = qname.getNamespace();
        if (!ns.equals(this.getNamespace())) {
            Module module = schema.findModuleByNamespaceAndRevision(ns, null);
            Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Could not find module for namespace {}", (Object[])new Object[]{ns});
            writer.append(module.getName());
            writer.append(':');
        }
        writer.append(qname.getLocalName());
        writer.append("\":");
    }

    protected final void writeMyJsonIdentifier(SchemaContext schema, Writer writer, QName qname) throws IOException {
        this.parent.writeChildJsonIdentifier(schema, writer, qname);
    }

    @Nonnull
    protected abstract URI getNamespace();

    protected abstract void emitStart(SchemaContext var1, Writer var2) throws IOException;

    protected abstract void emitEnd(Writer var1) throws IOException;

    private final void emitMyself(SchemaContext schema, Writer writer, String indent) throws IOException {
        if (!this.emittedMyself) {
            if (this.parent != null) {
                this.parent.emittingChild(schema, writer, indent);
            }
            this.emitStart(schema, writer);
            this.emittedMyself = true;
        }
    }

    final void emittingChild(SchemaContext schema, Writer writer, String indent) throws IOException {
        this.emitMyself(schema, writer, indent);
        if (this.haveChild) {
            writer.append(',');
        }
        if (indent != null) {
            writer.append('\n');
            for (int i = 0; i < this.depth; ++i) {
                writer.append(indent);
            }
        }
        this.haveChild = true;
    }

    final JSONStreamWriterContext endNode(SchemaContext schema, Writer writer, String indent) throws IOException {
        if (!this.emittedMyself && this.mandatory) {
            this.emitMyself(schema, writer, indent);
        }
        if (this.emittedMyself) {
            this.emitEnd(writer);
        }
        return this.parent;
    }
}

