/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.opendaylight.yangtools.yang.data.codec.gson.AbstractJSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONLeafrefCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStringIdentityrefCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.IdentityrefType;
import org.opendaylight.yangtools.yang.model.util.InstanceIdentifierType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class JSONCodecFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JSONCodecFactory.class);
    private static final JSONCodec<Object> LEAFREF_DEFAULT_CODEC = new JSONLeafrefCodec();
    private static final JSONCodec<Object> NULL_CODEC = new JSONCodec<Object>(){

        public Object deserialize(String input) {
            return null;
        }

        public String serialize(Object input) {
            return null;
        }

        @Override
        public boolean needQuotes() {
            return false;
        }
    };
    private final LoadingCache<TypeDefinition<?>, JSONCodec<Object>> codecs = CacheBuilder.newBuilder().softValues().build(new CacheLoader<TypeDefinition<?>, JSONCodec<Object>>(){

        public JSONCodec<Object> load(TypeDefinition<?> key) throws Exception {
            TypeDefinition type = JSONCodecFactory.resolveBaseTypeFrom(key);
            if (type instanceof InstanceIdentifierType) {
                return JSONCodecFactory.this.iidCodec;
            }
            if (type instanceof IdentityrefType) {
                return JSONCodecFactory.this.idrefCodec;
            }
            if (type instanceof LeafrefTypeDefinition) {
                return LEAFREF_DEFAULT_CODEC;
            }
            TypeDefinitionAwareCodec codec = TypeDefinitionAwareCodec.from((TypeDefinition)type);
            if (codec == null) {
                LOG.debug("Codec for type \"{}\" is not implemented yet.", (Object)type.getQName().getLocalName());
                return NULL_CODEC;
            }
            return AbstractJSONCodec.create(codec);
        }
    });
    private final SchemaContext schemaContext;
    private final JSONCodec<?> iidCodec;
    private final JSONCodec<?> idrefCodec;

    private static TypeDefinition<?> resolveBaseTypeFrom(TypeDefinition<?> type) {
        TypeDefinition superType = type;
        while (superType.getBaseType() != null) {
            superType = superType.getBaseType();
        }
        return superType;
    }

    private JSONCodecFactory(SchemaContext context) {
        this.schemaContext = (SchemaContext)Preconditions.checkNotNull((Object)context);
        this.iidCodec = new JSONStringInstanceIdentifierCodec(context);
        this.idrefCodec = new JSONStringIdentityrefCodec(context);
    }

    public static JSONCodecFactory create(SchemaContext context) {
        return new JSONCodecFactory(context);
    }

    SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    JSONCodec<Object> codecFor(TypeDefinition<?> typeDefinition) {
        return (JSONCodec)this.codecs.getUnchecked(typeDefinition);
    }
}

