/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterInvisibleContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterListContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterNamedObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterObjectContext;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONStreamWriterRootContext;
import org.opendaylight.yangtools.yang.data.impl.codec.SchemaTracker;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class JSONNormalizedNodeStreamWriter
implements NormalizedNodeStreamWriter {
    private static final boolean DEFAULT_EMIT_EMPTY_CONTAINERS = true;
    private static final CharMatcher NEWLINE_CHAR_MATCHER = CharMatcher.is((char)'\n');
    private static final CharMatcher BACKSPACE_CHAR_MATCHER = CharMatcher.is((char)'\b');
    private static final CharMatcher FORMFEED_CHAR_MATCHER = CharMatcher.is((char)'\f');
    private static final CharMatcher CR_CHAR_MATCHER = CharMatcher.is((char)'\r');
    private static final CharMatcher TAB_CHAR_MATCHER = CharMatcher.is((char)'\t');
    private static final CharMatcher QUOTE_CHAR_MATCHER = CharMatcher.is((char)'\"');
    private static final CharMatcher REVERSE_SOLIDUS_CHAR_MATCHER = CharMatcher.is((char)'\\');
    private final SchemaTracker tracker;
    private final JSONCodecFactory codecs;
    private final Writer writer;
    private final String indent;
    private JSONStreamWriterContext context;

    private JSONNormalizedNodeStreamWriter(JSONCodecFactory codecFactory, SchemaPath path, Writer writer, URI initialNs, int indentSize) {
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer);
        Preconditions.checkArgument((indentSize >= 0 ? 1 : 0) != 0, (Object)"Indent size must be non-negative");
        this.indent = indentSize != 0 ? Strings.repeat((String)" ", (int)indentSize) : null;
        this.codecs = (JSONCodecFactory)Preconditions.checkNotNull((Object)codecFactory);
        this.tracker = SchemaTracker.create((SchemaContext)codecFactory.getSchemaContext(), (SchemaPath)path);
        this.context = new JSONStreamWriterRootContext(initialNs);
    }

    public static NormalizedNodeStreamWriter create(SchemaContext schemaContext, Writer writer) {
        return new JSONNormalizedNodeStreamWriter(JSONCodecFactory.create(schemaContext), SchemaPath.ROOT, writer, null, 0);
    }

    public static NormalizedNodeStreamWriter create(SchemaContext schemaContext, SchemaPath path, Writer writer) {
        return new JSONNormalizedNodeStreamWriter(JSONCodecFactory.create(schemaContext), path, writer, null, 0);
    }

    public static NormalizedNodeStreamWriter create(SchemaContext schemaContext, SchemaPath path, URI initialNs, Writer writer) {
        return new JSONNormalizedNodeStreamWriter(JSONCodecFactory.create(schemaContext), path, writer, initialNs, 0);
    }

    public static NormalizedNodeStreamWriter create(SchemaContext schemaContext, Writer writer, int indentSize) {
        return new JSONNormalizedNodeStreamWriter(JSONCodecFactory.create(schemaContext), SchemaPath.ROOT, writer, null, indentSize);
    }

    public static NormalizedNodeStreamWriter create(JSONCodecFactory codecFactory, Writer writer, int indentSize) {
        return new JSONNormalizedNodeStreamWriter(codecFactory, SchemaPath.ROOT, writer, null, indentSize);
    }

    public void leafNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        LeafSchemaNode schema = this.tracker.leafNode(name);
        JSONCodec<Object> codec = this.codecs.codecFor(schema.getType());
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer, this.indent);
        this.context.writeChildJsonIdentifier(this.codecs.getSchemaContext(), this.writer, name.getNodeType());
        this.writeValue((String)codec.serialize(value), codec.needQuotes());
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startLeafSet(name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void leafSetEntryNode(Object value) throws IOException {
        LeafListSchemaNode schema = this.tracker.leafSetEntryNode();
        JSONCodec<Object> codec = this.codecs.codecFor(schema.getType());
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer, this.indent);
        this.writeValue((String)codec.serialize(value), codec.needQuotes());
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        ContainerSchemaNode schema = this.tracker.startContainerNode(name);
        this.context = new JSONStreamWriterNamedObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, true);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)name, true);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.tracker.startListItem((YangInstanceIdentifier.PathArgument)identifier);
        this.context = new JSONStreamWriterObjectContext(this.context, (YangInstanceIdentifier.PathArgument)identifier, true);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.tracker.startList((YangInstanceIdentifier.PathArgument)name);
        this.context = new JSONStreamWriterListContext(this.context, name);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) {
        this.tracker.startChoiceNode(name);
        this.context = new JSONStreamWriterInvisibleContext(this.context);
    }

    public void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        this.tracker.startAugmentationNode(identifier);
        this.context = new JSONStreamWriterInvisibleContext(this.context);
    }

    public void anyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Object value) throws IOException {
        AnyXmlSchemaNode schema = this.tracker.anyxmlNode(name);
        this.context.emittingChild(this.codecs.getSchemaContext(), this.writer, this.indent);
        this.context.writeChildJsonIdentifier(this.codecs.getSchemaContext(), this.writer, name.getNodeType());
        this.writeValue(String.valueOf(value), true);
    }

    public void endNode() throws IOException {
        this.tracker.endNode();
        this.context = this.context.endNode(this.codecs.getSchemaContext(), this.writer, this.indent);
    }

    private void writeValue(String str, boolean needQuotes) throws IOException {
        if (needQuotes) {
            this.writer.append('\"');
            String escaped = JSONNormalizedNodeStreamWriter.replaceAllIllegalChars(str);
            this.writer.append(escaped);
            this.writer.append('\"');
        } else {
            this.writer.append(str);
        }
    }

    @VisibleForTesting
    static String replaceAllIllegalChars(String string) {
        String result = REVERSE_SOLIDUS_CHAR_MATCHER.replaceFrom((CharSequence)string, (CharSequence)"\\\\");
        result = BACKSPACE_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\b");
        result = FORMFEED_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\f");
        result = NEWLINE_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\n");
        result = CR_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\r");
        result = TAB_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\t");
        result = QUOTE_CHAR_MATCHER.replaceFrom((CharSequence)result, (CharSequence)"\\\"");
        return result;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

