/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.codec.gson.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

class ListEntryNodeDataWithSchema
extends CompositeNodeDataWithSchema {
    private final Map<QName, SimpleNodeDataWithSchema> qNameToKeys = new HashMap<QName, SimpleNodeDataWithSchema>();

    public ListEntryNodeDataWithSchema(DataSchemaNode schema) {
        super(schema);
    }

    @Override
    public void addChild(AbstractNodeDataWithSchema newChild) {
        DataSchemaNode childSchema = newChild.getSchema();
        if (childSchema instanceof LeafSchemaNode && this.isPartOfKey((LeafSchemaNode)childSchema)) {
            this.qNameToKeys.put(childSchema.getQName(), (SimpleNodeDataWithSchema)newChild);
        }
        super.addChild(newChild);
    }

    private boolean isPartOfKey(LeafSchemaNode potentialKey) {
        List keys = ((ListSchemaNode)this.getSchema()).getKeyDefinition();
        for (QName qName : keys) {
            if (!qName.equals((Object)potentialKey.getQName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer) throws IOException {
        List keyDef = ((ListSchemaNode)this.getSchema()).getKeyDefinition();
        if (keyDef.isEmpty()) {
            writer.startUnkeyedListItem(this.provideNodeIdentifier(), this.childSizeHint());
            super.write(writer);
            writer.endNode();
            return;
        }
        Preconditions.checkState((keyDef.size() == this.qNameToKeys.size() ? 1 : 0) != 0, (String)"Input is missing some of the keys of %s", (Object[])new Object[]{this.getSchema().getQName()});
        LinkedHashMap<QName, Object> predicates = new LinkedHashMap<QName, Object>();
        for (QName qname : keyDef) {
            predicates.put(qname, this.qNameToKeys.get(qname).getValue());
        }
        writer.startMapEntryNode(new YangInstanceIdentifier.NodeIdentifierWithPredicates(this.getSchema().getQName(), predicates), this.childSizeHint());
        super.write(writer);
        writer.endNode();
    }
}

